/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints;

import java.awt.Component;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.modules.profiler.api.EditorContext;
import org.netbeans.modules.profiler.api.EditorSupport;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.api.java.JavaProfilerSource;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.ppoints.Bundle;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ProfilingPointFactory;
import org.netbeans.modules.profiler.ppoints.ProfilingPointsManager;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class Utils {
    private static final String PROJECT_DIRECTORY_MARK = "{$projectDirectory}";
    public static final ImageIcon EMPTY_ICON = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/profiler/resources/empty16.gif", (boolean)false);
    private static final ProjectPresenterRenderer projectRenderer = new ProjectPresenterRenderer();
    private static final ProjectPresenterListRenderer projectListRenderer = new ProjectPresenterListRenderer();
    private static final EnhancedTableCellRenderer scopeRenderer = new ProfilingPointScopeRenderer();
    private static final ProfilingPointPresenterRenderer presenterRenderer = new ProfilingPointPresenterRenderer();
    private static final ProfilingPointPresenterListRenderer presenterListRenderer = new ProfilingPointPresenterListRenderer();
    private static final DateFormat fullDateFormat = DateFormat.getDateTimeInstance(2, 2);
    private static final DateFormat todayDateFormat = DateFormat.getTimeInstance(2);
    private static final DateFormat todayDateFormatHiRes = new SimpleDateFormat("HH:mm:ss.SSS");
    private static final DateFormat dayDateFormat = DateFormat.getDateInstance(2);

    public static String getAbsolutePath(Lookup.Provider project, String sourceFileRelativePath) {
        if (project == null) {
            File file = new File(sourceFileRelativePath);
            return file.exists() ? sourceFileRelativePath : null;
        }
        return new File(sourceFileRelativePath.replace(PROJECT_DIRECTORY_MARK, FileUtil.toFile((FileObject)ProjectUtilities.getProjectDirectory((Lookup.Provider)project)).getAbsolutePath())).getAbsolutePath();
    }

    public static String getClassName(CodeProfilingPoint.Location location) {
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        int documentOffset = Utils.getDocumentOffset(location);
        if (documentOffset == -1) {
            return null;
        }
        JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)fileObject);
        if (src == null) {
            return null;
        }
        SourceClassInfo sci = src.getEnclosingClass(documentOffset);
        if (sci == null) {
            return null;
        }
        return sci.getQualifiedName();
    }

    public static String getMethodName(CodeProfilingPoint.Location location) {
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return null;
        }
        int documentOffset = Utils.getDocumentOffset(location);
        if (documentOffset == -1) {
            return null;
        }
        JavaProfilerSource src = JavaProfilerSource.createFrom((FileObject)fileObject);
        if (src == null) {
            return null;
        }
        SourceMethodInfo smi = src.getEnclosingMethod(documentOffset);
        if (smi == null) {
            return null;
        }
        return smi.getName();
    }

    public static CodeProfilingPoint.Location getCurrentLocation(int lineOffset) {
        EditorContext mostActiveContext = EditorSupport.getMostActiveJavaEditorContext();
        if (mostActiveContext == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        FileObject mostActiveJavaSource = mostActiveContext.getFileObject();
        if (mostActiveJavaSource == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        File currentFile = FileUtil.toFile((FileObject)mostActiveJavaSource);
        if (currentFile == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        String fileName = currentFile.getAbsolutePath();
        int lineNumber = EditorSupport.getLineForOffset((FileObject)mostActiveJavaSource, (int)mostActiveContext.getTextComponent().getCaret().getDot()) + 1;
        if (lineNumber == -1) {
            lineNumber = 1;
        }
        return new CodeProfilingPoint.Location(fileName, lineNumber, lineOffset);
    }

    public static Lookup.Provider getCurrentProject() {
        Lookup.Provider currentProject = Utils.getMostActiveJavaProject();
        if (currentProject == null) {
            currentProject = ProjectUtilities.getMainProject();
        }
        return currentProject;
    }

    public static CodeProfilingPoint.Location getCurrentSelectionEndLocation(int lineOffset) {
        EditorContext mostActiveContext = EditorSupport.getMostActiveJavaEditorContext();
        if (mostActiveContext == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        FileObject mostActiveJavaSource = mostActiveContext.getFileObject();
        if (mostActiveJavaSource == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        JTextComponent mostActiveTextComponent = mostActiveContext.getTextComponent();
        if (mostActiveTextComponent.getSelectedText() == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        String fileName = FileUtil.toFile((FileObject)mostActiveJavaSource).getAbsolutePath();
        int lineNumber = EditorSupport.getLineForOffset((FileObject)mostActiveJavaSource, (int)mostActiveTextComponent.getSelectionEnd()) + 1;
        if (lineNumber == -1) {
            lineNumber = 1;
        }
        return new CodeProfilingPoint.Location(fileName, lineNumber, lineOffset);
    }

    public static CodeProfilingPoint.Location[] getCurrentSelectionLocations() {
        EditorContext mostActiveContext = EditorSupport.getMostActiveJavaEditorContext();
        if (mostActiveContext == null) {
            return new CodeProfilingPoint.Location[0];
        }
        FileObject mostActiveJavaSource = mostActiveContext.getFileObject();
        if (mostActiveJavaSource == null) {
            return new CodeProfilingPoint.Location[0];
        }
        JTextComponent mostActiveTextComponent = mostActiveContext.getTextComponent();
        if (mostActiveTextComponent.getSelectedText() == null) {
            return new CodeProfilingPoint.Location[0];
        }
        File file = FileUtil.toFile((FileObject)mostActiveJavaSource);
        if (file == null) {
            return new CodeProfilingPoint.Location[0];
        }
        String fileName = file.getAbsolutePath();
        int startLineNumber = EditorSupport.getLineForOffset((FileObject)mostActiveJavaSource, (int)mostActiveTextComponent.getSelectionStart()) + 1;
        if (startLineNumber == -1) {
            startLineNumber = 1;
        }
        int endLineNumber = EditorSupport.getLineForOffset((FileObject)mostActiveJavaSource, (int)(mostActiveTextComponent.getSelectionEnd() - 1)) + 1;
        endLineNumber = Math.max(startLineNumber, endLineNumber);
        return new CodeProfilingPoint.Location[]{new CodeProfilingPoint.Location(fileName, startLineNumber, Integer.MIN_VALUE), new CodeProfilingPoint.Location(fileName, endLineNumber, Integer.MAX_VALUE)};
    }

    public static CodeProfilingPoint.Location getCurrentSelectionStartLocation(int lineOffset) {
        EditorContext mostActiveContext = EditorSupport.getMostActiveJavaEditorContext();
        if (mostActiveContext == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        FileObject mostActiveJavaSource = mostActiveContext.getFileObject();
        if (mostActiveJavaSource == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        JTextComponent mostActiveTextComponent = mostActiveContext.getTextComponent();
        if (mostActiveTextComponent.getSelectedText() == null) {
            return CodeProfilingPoint.Location.EMPTY;
        }
        String fileName = FileUtil.toFile((FileObject)mostActiveJavaSource).getAbsolutePath();
        int lineNumber = EditorSupport.getLineForOffset((FileObject)mostActiveJavaSource, (int)mostActiveTextComponent.getSelectionStart()) + 1;
        if (lineNumber == -1) {
            lineNumber = 1;
        }
        return new CodeProfilingPoint.Location(fileName, lineNumber, lineOffset);
    }

    public static int getDocumentOffset(CodeProfilingPoint.Location location) {
        int lineOffset;
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return -1;
        }
        int linePosition = EditorSupport.getOffsetForLine((FileObject)fileObject, (int)(location.getLine() - 1));
        if (linePosition == -1) {
            return -1;
        }
        if (location.isLineStart()) {
            lineOffset = 0;
        } else if (location.isLineEnd()) {
            lineOffset = EditorSupport.getOffsetForLine((FileObject)fileObject, (int)location.getLine()) - linePosition - 1;
            if (lineOffset == -1) {
                return -1;
            }
        } else {
            lineOffset = location.getOffset();
        }
        return linePosition + lineOffset;
    }

    public static double getDurationInMicroSec(long startTimestamp, long endTimestamp) {
        ProfilingSessionStatus session = Profiler.getDefault().getTargetAppRunner().getProfilingSessionStatus();
        double countsInMicroSec = (double)session.timerCountsInSecond[0] / 1000000.0;
        return (double)(endTimestamp - startTimestamp) / countsInMicroSec;
    }

    public static Line getEditorLine(CodeProfilingPoint profilingPoint, CodeProfilingPoint.Annotation annotation) {
        return Utils.getEditorLine(profilingPoint.getLocation(annotation));
    }

    public static Line getEditorLine(CodeProfilingPoint.Location location) {
        if (location == null) {
            return null;
        }
        String url = location.getFile();
        if (url == null) {
            return null;
        }
        FileObject file = null;
        try {
            file = URLMapper.findFileObject((URL)new File(url).toURI().toURL());
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        if (file == null) {
            return null;
        }
        DataObject dao = null;
        try {
            dao = DataObject.find((FileObject)file);
        }
        catch (DataObjectNotFoundException ex) {
            return null;
        }
        LineCookie lineCookie = (LineCookie)dao.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return null;
        }
        Line.Set lineSet = lineCookie.getLineSet();
        if (lineSet == null) {
            return null;
        }
        try {
            return lineSet.getCurrent(location.getLine() - 1);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isValidLocation(CodeProfilingPoint.Location location) {
        CodeProfilingPoint.Location startLocation;
        String methodName = Utils.getMethodName(location);
        if (methodName == null) {
            return false;
        }
        if (location.isLineStart()) {
            return true;
        }
        if (location.isLineEnd() && methodName.equals(Utils.getMethodName(startLocation = new CodeProfilingPoint.Location(location.getFile(), location.getLine(), Integer.MIN_VALUE)))) {
            return true;
        }
        Line line = Utils.getEditorLine(location);
        if (line == null) {
            return false;
        }
        String lineText = line.getText();
        if (lineText == null) {
            return false;
        }
        return !(lineText = lineText.trim()).endsWith("{") || lineText.indexOf(123) != lineText.lastIndexOf(123);
    }

    public static void checkLocation(final CodeProfilingPoint.Single ppoint) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                if (!Utils.isValidLocation(ppoint.getLocation())) {
                    ProfilerDialogs.displayWarning((String)Bundle.Utils_InvalidPPLocationMsg(ppoint.getName()));
                }
            }
        });
    }

    public static void checkLocation(final CodeProfilingPoint.Paired ppoint) {
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                if (!Utils.isValidLocation(ppoint.getStartLocation())) {
                    ProfilerDialogs.displayWarning((String)Bundle.Utils_InvalidPPLocationMsg(ppoint.getName()));
                } else if (ppoint.usesEndLocation() && !Utils.isValidLocation(ppoint.getEndLocation())) {
                    ProfilerDialogs.displayWarning((String)Bundle.Utils_InvalidPPLocationMsg(ppoint.getName()));
                }
            }
        });
    }

    public static Lookup.Provider getMostActiveJavaProject() {
        EditorContext mostActiveContext = EditorSupport.getMostActiveJavaEditorContext();
        if (mostActiveContext == null) {
            return null;
        }
        FileObject mostActiveFileObject = mostActiveContext.getFileObject();
        if (mostActiveFileObject == null) {
            return null;
        }
        return ProjectUtilities.getProject((FileObject)mostActiveFileObject);
    }

    public static ListCellRenderer getPresenterListRenderer() {
        return presenterListRenderer;
    }

    public static EnhancedTableCellRenderer getPresenterRenderer() {
        return presenterRenderer;
    }

    public static CodeProfilingPoint[] getProfilingPointsOnLine(CodeProfilingPoint.Location location) {
        if (location == null || location == CodeProfilingPoint.Location.EMPTY) {
            return new CodeProfilingPoint[0];
        }
        File file = new File(location.getFile());
        int lineNumber = location.getLine();
        ArrayList<CodeProfilingPoint> lineProfilingPoints = new ArrayList<CodeProfilingPoint>();
        List<CodeProfilingPoint> profilingPoints = ProfilingPointsManager.getDefault().getProfilingPoints(CodeProfilingPoint.class, null, false);
        block0: for (CodeProfilingPoint profilingPoint : profilingPoints) {
            for (CodeProfilingPoint.Annotation annotation : profilingPoint.getAnnotations()) {
                CodeProfilingPoint.Location loc = profilingPoint.getLocation(annotation);
                if (loc.getLine() != lineNumber || !new File(loc.getFile()).equals(file)) continue;
                lineProfilingPoints.add(profilingPoint);
                continue block0;
            }
        }
        return lineProfilingPoints.toArray(new CodeProfilingPoint[lineProfilingPoints.size()]);
    }

    public static ListCellRenderer getProjectListRenderer() {
        return projectListRenderer;
    }

    public static EnhancedTableCellRenderer getProjectRenderer() {
        return projectRenderer;
    }

    public static String getRelativePath(Lookup.Provider project, String sourceFileAbsolutePath) {
        if (project == null) {
            return sourceFileAbsolutePath;
        }
        FileObject projectDirectory = ProjectUtilities.getProjectDirectory((Lookup.Provider)project);
        String projectDirectoryAbsolutePath = FileUtil.toFile((FileObject)projectDirectory).getAbsolutePath();
        if (!sourceFileAbsolutePath.startsWith(projectDirectoryAbsolutePath)) {
            return sourceFileAbsolutePath;
        }
        File file = FileUtil.normalizeFile((File)new File(sourceFileAbsolutePath));
        return "{$projectDirectory}/" + FileUtil.getRelativePath((FileObject)projectDirectory, (FileObject)FileUtil.toFileObject((File)file));
    }

    public static EnhancedTableCellRenderer getScopeRenderer() {
        return scopeRenderer;
    }

    public static String getThreadClassName(int threadID) {
        return null;
    }

    public static String getThreadName(int threadID) {
        return "&lt;unknown thread, id=" + threadID + "&gt;";
    }

    public static long getTimeInMillis(long hiResTimeStamp) {
        ProfilingSessionStatus session = Profiler.getDefault().getTargetAppRunner().getProfilingSessionStatus();
        long statupInCounts = session.startupTimeInCounts;
        long startupMillis = session.startupTimeMillis;
        long countsInMillis = session.timerCountsInSecond[0] / 1000L;
        return startupMillis + (hiResTimeStamp - statupInCounts) / countsInMillis;
    }

    public static String getUniqueName(String name, String nameSuffix, Lookup.Provider project) {
        List<ProfilingPoint> projectProfilingPoints = ProfilingPointsManager.getDefault().getProfilingPoints(project, false, true);
        HashSet<String> projectProfilingPointsNames = new HashSet<String>();
        for (ProfilingPoint projectProfilingPoint : projectProfilingPoints) {
            projectProfilingPointsNames.add(projectProfilingPoint.getName());
        }
        int index = 0;
        String indexStr = "";
        while (projectProfilingPointsNames.contains(name + indexStr + nameSuffix)) {
            indexStr = " " + Integer.toString(++index);
        }
        return name + indexStr + nameSuffix;
    }

    public static String formatLocalProfilingPointTime(long timestamp) {
        Date now = new Date();
        Date date = new Date(timestamp);
        if (dayDateFormat.format(now).equals(dayDateFormat.format(date))) {
            return todayDateFormat.format(date);
        }
        return fullDateFormat.format(date);
    }

    public static String formatProfilingPointTime(long timestamp) {
        long timestampInMillis = Utils.getTimeInMillis(timestamp);
        Date now = new Date();
        Date date = new Date(timestampInMillis);
        if (dayDateFormat.format(now).equals(dayDateFormat.format(date))) {
            return todayDateFormat.format(date);
        }
        return fullDateFormat.format(date);
    }

    public static String formatProfilingPointTimeHiRes(long timestamp) {
        long timestampInMillis = Utils.getTimeInMillis(timestamp);
        Date now = new Date();
        Date date = new Date(timestampInMillis);
        if (dayDateFormat.format(now).equals(dayDateFormat.format(date))) {
            return todayDateFormatHiRes.format(date);
        }
        return todayDateFormatHiRes.format(date) + " " + dayDateFormat.format(date);
    }

    public static Font getTitledBorderFont(TitledBorder tb) {
        Font font = tb.getTitleFont();
        if (font == null) {
            font = UIManager.getFont("TitledBorder.font");
        }
        if (font == null) {
            font = new JLabel().getFont();
        }
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        return font;
    }

    public static void openLocation(CodeProfilingPoint.Location location) {
        File file = FileUtil.normalizeFile((File)new File(location.getFile()));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null || !fileObject.isValid()) {
            return;
        }
        int documentOffset = Utils.getDocumentOffset(location);
        if (documentOffset == -1) {
            ProfilerDialogs.displayError((String)Bundle.Utils_CannotOpenSourceMsg());
            return;
        }
        GoToSource.openFile((FileObject)fileObject, (int)documentOffset);
    }

    private static class ProjectPresenterRenderer
    extends LabelTableCellRenderer {
        private Font font;

        public ProjectPresenterRenderer() {
            super(10);
            this.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
            this.font = this.label.getFont();
        }

        public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new ProjectPresenterRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        protected void setValue(JTable table, Object value, int row, int column) {
            if (value != null && (value instanceof Lookup.Provider || value instanceof ProfilingPoint)) {
                if (table != null) {
                    this.setFont(table.getFont());
                }
                if (value instanceof ProfilingPoint) {
                    this.label.setEnabled(((ProfilingPoint)value).isEnabled());
                    value = ((ProfilingPoint)value).getProject();
                } else {
                    this.label.setEnabled(true);
                }
                Icon icon = ProjectUtilities.getIcon((Lookup.Provider)((Lookup.Provider)value));
                this.label.setText(ProjectUtilities.getDisplayName((Lookup.Provider)((Lookup.Provider)value)));
                this.label.setIcon(table.isEnabled() ? icon : new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)icon).getImage())));
                this.label.setFont(ProjectUtilities.getMainProject() == value ? this.font.deriveFont(1) : this.font);
            } else {
                this.label.setText("");
                this.label.setIcon(null);
                this.label.setEnabled(true);
            }
        }
    }

    private static class ProjectPresenterListRenderer
    extends DefaultListCellRenderer {
        private Renderer renderer = new Renderer();
        private boolean firstFontSet = false;

        private ProjectPresenterListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel rendererOrig = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.renderer.setComponentOrientation(rendererOrig.getComponentOrientation());
            this.renderer.setFontEx(rendererOrig.getFont());
            this.renderer.setOpaque(rendererOrig.isOpaque());
            this.renderer.setForeground(rendererOrig.getForeground());
            this.renderer.setBackground(rendererOrig.getBackground());
            this.renderer.setEnabled(rendererOrig.isEnabled());
            this.renderer.setBorder(rendererOrig.getBorder());
            if (value != null && value instanceof Lookup.Provider) {
                this.renderer.setText(ProjectUtilities.getDisplayName((Lookup.Provider)((Lookup.Provider)value)));
                this.renderer.setIcon(ProjectUtilities.getIcon((Lookup.Provider)((Lookup.Provider)value)));
                if (ProjectUtilities.getMainProject() == value) {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(1));
                } else {
                    this.renderer.setFontEx(this.renderer.getFont().deriveFont(0));
                }
            } else {
                this.renderer.setText(rendererOrig.getText());
                this.renderer.setIcon(EMPTY_ICON);
            }
            return this.renderer;
        }

        private static class Renderer
        extends DefaultListCellRenderer {
            private Renderer() {
            }

            @Override
            public void setFont(Font font) {
            }

            public void setFontEx(Font font) {
                super.setFont(font);
            }
        }
    }

    private static class ProfilingPointScopeRenderer
    extends LabelTableCellRenderer {
        public ProfilingPointScopeRenderer() {
            super(0);
            this.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12));
        }

        public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new ProfilingPointScopeRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        protected void setValue(JTable table, Object value, int row, int column) {
            this.label.setText("");
            if (value instanceof ProfilingPoint) {
                this.label.setIcon(((ProfilingPoint)value).getFactory().getScopeIcon());
                this.label.setEnabled(((ProfilingPoint)value).isEnabled());
            } else if (value instanceof ProfilingPointFactory) {
                this.label.setIcon(((ProfilingPointFactory)value).getScopeIcon());
                this.label.setEnabled(true);
            } else {
                this.label.setIcon(Icons.getIcon((String)"GeneralIcons.Empty"));
                this.label.setEnabled(true);
            }
        }
    }

    private static class ProfilingPointPresenterRenderer
    extends LabelTableCellRenderer {
        public ProfilingPointPresenterRenderer() {
            super(10);
            this.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 5));
        }

        public Component getTableCellRendererComponentPersistent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return new ProfilingPointPresenterRenderer().getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }

        protected void setValue(JTable table, Object value, int row, int column) {
            if (table != null) {
                this.setFont(table.getFont());
            }
            if (value instanceof ProfilingPoint) {
                boolean enabled = ((ProfilingPoint)value).isEnabled();
                this.label.setText(((ProfilingPoint)value).getName());
                this.label.setIcon(enabled ? ((ProfilingPoint)value).getFactory().getIcon() : ((ProfilingPoint)value).getFactory().getDisabledIcon());
                this.label.setEnabled(enabled);
            } else if (value instanceof ProfilingPointFactory) {
                this.label.setText(((ProfilingPointFactory)value).getType());
                this.label.setIcon(((ProfilingPointFactory)value).getIcon());
                this.label.setEnabled(true);
            } else {
                this.label.setText("");
                this.label.setIcon(null);
                this.label.setEnabled(true);
            }
        }
    }

    private static class ProfilingPointPresenterListRenderer
    extends DefaultListCellRenderer {
        private ProfilingPointPresenterListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            renderer.setBorder(BorderFactory.createEmptyBorder(1, 7, 1, 5));
            if (value instanceof ProfilingPoint) {
                boolean enabled = ((ProfilingPoint)value).isEnabled();
                renderer.setText(((ProfilingPoint)value).getName());
                renderer.setIcon(enabled ? ((ProfilingPoint)value).getFactory().getIcon() : ((ProfilingPoint)value).getFactory().getDisabledIcon());
                renderer.setEnabled(enabled);
            } else if (value instanceof ProfilingPointFactory) {
                renderer.setText(((ProfilingPointFactory)value).getType());
                renderer.setIcon(((ProfilingPointFactory)value).getIcon());
                renderer.setEnabled(true);
            } else {
                renderer.setIcon(null);
                renderer.setEnabled(true);
            }
            return renderer;
        }
    }

    private static class JavaEditorContext {
        private Document document;
        private FileObject fileObject;
        private JTextComponent textComponent;

        public JavaEditorContext(JTextComponent textComponent, Document document, FileObject fileObject) {
            this.textComponent = textComponent;
            this.document = document;
            this.fileObject = fileObject;
        }

        public Document getDocument() {
            return this.document;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }

        public JTextComponent getTextComponent() {
            return this.textComponent;
        }
    }
}

