/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.ppoints.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProjectUtilities;
import org.netbeans.modules.profiler.ppoints.CodeProfilingPoint;
import org.netbeans.modules.profiler.ppoints.ui.Bundle;
import org.netbeans.modules.profiler.ppoints.ui.LocationCustomizer;
import org.netbeans.modules.profiler.ppoints.ui.ValidityAwarePanel;
import org.netbeans.modules.profiler.ppoints.ui.ValidityListener;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class LoadGeneratorCustomizer
extends ValidityAwarePanel
implements ActionListener,
ChangeListener,
DocumentListener,
ValidityListener,
HelpCtx.Provider {
    private static final String HELP_CTX_KEY = "LoadGeneratorCustomizer.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("LoadGeneratorCustomizer.HelpCtx");
    private static int defaultTextComponentHeight = -1;
    private static JFileChooser fileChooser;
    private JButton scriptButton;
    private JLabel captionLabel;
    private JLabel locationBeginHeaderLabel;
    private JLabel locationEndHeaderLabel;
    private JLabel nameLabel;
    private JLabel scriptLabel;
    private JLabel settingsHeaderLabel;
    private JLabel stopLabel;
    private JPanel captionPanel;
    private JPanel firstLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel secondLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JPanel thirdLineCaptionSpacer = new JPanel(new FlowLayout(3, 0, 0));
    private JRadioButton stopDefineRadio;
    private JRadioButton stopOnStopRadio;
    private JSeparator locationBeginHeaderSeparator;
    private JSeparator locationEndHeaderSeparator;
    private JSeparator settingsHeaderSeparator;
    private JTextField nameTextField;
    private JTextField scriptTextField;
    private LocationCustomizer locationBeginCustomizer;
    private LocationCustomizer locationEndCustomizer;
    private Lookup.Provider project;

    public LoadGeneratorCustomizer(String caption, Icon icon) {
        this.initComponents(caption, icon);
        this.normalizeCaptionAreaWidth();
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    @Override
    public Component getInitialFocusTarget() {
        return this.nameTextField;
    }

    public void setPPEndLocation(CodeProfilingPoint.Location location) {
        if (location == null) {
            this.stopOnStopRadio.setSelected(true);
            this.locationEndCustomizer.setPPLocation(CodeProfilingPoint.Location.EMPTY);
        } else {
            this.stopDefineRadio.setSelected(true);
            this.locationEndCustomizer.setPPLocation(location);
        }
    }

    public CodeProfilingPoint.Location getPPEndLocation() {
        if (this.stopOnStopRadio.isSelected()) {
            return null;
        }
        return this.locationEndCustomizer.getPPLocation();
    }

    public void setPPName(String ppName) {
        this.nameTextField.setText(ppName);
    }

    public String getPPName() {
        return this.nameTextField.getText();
    }

    public void setPPStartLocation(CodeProfilingPoint.Location location) {
        this.locationBeginCustomizer.setPPLocation(location);
    }

    public CodeProfilingPoint.Location getPPStartLocation() {
        return this.locationBeginCustomizer.getPPLocation();
    }

    public int getPreferredCaptionAreaWidth() {
        int ownCaptionAreaWidth = this.nameLabel.getPreferredSize().width - 12;
        ownCaptionAreaWidth = Math.max(ownCaptionAreaWidth, this.scriptLabel.getPreferredSize().width);
        ownCaptionAreaWidth = Math.max(ownCaptionAreaWidth, this.stopLabel.getPreferredSize().width);
        return Math.max(ownCaptionAreaWidth, this.locationBeginCustomizer.getPreferredCaptionAreaWidth());
    }

    public void setProject(Lookup.Provider aProject) {
        this.project = aProject;
    }

    public void setScriptFile(String fileName) {
        this.scriptTextField.setText(fileName);
    }

    public String getScriptFile() {
        return this.scriptTextField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.scriptButton) {
            JFileChooser fileChooser = this.getFileChooser();
            Object currentDir = null;
            String scriptPath = this.scriptTextField.getText();
            if (scriptPath.length() > 0) {
                fileChooser.setCurrentDirectory(new File(scriptPath).getParentFile());
            } else {
                fileChooser.setCurrentDirectory(FileUtil.toFile((FileObject)ProjectUtilities.getProjectDirectory((Lookup.Provider)this.project)));
            }
            if (fileChooser.showOpenDialog(null) == 0) {
                this.scriptTextField.setText(fileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public void initComponents(String caption, Icon icon) {
        this.setLayout(new GridBagLayout());
        this.captionPanel = new JPanel(new BorderLayout(0, 0));
        this.captionPanel.setOpaque(true);
        this.captionPanel.setBackground(UIUtils.getProfilerResultsBackground());
        this.captionLabel = new JLabel(caption, icon, 10);
        this.captionLabel.setFont(this.captionLabel.getFont().deriveFont(1));
        this.captionLabel.setOpaque(false);
        this.captionLabel.setBorder(BorderFactory.createEmptyBorder(6, 8, 6, 6));
        this.captionPanel.add((Component)this.captionLabel, "West");
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 16, 0);
        this.add((Component)this.captionPanel, constraints);
        this.nameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)Bundle.LoadGeneratorCustomizer_NameLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 8, 10, 5);
        this.add((Component)this.nameLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.firstLineCaptionSpacer, constraints);
        this.nameTextField = new JTextField(""){

            @Override
            public Dimension getPreferredSize() {
                return LoadGeneratorCustomizer.this.getParent() instanceof JViewport ? this.getMinimumSize() : new Dimension(400, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }
        };
        this.nameLabel.setLabelFor(this.nameTextField);
        this.nameTextField.getDocument().addDocumentListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 10, 13);
        this.add((Component)this.nameTextField, constraints);
        JPanel settingsHeaderContainer = new JPanel(new GridBagLayout());
        this.settingsHeaderLabel = new JLabel(Bundle.LoadGeneratorCustomizer_SettingsLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        settingsHeaderContainer.add((Component)this.settingsHeaderLabel, constraints);
        this.settingsHeaderSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        settingsHeaderContainer.add((Component)this.settingsHeaderSeparator, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)settingsHeaderContainer, constraints);
        JPanel scriptSettingsContainer = new JPanel(new GridBagLayout());
        this.scriptLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.scriptLabel, (String)Bundle.LoadGeneratorCustomizer_ScriptLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        scriptSettingsContainer.add((Component)this.scriptLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        scriptSettingsContainer.add((Component)this.secondLineCaptionSpacer, constraints);
        this.scriptTextField = new JTextField(""){

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getMinimumSize().width, super.getPreferredSize().height);
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.scriptLabel.setLabelFor(this.scriptTextField);
        this.scriptTextField.getAccessibleContext().setAccessibleDescription(Bundle.LoadGeneratorCustomizer_ScriptFieldAccessDescr());
        this.scriptTextField.getDocument().addDocumentListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 5);
        scriptSettingsContainer.add((Component)this.scriptTextField, constraints);
        this.scriptButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.scriptButton, (String)Bundle.LoadGeneratorCustomizer_BrowseButtonText());
        this.scriptButton.addActionListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        scriptSettingsContainer.add((Component)this.scriptButton, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 20, 5, 13);
        this.add((Component)scriptSettingsContainer, constraints);
        ButtonGroup stopRadiosGroup = new ButtonGroup();
        JPanel stopSettingsContainer = new JPanel(new GridBagLayout());
        this.stopLabel = new JLabel(Bundle.LoadGeneratorCustomizer_StopLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        stopSettingsContainer.add((Component)this.stopLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        stopSettingsContainer.add((Component)this.thirdLineCaptionSpacer, constraints);
        this.stopDefineRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.stopDefineRadio, (String)Bundle.LoadGeneratorCustomizer_DefineRadioText());
        stopRadiosGroup.add(this.stopDefineRadio);
        this.stopDefineRadio.addChangeListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        stopSettingsContainer.add((Component)this.stopDefineRadio, constraints);
        this.stopOnStopRadio = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.stopOnStopRadio, (String)Bundle.LoadGeneratorCustomizer_StopRadioText());
        this.stopOnStopRadio.addChangeListener(this);
        stopRadiosGroup.add(this.stopOnStopRadio);
        constraints = new GridBagConstraints();
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        stopSettingsContainer.add((Component)this.stopOnStopRadio, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 20, 10, 13);
        this.add((Component)stopSettingsContainer, constraints);
        JPanel locationBeginHeaderContainer = new JPanel(new GridBagLayout());
        this.locationBeginHeaderLabel = new JLabel(Bundle.LoadGeneratorCustomizer_LocationBeginLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        locationBeginHeaderContainer.add((Component)this.locationBeginHeaderLabel, constraints);
        this.locationBeginHeaderSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        locationBeginHeaderContainer.add((Component)this.locationBeginHeaderSeparator, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)locationBeginHeaderContainer, constraints);
        this.locationBeginCustomizer = new LocationCustomizer();
        this.locationBeginCustomizer.addValidityListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 20, 12, 13);
        this.add((Component)this.locationBeginCustomizer, constraints);
        JPanel locationEndHeaderContainer = new JPanel(new GridBagLayout());
        this.locationEndHeaderLabel = new JLabel(Bundle.LoadGeneratorCustomizer_LocationEndLabelText());
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 0, 0, 5);
        locationEndHeaderContainer.add((Component)this.locationEndHeaderLabel, constraints);
        this.locationEndHeaderSeparator = new JSeparator(){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 0, 0, 0);
        locationEndHeaderContainer.add((Component)this.locationEndHeaderSeparator, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 7;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 8, 5, 8);
        this.add((Component)locationEndHeaderContainer, constraints);
        this.locationEndCustomizer = new LocationCustomizer();
        this.locationEndCustomizer.resetMnemonic();
        this.locationEndCustomizer.addValidityListener(this);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 8;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.insets = new Insets(0, 20, 20, 13);
        this.add((Component)this.locationEndCustomizer, constraints);
        JPanel fillerPanel = new JPanel(new FlowLayout(3, 0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 9;
        constraints.weighty = 1.0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)fillerPanel, constraints);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            // empty catch block
        }
        LoadGeneratorCustomizer main = new LoadGeneratorCustomizer("Load Generator", null);
        main.addValidityListener(new ValidityListener(){

            @Override
            public void validityChanged(boolean isValid) {
                System.err.println(">>> Validity changed to " + isValid);
            }
        });
        JFrame frame = new JFrame("Customize Profiling Point");
        frame.getContentPane().add(main);
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public void normalizeCaptionAreaWidth() {
        int requiredCaptionAreaWidth1 = this.nameLabel.getPreferredSize().width - 12;
        int diffCaptionAreaWidth1 = this.getPreferredCaptionAreaWidth() - requiredCaptionAreaWidth1;
        int normalizedCaptionAreaWidth1 = diffCaptionAreaWidth1 > 0 ? diffCaptionAreaWidth1 : 0;
        int requiredCaptionAreaWidth2 = this.scriptLabel.getPreferredSize().width;
        int diffCaptionAreaWidth2 = this.getPreferredCaptionAreaWidth() - requiredCaptionAreaWidth2;
        int normalizedCaptionAreaWidth2 = diffCaptionAreaWidth2 > 0 ? diffCaptionAreaWidth2 : 0;
        int requiredCaptionAreaWidth3 = this.stopLabel.getPreferredSize().width;
        int diffCaptionAreaWidth3 = this.getPreferredCaptionAreaWidth() - requiredCaptionAreaWidth3;
        int normalizedCaptionAreaWidth3 = diffCaptionAreaWidth3 > 0 ? diffCaptionAreaWidth3 : 0;
        this.firstLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, normalizedCaptionAreaWidth1, 0, 0));
        this.secondLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, normalizedCaptionAreaWidth2, 0, 0));
        this.thirdLineCaptionSpacer.setBorder(BorderFactory.createEmptyBorder(0, normalizedCaptionAreaWidth3, 0, 0));
        this.locationBeginCustomizer.normalizeCaptionAreaWidth(this.getPreferredCaptionAreaWidth());
        this.locationEndCustomizer.normalizeCaptionAreaWidth(this.getPreferredCaptionAreaWidth());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateValidity();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.stopDefineRadio || e.getSource() == this.stopOnStopRadio) {
            boolean selected = this.stopDefineRadio.isSelected();
            this.locationEndCustomizer.setEnabled(selected);
            this.locationEndHeaderLabel.setEnabled(selected);
            this.locationEndHeaderSeparator.setEnabled(selected);
            this.updateValidity();
        }
    }

    @Override
    public void validityChanged(boolean isValid) {
        this.updateValidity();
    }

    private JFileChooser getFileChooser() {
        if (fileChooser == null) {
            JFileChooser chooser = new JFileChooser();
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setDialogType(0);
            chooser.setDialogTitle(Bundle.LoadGeneratorCustomizer_ChooseScriptDialogCaption());
            chooser.setFileFilter(new FileFilter(){
                private Set<String> extensions = new HashSet<String>();
                {
                    LoadGenPlugin lg = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
                    this.extensions = lg.getSupportedExtensions();
                }

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || this.extensions.contains(FileUtil.getExtension((String)f.getPath()));
                }

                @Override
                public String getDescription() {
                    return Bundle.LoadGeneratorCustomizer_SupportedFiles();
                }
            });
            fileChooser = chooser;
        }
        return fileChooser;
    }

    private boolean isNameEmpty() {
        return this.nameTextField.getText().trim().length() == 0;
    }

    private boolean isScriptValid() {
        String fileName = this.scriptTextField.getText();
        File file = new File(fileName);
        if (file.exists() && file.isFile()) {
            LoadGenPlugin lg = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class);
            if (lg == null) {
                return false;
            }
            String ext = FileUtil.getExtension((String)this.scriptTextField.getText());
            return lg.getSupportedExtensions().contains(ext);
        }
        return false;
    }

    private boolean areEndLocationSettingsValid() {
        return this.stopOnStopRadio.isSelected() || this.locationEndCustomizer.areSettingsValid();
    }

    private void updateValidity() {
        boolean isValid;
        boolean bl = isValid = !this.isNameEmpty() && this.isScriptValid() && this.locationBeginCustomizer.areSettingsValid() && this.areEndLocationSettingsValid();
        if (isValid != this.areSettingsValid()) {
            this.fireValidityChanged(isValid);
        }
    }
}

