/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.platform.Bundle;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferences;
import org.netbeans.modules.javascript.nodejs.ui.Notifications;
import org.netbeans.modules.javascript.nodejs.ui.customizer.NodeJsRunPanel;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.javascript.nodejs.util.StringUtils;
import org.netbeans.modules.web.clientproject.api.BadgeIcon;
import org.netbeans.modules.web.clientproject.spi.CustomizerPanelImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.PlatformProviderImplementation;
import org.netbeans.modules.web.clientproject.spi.platform.PlatformProviderImplementationListener;
import org.netbeans.spi.project.ActionProvider;
import org.openide.util.ImageUtilities;
import org.openide.util.RequestProcessor;

public final class NodeJsPlatformProvider
implements PlatformProviderImplementation,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(NodeJsPlatformProvider.class.getName());
    public static final String IDENT = "node.js";
    static final RequestProcessor RP = new RequestProcessor(NodeJsPlatformProvider.class);
    private static final String ICON_PATH = "org/netbeans/modules/javascript/nodejs/ui/resources/nodejs-badge.png";
    private final BadgeIcon badgeIcon;
    private final PlatformProviderImplementationListener.Support listenerSupport = new PlatformProviderImplementationListener.Support();

    public NodeJsPlatformProvider() {
        this.badgeIcon = new BadgeIcon(ImageUtilities.loadImage((String)ICON_PATH), NodeJsPlatformProvider.class.getResource("/org/netbeans/modules/javascript/nodejs/ui/resources/nodejs-badge.png"));
    }

    public String getIdentifier() {
        return IDENT;
    }

    public String getDisplayName() {
        return Bundle.NodeJsPlatformProvider_name();
    }

    public BadgeIcon getBadgeIcon() {
        return this.badgeIcon;
    }

    public boolean isEnabled(Project project) {
        assert (project != null);
        return NodeJsSupport.forProject(project).getPreferences().isEnabled();
    }

    public List<URL> getSourceRoots(Project project) {
        assert (project != null);
        assert (this.isEnabled(project)) : "Node.je support must be enabled in this project: " + project.getProjectDirectory().getNameExt();
        return NodeJsSupport.forProject(project).getSourceRoots();
    }

    public ActionProvider getActionProvider(Project project) {
        assert (project != null);
        return NodeJsSupport.forProject(project).getActionProvider();
    }

    public List<CustomizerPanelImplementation> getRunCustomizerPanels(Project project) {
        return Collections.singletonList(new NodeJsRunPanel(project));
    }

    public void projectOpened(Project project) {
        assert (project != null);
        NodeJsSupport nodeJsSupport = NodeJsSupport.forProject(project);
        nodeJsSupport.addPropertyChangeListener(this);
        nodeJsSupport.projectOpened();
        this.detectNodeJs(project);
    }

    public void projectClosed(Project project) {
        assert (project != null);
        NodeJsSupport nodeJsSupport = NodeJsSupport.forProject(project);
        nodeJsSupport.projectClosed();
        nodeJsSupport.removePropertyChangeListener(this);
    }

    public void notifyPropertyChanged(Project project, PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        if ("ENABLED".equals(propertyName)) {
            NodeJsSupport.forProject(project).getPreferences().setEnabled((Boolean)event.getNewValue());
        } else if ("PROJECT_NAME".equals(propertyName)) {
            this.projectNameChanged(project, (String)event.getNewValue());
        } else if ("RUN_CONFIGURATION".equals(propertyName)) {
            this.runConfigurationChanged(project, event.getNewValue());
        }
    }

    public void addPlatformProviderImplementationListener(PlatformProviderImplementationListener listener) {
        this.listenerSupport.addPlatformProviderImplementationsListener(listener);
    }

    public void removePlatformProviderImplementationListener(PlatformProviderImplementationListener listener) {
        this.listenerSupport.removePlatformProviderImplementationsListener(listener);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.listenerSupport.firePropertyChanged((Project)evt.getSource(), (PlatformProviderImplementation)this, new PropertyChangeEvent(this, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
    }

    private void detectNodeJs(Project project) {
        Map engines2;
        NodeJsSupport nodeJsSupport = NodeJsSupport.forProject(project);
        NodeJsPreferences preferences = nodeJsSupport.getPreferences();
        if (preferences.isEnabled()) {
            return;
        }
        PackageJson packageJson = nodeJsSupport.getPackageJson();
        if (!packageJson.exists()) {
            return;
        }
        Map<String, Object> content = packageJson.getContent();
        if (content == null) {
            return;
        }
        Object engines = content.get("engines");
        if (engines instanceof Map && (engines2 = (Map)engines).containsKey("node")) {
            Notifications.notifyNodeJsDetected(project);
        }
    }

    void projectNameChanged(Project project, final String newName) {
        final String projectDir = project.getProjectDirectory().getNameExt();
        NodeJsSupport nodeJsSupport = NodeJsSupport.forProject(project);
        final NodeJsPreferences preferences = nodeJsSupport.getPreferences();
        if (!preferences.isEnabled()) {
            LOGGER.log(Level.FINE, "Project name change ignored in project {0}, node.js not enabled", projectDir);
            return;
        }
        if (!preferences.isSyncEnabled()) {
            LOGGER.log(Level.FINE, "Project name change ignored in project {0}, sync not enabled", projectDir);
            return;
        }
        final PackageJson packageJson = nodeJsSupport.getPackageJson();
        if (!packageJson.exists()) {
            LOGGER.log(Level.FINE, "Project name change ignored in project {0}, package.json not exist", projectDir);
            return;
        }
        LOGGER.log(Level.FINE, "Processing project name change in project {0}", projectDir);
        Map<String, Object> content = packageJson.getContent();
        if (content == null) {
            LOGGER.log(Level.FINE, "Project name change ignored in project {0}, package.json has no or invalid content", projectDir);
            return;
        }
        if (!StringUtils.hasText(newName)) {
            LOGGER.log(Level.FINE, "Project name change ignored in project {0}, new name is empty", projectDir);
            return;
        }
        String name = (String)content.get("name");
        if (Objects.equals(name, newName)) {
            LOGGER.log(Level.FINE, "Project name change ignored in project {0}, new name same as current name in package.json", projectDir);
            return;
        }
        final String projectName = NodeJsUtils.getProjectDisplayName(project);
        if (preferences.isAskSyncEnabled()) {
            Notifications.askSyncChanges(project, new Runnable(){

                @Override
                public void run() {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            NodeJsPlatformProvider.this.changeProjectName(packageJson, newName, projectName, projectDir);
                        }
                    });
                }
            }, new Runnable(){

                @Override
                public void run() {
                    preferences.setSyncEnabled(false);
                    LOGGER.log(Level.FINE, "Project name change ignored in project {0}, cancelled by user", projectDir);
                }
            });
        } else {
            this.changeProjectName(packageJson, newName, projectName, projectDir);
        }
    }

    void changeProjectName(PackageJson packageJson, String newName, String projectName, String projectDir) {
        try {
            packageJson.setContent(Collections.singletonList("name"), newName);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            Notifications.informUser(Bundle.NodeJsPlatformProvider_sync_error());
            return;
        }
        Notifications.notifyUser(Bundle.NodeJsPlatformProvider_sync_title(projectName), Bundle.NodeJsPlatformProvider_sync_done(projectName));
        LOGGER.log(Level.FINE, "Project name change synced to package.json in project {0}", projectDir);
    }

    private void runConfigurationChanged(Project project, Object activeRunConfig) {
        boolean runEnabled = false;
        for (CustomizerPanelImplementation panel : this.getRunCustomizerPanels(project)) {
            if (!panel.getIdentifier().equals(activeRunConfig)) continue;
            runEnabled = true;
            break;
        }
        NodeJsSupport.forProject(project).getPreferences().setRunEnabled(runEnabled);
    }
}

