/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.platform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.NodeExecutable;
import org.netbeans.modules.javascript.nodejs.file.PackageJson;
import org.netbeans.modules.javascript.nodejs.options.NodeJsOptions;
import org.netbeans.modules.javascript.nodejs.platform.Bundle;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSourceRoots;
import org.netbeans.modules.javascript.nodejs.preferences.NodeJsPreferences;
import org.netbeans.modules.javascript.nodejs.ui.Notifications;
import org.netbeans.modules.javascript.nodejs.ui.actions.NodeJsActionProvider;
import org.netbeans.modules.javascript.nodejs.util.NodeInfo;
import org.netbeans.modules.javascript.nodejs.util.NodeJsUtils;
import org.netbeans.modules.javascript.nodejs.util.StringUtils;
import org.netbeans.modules.web.common.api.Version;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Pair;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class NodeJsSupport {
    static final Logger LOGGER = Logger.getLogger(NodeJsSupport.class.getName());
    static final RequestProcessor RP = new RequestProcessor(NodeJsSupport.class);
    final Project project;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    final PreferenceChangeListener optionsListener = new OptionsListener();
    final PreferenceChangeListener preferencesListener = new PreferencesListener();
    private final PropertyChangeListener packageJsonListener = new PackageJsonListener();
    private final FileChangeListener nodeSourcesListener = new NodeSourcesListener();
    final NodeJsPreferences preferences;
    private final ActionProvider actionProvider;
    final NodeJsSourceRoots sourceRoots;
    final PackageJson packageJson;
    private volatile NodeInfo currentNodeInfo = NodeInfo.none();

    private NodeJsSupport(Project project) {
        assert (project != null);
        this.project = project;
        this.actionProvider = new NodeJsActionProvider(project);
        this.sourceRoots = new NodeJsSourceRoots(project);
        this.preferences = new NodeJsPreferences(project);
        this.packageJson = new PackageJson(project.getProjectDirectory());
    }

    public static NodeJsSupport create(Project project) {
        NodeJsSupport support = new NodeJsSupport(project);
        NodeJsOptions nodeJsOptions = NodeJsOptions.getInstance();
        nodeJsOptions.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)support.optionsListener, (Object)nodeJsOptions));
        return support;
    }

    public static NodeJsSupport forProject(Project project) {
        NodeJsSupport support = (NodeJsSupport)project.getLookup().lookup(NodeJsSupport.class);
        assert (support != null) : "NodeJsSupport should be found in project " + project.getClass().getName() + " (lookup: " + project.getLookup() + ")";
        return support;
    }

    public NodeJsPreferences getPreferences() {
        return this.preferences;
    }

    public ActionProvider getActionProvider() {
        return this.actionProvider;
    }

    public List<URL> getSourceRoots() {
        return this.sourceRoots.getSourceRoots();
    }

    public PackageJson getPackageJson() {
        return this.packageJson;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void firePropertyChanged(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(new PropertyChangeEvent(this.project, propertyName, oldValue, newValue));
    }

    public void fireSourceRootsChanged() {
        this.sourceRoots.resetSourceRoots();
        this.firePropertyChanged("SOURCE_ROOTS", null, null);
    }

    void projectOpened() {
        FileUtil.addFileChangeListener((FileChangeListener)this.nodeSourcesListener, (File)NodeJsUtils.getNodeSources());
        this.preferences.addPreferenceChangeListener(this.preferencesListener);
        this.packageJson.addPropertyChangeListener(this.packageJsonListener);
        NodeExecutable node = NodeExecutable.forProject(this.project, false);
        if (node != null) {
            node.getVersion();
        }
    }

    void projectClosed() {
        FileUtil.removeFileChangeListener((FileChangeListener)this.nodeSourcesListener, (File)NodeJsUtils.getNodeSources());
        this.preferences.removePreferenceChangeListener(this.preferencesListener);
        this.packageJson.removePropertyChangeListener(this.packageJsonListener);
        this.packageJson.cleanup();
        if (this.currentNodeInfo.isRunning()) {
            this.currentNodeInfo.stop();
        }
    }

    public NodeInfo getCurrentNodeInfo() {
        assert (this.currentNodeInfo != null);
        return this.currentNodeInfo;
    }

    public void setCurrentNodeInfo(NodeInfo currentNodeInfo) {
        assert (currentNodeInfo != null);
        this.currentNodeInfo = currentNodeInfo;
    }

    private final class NodeSourcesListener
    extends FileChangeAdapter {
        private NodeSourcesListener() {
        }

        public void fileFolderCreated(FileEvent fe) {
            String projectName = NodeJsSupport.this.project.getProjectDirectory().getNameExt();
            if (!NodeJsSupport.this.preferences.isEnabled()) {
                LOGGER.log(Level.FINE, "File change event in node sources ignored, node.js not enabled in project {0}", projectName);
                return;
            }
            NodeExecutable node = NodeExecutable.forProject(NodeJsSupport.this.project, false);
            if (node == null) {
                return;
            }
            Version version = node.getVersion();
            if (version == null) {
                return;
            }
            if (fe.getFile().getNameExt().equals(version.toString())) {
                LOGGER.log(Level.FINE, "Processing file change event in node sources in project {0}", projectName);
                NodeJsSupport.this.fireSourceRootsChanged();
            }
        }
    }

    private final class PackageJsonListener
    implements PropertyChangeListener {
        private PackageJsonListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String projectName = NodeJsSupport.this.project.getProjectDirectory().getNameExt();
            if (!NodeJsSupport.this.preferences.isEnabled()) {
                LOGGER.log(Level.FINE, "Property change event in package.json ignored, node.js not enabled in project {0}", projectName);
                return;
            }
            if (!NodeJsSupport.this.preferences.isSyncEnabled()) {
                LOGGER.log(Level.FINE, "Property change event in package.json ignored, node.js sync not enabled in project {0}", projectName);
                return;
            }
            String propertyName = evt.getPropertyName();
            LOGGER.log(Level.FINE, "Processing property change event {0} in package.json in project {1}", new Object[]{propertyName, projectName});
            if ("NAME".equals(propertyName)) {
                this.projectNameChanged(evt.getOldValue(), evt.getNewValue());
            } else if ("SCRIPTS_START".equals(propertyName)) {
                this.startScriptChanged((String)evt.getNewValue());
            }
        }

        private void projectNameChanged(final Object oldName, final Object newName) {
            if (!(newName instanceof String)) {
                LOGGER.log(Level.FINE, "Project name change ignored, not a string: {0}", newName);
                return;
            }
            if (NodeJsSupport.this.preferences.isAskSyncEnabled()) {
                Notifications.askSyncChanges(NodeJsSupport.this.project, new Runnable(){

                    @Override
                    public void run() {
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                NodeJsSupport.this.firePropertyChanged("PROJECT_NAME", oldName, newName);
                            }
                        });
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        NodeJsSupport.this.preferences.setSyncEnabled(false);
                        LOGGER.log(Level.FINE, "Project name change ignored in project {0}, cancelled by user", NodeJsSupport.this.project.getProjectDirectory().getNameExt());
                    }
                });
            } else {
                NodeJsSupport.this.firePropertyChanged("PROJECT_NAME", oldName, newName);
            }
        }

        private void startScriptChanged(String newStartScript) {
            boolean syncArgs;
            final String projectDir = NodeJsSupport.this.project.getProjectDirectory().getNameExt();
            if (!StringUtils.hasText(newStartScript)) {
                LOGGER.log(Level.FINE, "Start script change ignored in project {0}, it has no text", projectDir);
                return;
            }
            Pair<String, String> newStartInfo = NodeJsUtils.parseStartFile(newStartScript);
            if (newStartInfo.first() == null) {
                LOGGER.log(Level.FINE, "Start script change ignored in project {0}, no 'file' found", projectDir);
                return;
            }
            final String newStartFile = new File(FileUtil.toFile((FileObject)NodeJsSupport.this.project.getProjectDirectory()), (String)newStartInfo.first()).getAbsolutePath();
            String startFile = NodeJsSupport.this.preferences.getStartFile();
            final boolean syncFile = !Objects.equals(startFile, newStartFile);
            String startArgs = NodeJsSupport.this.preferences.getStartArgs();
            final String newStartArgs = (String)newStartInfo.second();
            boolean bl = syncArgs = !Objects.equals(startArgs, newStartArgs);
            if (!syncFile && !syncArgs) {
                LOGGER.log(Level.FINE, "Start script change ignored in project {0}, same values already set", projectDir);
                return;
            }
            final String projectName = NodeJsUtils.getProjectDisplayName(NodeJsSupport.this.project);
            if (NodeJsSupport.this.preferences.isAskSyncEnabled()) {
                Notifications.askSyncChanges(NodeJsSupport.this.project, new Runnable(){

                    @Override
                    public void run() {
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                PackageJsonListener.this.changeStartScript(syncFile, newStartFile, syncArgs, newStartArgs, projectName, projectDir);
                            }
                        });
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        NodeJsSupport.this.preferences.setSyncEnabled(false);
                        LOGGER.log(Level.FINE, "Start script change ignored in project {0}, cancelled by user", projectDir);
                    }
                });
            } else {
                this.changeStartScript(syncFile, newStartFile, syncArgs, newStartArgs, projectName, projectDir);
            }
        }

        void changeStartScript(boolean syncFile, String newStartFile, boolean syncArgs, String newStartArgs, String projectName, String projectDir) {
            if (syncFile) {
                NodeJsSupport.this.preferences.setStartFile(newStartFile);
            }
            if (syncArgs) {
                NodeJsSupport.this.preferences.setStartArgs(newStartArgs);
            }
            Notifications.notifyUser(Bundle.PackageJsonListener_sync_title(projectName), Bundle.PackageJsonListener_sync_done());
            LOGGER.log(Level.FINE, "Start file/args change synced to project.properties in project {0}", projectDir);
        }
    }

    private final class PreferencesListener
    implements PreferenceChangeListener {
        private final RequestProcessor.Task startScriptSyncTask = RP.create(new Runnable(){

            @Override
            public void run() {
                PreferencesListener.this.startScriptChanged(NodeJsSupport.this.preferences.getStartFile(), NodeJsSupport.this.preferences.getStartArgs());
            }
        });

        private PreferencesListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String projectName = NodeJsSupport.this.project.getProjectDirectory().getNameExt();
            boolean enabled = NodeJsSupport.this.preferences.isEnabled();
            String key = evt.getKey();
            LOGGER.log(Level.FINE, "Processing change event {0} in node.js preferences in project {1}", new Object[]{key, projectName});
            if ("enabled".equals(key)) {
                NodeJsSupport.this.firePropertyChanged("ENABLED", !enabled, enabled);
                if (enabled) {
                    if (NodeJsUtils.isJsLibrary(NodeJsSupport.this.project)) {
                        NodeJsSupport.this.preferences.setRunEnabled(true);
                        NodeJsSupport.this.firePropertyChanged("RUN_CONFIGURATION", null, "node.js");
                    } else if (NodeJsSupport.this.preferences.isAskRunEnabled()) {
                        Notifications.notifyRunConfiguration(NodeJsSupport.this.project);
                    }
                }
            } else if (!enabled) {
                LOGGER.log(Level.FINE, "Change event in node.js preferences ignored, node.js not enabled in project {0}", projectName);
            } else if ("node.default".equals(key)) {
                NodeJsSupport.this.fireSourceRootsChanged();
            } else if (!NodeJsSupport.this.preferences.isDefaultNode() && ("node.path".equals(key) || "node.sources.path".equals(key))) {
                NodeJsSupport.this.fireSourceRootsChanged();
            } else if ("start.file".equals(key) || "start.args".equals(key)) {
                this.startScriptSyncTask.schedule(100);
            }
        }

        void startScriptChanged(String newStartFile, final String newStartArgs) {
            final String projectDir = NodeJsSupport.this.project.getProjectDirectory().getNameExt();
            if (!NodeJsSupport.this.preferences.isEnabled()) {
                LOGGER.log(Level.FINE, "Start file/args change ignored in project {0}, node.js not enabled in project {0}", projectDir);
                return;
            }
            if (!NodeJsSupport.this.preferences.isSyncEnabled()) {
                LOGGER.log(Level.FINE, "Start file/args change ignored in project {0}, sync not enabled", projectDir);
                return;
            }
            if (!StringUtils.hasText(newStartFile) && !StringUtils.hasText(newStartArgs)) {
                LOGGER.log(Level.FINE, "Start file/args change ignored in project {0}, new file and args are empty", projectDir);
                return;
            }
            String relNewStartFile = newStartFile;
            String relPath = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)NodeJsSupport.this.project.getProjectDirectory()), (File)new File(newStartFile));
            if (relPath != null) {
                relNewStartFile = relPath;
            }
            if (!NodeJsSupport.this.packageJson.exists()) {
                LOGGER.log(Level.FINE, "Start file/args change ignored in project {0}, package.json not exist", projectDir);
                return;
            }
            LOGGER.log(Level.FINE, "Processing Start file/args change in project {0}", projectDir);
            Map<String, Object> content = NodeJsSupport.this.packageJson.getContent();
            if (content == null) {
                LOGGER.log(Level.FINE, "Start file/args change ignored in project {0}, package.json has no or invalid content", projectDir);
                return;
            }
            String startFile = null;
            String startArgs = null;
            String startScript = NodeJsSupport.this.packageJson.getContentValue(String.class, "scripts", "start");
            if (startScript != null) {
                Pair<String, String> startInfo = NodeJsUtils.parseStartFile(startScript);
                startFile = (String)startInfo.first();
                startArgs = (String)startInfo.second();
            }
            if (Objects.equals(startFile, relNewStartFile) && Objects.equals(startArgs, newStartArgs)) {
                LOGGER.log(Level.FINE, "Start file/args change ignored in project {0}, file and args same as in package.json", projectDir);
                return;
            }
            final String projectName = NodeJsUtils.getProjectDisplayName(NodeJsSupport.this.project);
            if (NodeJsSupport.this.preferences.isAskSyncEnabled()) {
                final String relNewStartFileRef = relNewStartFile;
                Notifications.askSyncChanges(NodeJsSupport.this.project, new Runnable(){

                    @Override
                    public void run() {
                        RP.post(new Runnable(){

                            @Override
                            public void run() {
                                PreferencesListener.this.changeStartScript(relNewStartFileRef, newStartArgs, projectName, projectDir);
                            }
                        });
                    }
                }, new Runnable(){

                    @Override
                    public void run() {
                        NodeJsSupport.this.preferences.setSyncEnabled(false);
                        LOGGER.log(Level.FINE, "Start file/args change ignored in project {0}, cancelled by user", projectDir);
                    }
                });
            } else {
                this.changeStartScript(relNewStartFile, newStartArgs, projectName, projectDir);
            }
        }

        void changeStartScript(String relNewStartFile, String newStartArgs, String projectName, String projectDir) {
            StringBuilder sb = new StringBuilder();
            sb.append("node ");
            sb.append(relNewStartFile);
            if (StringUtils.hasText(newStartArgs)) {
                sb.append(" ");
                sb.append(newStartArgs);
            }
            try {
                NodeJsSupport.this.packageJson.setContent(Arrays.asList("scripts", "start"), sb.toString());
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, null, ex);
                Notifications.informUser(Bundle.PreferencesListener_sync_error());
                return;
            }
            Notifications.notifyUser(Bundle.PreferencesListener_sync_title(projectName), Bundle.PreferencesListener_sync_done());
            LOGGER.log(Level.FINE, "Start file/args change synced to package.json in project {0}", projectDir);
        }
    }

    private final class OptionsListener
    implements PreferenceChangeListener {
        private OptionsListener() {
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String projectName = NodeJsSupport.this.project.getProjectDirectory().getNameExt();
            if (!NodeJsSupport.this.preferences.isEnabled()) {
                LOGGER.log(Level.FINE, "Change event in node.js options ignored, node.js not enabled in project {0}", projectName);
                return;
            }
            String key = evt.getKey();
            LOGGER.log(Level.FINE, "Processing change event {0} in node.js options in project {1}", new Object[]{key, projectName});
            if (NodeJsSupport.this.preferences.isDefaultNode() && ("node.path".equals(key) || "node.sources.path".equals(key))) {
                NodeJsSupport.this.fireSourceRootsChanged();
            }
        }
    }
}

