/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.actions;

import org.netbeans.api.project.Project;
import org.netbeans.modules.javascript.nodejs.exec.NodeExecutable;
import org.netbeans.modules.javascript.nodejs.platform.NodeJsSupport;
import org.netbeans.modules.javascript.nodejs.ui.actions.Command;
import org.netbeans.modules.javascript.nodejs.util.NodeInfo;
import org.netbeans.modules.javascript.nodejs.util.RunInfo;
import org.openide.util.Lookup;

abstract class ProjectCommand
extends Command {
    private final boolean debug;

    public ProjectCommand(Project project, boolean debug) {
        super(project);
        this.debug = debug;
    }

    protected abstract boolean isEnabledInternal(Lookup var1);

    protected abstract NodeInfo runNodeInternal(NodeExecutable var1, RunInfo var2);

    @Override
    public final boolean isEnabled(Lookup context) {
        if (!NodeJsSupport.forProject(this.project).getPreferences().isRunEnabled()) {
            return false;
        }
        return this.isEnabledInternal(context);
    }

    @Override
    final void runInternal(Lookup context) {
        NodeJsSupport nodeJsSupport = NodeJsSupport.forProject(this.project);
        NodeInfo currentNodeInfo = nodeJsSupport.getCurrentNodeInfo();
        if (!currentNodeInfo.isRunning()) {
            nodeJsSupport.setCurrentNodeInfo(this.runNode());
            return;
        }
        assert (currentNodeInfo.isRunning());
        if (currentNodeInfo.isDebug() != this.debug || nodeJsSupport.getPreferences().isRunRestart()) {
            currentNodeInfo.stop();
            nodeJsSupport.setCurrentNodeInfo(this.runNode());
        }
    }

    private NodeInfo runNode() {
        NodeExecutable node = this.getNode();
        if (node == null) {
            return NodeInfo.none();
        }
        RunInfo runInfo = this.getRunInfo();
        if (runInfo == null) {
            return NodeInfo.none();
        }
        return this.runNodeInternal(node, runInfo);
    }
}

