/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.ui.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.javascript.nodejs.exec.ExpressExecutable;
import org.netbeans.modules.javascript.nodejs.exec.NpmExecutable;
import org.netbeans.modules.javascript.nodejs.ui.NodeJsPathPanel;
import org.netbeans.modules.javascript.nodejs.ui.options.Bundle;
import org.netbeans.modules.javascript.nodejs.util.FileUtils;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.util.ChangeSupport;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public final class NodeJsOptionsPanel
extends JPanel
implements ChangeListener,
HelpCtx.Provider {
    private static final Logger LOGGER = Logger.getLogger(NodeJsOptionsPanel.class.getName());
    final NodeJsPathPanel nodePanel;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JLabel debuggingLabel;
    private JSeparator debuggingSeparator;
    private JLabel errorLabel;
    private JButton expressBrowseButton;
    private JLabel expressHeaderLabel;
    private JLabel expressHintLabel;
    private JLabel expressInstallLabel;
    private JLabel expressLabel;
    private JButton expressSearchButton;
    private JSeparator expressSeparator;
    private JTextField expressTextField;
    private JCheckBox liveEditCheckBox;
    private JLabel liveEditInfo1Label;
    private JLabel liveEditInfo2Label;
    private JPanel nodePanelHolder;
    private JButton npmBrowseButton;
    private JLabel npmHeaderLabel;
    private JLabel npmHintLabel;
    private JLabel npmLabel;
    private JButton npmSearchButton;
    private JSeparator npmSeparator;
    private JTextField npmTextField;
    private JCheckBox stopAtFirstLineCheckBox;

    private NodeJsOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        this.initComponents();
        this.nodePanel = new NodeJsPathPanel();
        this.init();
    }

    public static NodeJsOptionsPanel create() {
        NodeJsOptionsPanel panel = new NodeJsOptionsPanel();
        panel.nodePanel.addChangeListener(panel);
        return panel;
    }

    private void init() {
        this.errorLabel.setText(" ");
        this.npmHintLabel.setText(Bundle.NodeJsOptionsPanel_npm_hint(NpmExecutable.NPM_NAME));
        this.expressHintLabel.setText(Bundle.NodeJsOptionsPanel_express_hint(ExpressExecutable.EXPRESS_NAME));
        this.nodePanelHolder.add((Component)this.nodePanel, "Center");
        DefaultItemListener defaultItemListener = new DefaultItemListener();
        this.stopAtFirstLineCheckBox.addItemListener(defaultItemListener);
        this.liveEditCheckBox.addItemListener(defaultItemListener);
        DefaultDocumentListener defaultDocumentListener = new DefaultDocumentListener();
        this.npmTextField.getDocument().addDocumentListener(defaultDocumentListener);
        this.expressTextField.getDocument().addDocumentListener(defaultDocumentListener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    public void setError(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.errorForeground"));
        this.errorLabel.setText(message);
    }

    public void setWarning(String message) {
        this.errorLabel.setText(" ");
        this.errorLabel.setForeground(UIManager.getColor("nb.warningForeground"));
        this.errorLabel.setText(message);
    }

    public String getNode() {
        return this.nodePanel.getNode();
    }

    public void setNode(String node) {
        this.nodePanel.setNode(node);
    }

    @CheckForNull
    public String getNodeSources() {
        return this.nodePanel.getNodeSources();
    }

    public void setNodeSources(String nodeSources) {
        this.nodePanel.setNodeSources(nodeSources);
    }

    public boolean isStopAtFirstLine() {
        return this.stopAtFirstLineCheckBox.isSelected();
    }

    public void setStopAtFirstLine(boolean stopAtFirstLine) {
        this.stopAtFirstLineCheckBox.setSelected(stopAtFirstLine);
    }

    public boolean isLiveEdit() {
        return this.liveEditCheckBox.isSelected();
    }

    public void setLiveEdit(boolean liveEdit) {
        this.liveEditCheckBox.setSelected(liveEdit);
    }

    public String getNpm() {
        return this.npmTextField.getText();
    }

    public void setNpm(String npm) {
        this.npmTextField.setText(npm);
    }

    public String getExpress() {
        return this.expressTextField.getText();
    }

    public void setExpress(String express) {
        this.expressTextField.setText(express);
    }

    void fireChange() {
        this.changeSupport.fireChange();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.javascript.nodejs.ui.options.NodeJsOptionsPanel");
    }

    private void initComponents() {
        this.nodePanelHolder = new JPanel();
        this.debuggingLabel = new JLabel();
        this.debuggingSeparator = new JSeparator();
        this.stopAtFirstLineCheckBox = new JCheckBox();
        this.liveEditCheckBox = new JCheckBox();
        this.liveEditInfo1Label = new JLabel();
        this.liveEditInfo2Label = new JLabel();
        this.npmHeaderLabel = new JLabel();
        this.npmSeparator = new JSeparator();
        this.npmLabel = new JLabel();
        this.npmTextField = new JTextField();
        this.npmBrowseButton = new JButton();
        this.npmSearchButton = new JButton();
        this.npmHintLabel = new JLabel();
        this.expressHeaderLabel = new JLabel();
        this.expressSeparator = new JSeparator();
        this.expressLabel = new JLabel();
        this.expressTextField = new JTextField();
        this.expressBrowseButton = new JButton();
        this.expressSearchButton = new JButton();
        this.expressHintLabel = new JLabel();
        this.expressInstallLabel = new JLabel();
        this.errorLabel = new JLabel();
        this.nodePanelHolder.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.debuggingLabel, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.debuggingLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.stopAtFirstLineCheckBox, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.stopAtFirstLineCheckBox.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.liveEditCheckBox, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.liveEditCheckBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.liveEditInfo1Label, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.liveEditInfo1Label.text"));
        Mnemonics.setLocalizedText((JLabel)this.liveEditInfo2Label, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.liveEditInfo2Label.text"));
        Mnemonics.setLocalizedText((JLabel)this.npmHeaderLabel, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.npmHeaderLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.npmLabel, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.npmLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.npmBrowseButton, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.npmBrowseButton.text"));
        this.npmBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsOptionsPanel.this.npmBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.npmSearchButton, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.npmSearchButton.text"));
        this.npmSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsOptionsPanel.this.npmSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.npmHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.expressHeaderLabel, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.expressHeaderLabel.text"));
        this.expressLabel.setLabelFor(this.expressTextField);
        Mnemonics.setLocalizedText((JLabel)this.expressLabel, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.expressLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.expressBrowseButton, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.expressBrowseButton.text"));
        this.expressBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsOptionsPanel.this.expressBrowseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.expressSearchButton, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.expressSearchButton.text"));
        this.expressSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NodeJsOptionsPanel.this.expressSearchButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.expressHintLabel, (String)"HINT");
        Mnemonics.setLocalizedText((JLabel)this.expressInstallLabel, (String)NbBundle.getMessage(NodeJsOptionsPanel.class, (String)"NodeJsOptionsPanel.expressInstallLabel.text"));
        this.expressInstallLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                NodeJsOptionsPanel.this.expressInstallLabelMousePressed(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                NodeJsOptionsPanel.this.expressInstallLabelMouseEntered(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.errorLabel, (String)"ERROR");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.npmLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.npmTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.npmBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.npmSearchButton)).addGroup(layout.createSequentialGroup().addComponent(this.npmHintLabel).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addComponent(this.expressHeaderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.expressSeparator)).addGroup(layout.createSequentialGroup().addComponent(this.expressLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.expressHintLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.expressInstallLabel, -2, -1, -2)).addGroup(layout.createSequentialGroup().addComponent(this.expressTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.expressBrowseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.expressSearchButton)))).addGroup(layout.createSequentialGroup().addComponent(this.npmHeaderLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.npmSeparator)).addComponent(this.nodePanelHolder, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.debuggingLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.debuggingSeparator)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.errorLabel).addComponent(this.liveEditCheckBox).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.liveEditInfo2Label).addComponent(this.liveEditInfo1Label))).addComponent(this.stopAtFirstLineCheckBox)).addGap(0, 0, Short.MAX_VALUE)));
        layout.linkSize(0, this.npmBrowseButton, this.npmSearchButton);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nodePanelHolder, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.debuggingLabel).addComponent(this.debuggingSeparator, -2, 10, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopAtFirstLineCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.liveEditCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.liveEditInfo1Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.liveEditInfo2Label).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.npmHeaderLabel).addComponent(this.npmSeparator, -2, 8, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.npmLabel).addComponent(this.npmTextField, -2, -1, -2).addComponent(this.npmSearchButton).addComponent(this.npmBrowseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.npmHintLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.expressHeaderLabel).addComponent(this.expressSeparator, -2, 8, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.expressTextField, -2, -1, -2).addComponent(this.expressBrowseButton).addComponent(this.expressSearchButton).addComponent(this.expressLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.expressHintLabel).addComponent(this.expressInstallLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.errorLabel)));
    }

    private void npmBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(NodeJsOptionsPanel.class).setFilesOnly(true).setTitle(Bundle.NodeJsOptionsPanel_npm_browse_title()).showOpenDialog();
        if (file != null) {
            this.npmTextField.setText(file.getAbsolutePath());
        }
    }

    private void npmSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        Iterator<String> i$ = FileUtils.findFileOnUsersPath(NpmExecutable.NPM_NAME).iterator();
        if (i$.hasNext()) {
            String npm = i$.next();
            this.npmTextField.setText(new File(npm).getAbsolutePath());
            return;
        }
        StatusDisplayer.getDefault().setStatusText(Bundle.NodeJsOptionsPanel_npm_none());
    }

    private void expressBrowseButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        File file = new FileChooserBuilder(NodeJsOptionsPanel.class).setFilesOnly(true).setTitle(Bundle.NodeJsOptionsPanel_express_browse_title()).showOpenDialog();
        if (file != null) {
            this.expressTextField.setText(file.getAbsolutePath());
        }
    }

    private void expressSearchButtonActionPerformed(ActionEvent evt) {
        assert (EventQueue.isDispatchThread());
        Iterator<String> i$ = FileUtils.findFileOnUsersPath(ExpressExecutable.EXPRESS_NAME).iterator();
        if (i$.hasNext()) {
            String express = i$.next();
            this.expressTextField.setText(new File(express).getAbsolutePath());
            return;
        }
        StatusDisplayer.getDefault().setStatusText(Bundle.NodeJsOptionsPanel_express_none());
    }

    private void expressInstallLabelMouseEntered(MouseEvent evt) {
        evt.getComponent().setCursor(Cursor.getPredefinedCursor(12));
    }

    private void expressInstallLabelMousePressed(MouseEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURL(new URL("http://expressjs.com/starter/generator.html"));
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
    }

    private final class DefaultItemListener
    implements ItemListener {
        private DefaultItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            NodeJsOptionsPanel.this.fireChange();
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processUpdate();
        }

        private void processUpdate() {
            NodeJsOptionsPanel.this.fireChange();
        }
    }
}

