/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.util;

import java.io.File;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.javascript.nodejs.util.Bundle;
import org.netbeans.modules.web.common.api.ExternalExecutableValidator;
import org.netbeans.modules.web.common.api.ValidationResult;

public final class ValidationUtils {
    public static final String NODE_PATH = "node.path";
    public static final String NODE_SOURCES_PATH = "node.sources.path";
    public static final String NPM_PATH = "npm.path";
    public static final String EXPRESS_PATH = "express.path";

    private ValidationUtils() {
    }

    public static void validateNode(ValidationResult result, String node) {
        String warning = ExternalExecutableValidator.validateCommand((String)node, (String)Bundle.ValidationUtils_node_name());
        if (warning != null) {
            result.addWarning(new ValidationResult.Message((Object)NODE_PATH, warning));
        }
    }

    public static void validateNodeSources(ValidationResult result, @NullAllowed String nodeSources) {
        if (nodeSources == null) {
            return;
        }
        File sources = new File(nodeSources);
        if (!sources.isDirectory()) {
            result.addWarning(new ValidationResult.Message((Object)NODE_SOURCES_PATH, Bundle.ValidationUtils_node_sources_invalid()));
        } else if (!new File(sources, "lib").isDirectory()) {
            result.addWarning(new ValidationResult.Message((Object)NODE_SOURCES_PATH, Bundle.ValidationUtils_node_sources_lib_invalid("lib")));
        }
    }

    public static void validateNpm(ValidationResult result, String npm) {
        String warning = ExternalExecutableValidator.validateCommand((String)npm, (String)Bundle.ValidationUtils_npm_name());
        if (warning != null) {
            result.addWarning(new ValidationResult.Message((Object)NPM_PATH, warning));
        }
    }

    public static void validateExpress(ValidationResult result, String express) {
        String warning = ExternalExecutableValidator.validateCommand((String)express, (String)Bundle.ValidationUtils_express_name());
        if (warning != null) {
            result.addWarning(new ValidationResult.Message((Object)EXPRESS_PATH, warning));
        }
    }
}

