/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Mutex;

public class SourceForBinaryQueryImpl
implements SourceForBinaryQueryImplementation {
    private Map<URL, Reference<SourceForBinaryQuery.Result>> url2Result = new WeakHashMap<URL, Reference<SourceForBinaryQuery.Result>>();
    private Map<SourceForBinaryQuery.Result, URL> result2URL = new WeakHashMap<SourceForBinaryQuery.Result, URL>();

    public SourceForBinaryQuery.Result findSourceRoots(final URL binaryRoot) {
        return (SourceForBinaryQuery.Result)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<SourceForBinaryQuery.Result>(){

            public SourceForBinaryQuery.Result run() {
                return SourceForBinaryQueryImpl.this.findSourceRootsImpl(binaryRoot);
            }
        });
    }

    private synchronized SourceForBinaryQuery.Result findSourceRootsImpl(URL binaryRoot) {
        SourceForBinaryQuery.Result r;
        Reference<SourceForBinaryQuery.Result> ref = this.url2Result.get(binaryRoot);
        SourceForBinaryQuery.Result result = r = ref != null ? ref.get() : null;
        if (r != null) {
            return r;
        }
        String binaryRootS = binaryRoot.toExternalForm();
        URL url = null;
        if (binaryRootS.startsWith("jar:file:")) {
            FileObject projectFO;
            url = this.checkForBinaryRoot(binaryRootS, "/libs.javacapi/external/nb-javac-api");
            if (url == null) {
                url = this.checkForBinaryRoot(binaryRootS, "/libs.javacimpl/external/nb-javac-impl");
            }
            FileObject fileObject = projectFO = url != null ? URLMapper.findFileObject((URL)url) : null;
            if (projectFO != null) {
                try {
                    Project project = ProjectManager.getDefault().findProject(projectFO);
                    SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
                    final FileObject[] roots = new FileObject[sourceGroups.length];
                    for (int i = 0; i < sourceGroups.length; ++i) {
                        roots[i] = sourceGroups[i].getRootFolder();
                    }
                    SourceForBinaryQuery.Result result2 = new SourceForBinaryQuery.Result(){

                        public FileObject[] getRoots() {
                            return roots;
                        }

                        public void addChangeListener(ChangeListener l) {
                        }

                        public void removeChangeListener(ChangeListener l) {
                        }
                    };
                    this.url2Result.put(binaryRoot, new WeakReference<2>(result2));
                    this.result2URL.put(result2, binaryRoot);
                    return result2;
                }
                catch (IOException ex) {
                    Logger.getLogger(SourceForBinaryQueryImpl.class.getName()).log(Level.FINE, null, ex);
                }
                catch (IllegalArgumentException ex) {
                    Logger.getLogger(SourceForBinaryQueryImpl.class.getName()).log(Level.FINE, null, ex);
                }
            }
        }
        return null;
    }

    private URL checkForBinaryRoot(String ext, String prefix) {
        if (ext.endsWith(prefix + ".jar!/")) {
            try {
                String part = ext.substring("jar:".length(), ext.length() - prefix.length() - ".jar!/".length());
                return new URL(part + "/nb-javac/make/netbeans/nb-javac");
            }
            catch (MalformedURLException ex) {
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
        }
        return null;
    }
}

