/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.debug;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.IntersectionTypeTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.PrimitiveTypeTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.UnionTypeTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.WildcardTree;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.support.CancellableTreePathScanner;
import org.netbeans.modules.java.debug.CommentsNode;
import org.netbeans.modules.java.debug.DocTreeNode;
import org.netbeans.modules.java.debug.ElementNode;
import org.netbeans.modules.java.debug.OffsetProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class TreeNode
extends AbstractNode
implements OffsetProvider {
    private TreePath tree;
    private CompilationInfo info;
    private boolean synthetic;
    private static String[] c = new String[]{"&", "<", ">", "\""};
    private static String[] tags = new String[]{"&amp;", "&lt;", "&gt;", "&quot;"};

    public static Node getTree(CompilationInfo info, TreePath tree, AtomicBoolean cancel) {
        ArrayList result = new ArrayList();
        new FindChildrenTreeVisitor(info, cancel).scan(tree, result);
        return (Node)result.get(0);
    }

    @CheckForNull
    public static Node findNode(@NonNull Node parent, @NonNull TreePath tree) {
        LinkedList<Tree> trees = new LinkedList<Tree>();
        while (tree != null) {
            trees.add(tree.getLeaf());
            tree = tree.getParentPath();
        }
        if (trees.isEmpty()) {
            return null;
        }
        Collections.reverse(trees);
        Iterator<Tree> it = trees.iterator();
        it.next();
        return TreeNode.findNode(parent, it);
    }

    @NonNull
    private static Node findNode(@NonNull Node parent, @NonNull Iterator<Tree> trees) {
        if (!trees.hasNext()) {
            return parent;
        }
        Tree next = trees.next();
        for (Node child : parent.getChildren().getNodes(true)) {
            if (child.getLookup().lookup(Tree.class) != next) continue;
            return TreeNode.findNode(child, trees);
        }
        return parent;
    }

    public TreeNode(CompilationInfo info, TreePath tree, List<Node> nodes) {
        super((Children)(nodes.isEmpty() ? Children.LEAF : new NodeChilren(nodes)), Lookups.singleton((Object)tree.getLeaf()));
        this.tree = tree;
        this.info = info;
        this.synthetic = info.getTreeUtilities().isSynthetic(tree);
        int start = (int)info.getTrees().getSourcePositions().getStartPosition(tree.getCompilationUnit(), tree.getLeaf());
        int end = (int)info.getTrees().getSourcePositions().getEndPosition(tree.getCompilationUnit(), tree.getLeaf());
        String text = start >= 0 && end >= 0 && end > start ? info.getText().substring(start, end) : tree.getLeaf().toString();
        this.setDisplayName(tree.getLeaf().getKind().toString() + ":" + text);
        this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/tree.png");
    }

    public String getHtmlDisplayName() {
        if (this.synthetic) {
            return "<html><font color='#808080'>" + this.translate(this.getDisplayName());
        }
        return null;
    }

    private String translate(String input) {
        for (int cntr = 0; cntr < c.length; ++cntr) {
            input = input.replaceAll(c[cntr], tags[cntr]);
        }
        return input;
    }

    @Override
    public int getStart() {
        return (int)this.info.getTrees().getSourcePositions().getStartPosition(this.tree.getCompilationUnit(), this.tree.getLeaf());
    }

    @Override
    public int getEnd() {
        return (int)this.info.getTrees().getSourcePositions().getEndPosition(this.tree.getCompilationUnit(), this.tree.getLeaf());
    }

    @Override
    public int getPreferredPosition() {
        return -1;
    }

    static Node nodeForElement(CompilationInfo info, Element el) {
        if (el != null) {
            return new ElementNode(info, el, Collections.emptyList());
        }
        return new NotFoundElementNode(NbBundle.getMessage(TreeNode.class, (String)"Cannot_Resolve_Element"));
    }

    private static class NotFoundTypeNode
    extends AbstractNode {
        public NotFoundTypeNode(String name) {
            super(Children.LEAF);
            this.setName(name);
            this.setDisplayName(name);
            this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/type.png");
        }
    }

    private static class TypeNode
    extends AbstractNode {
        public TypeNode(TypeMirror type) {
            super(Children.LEAF);
            this.setDisplayName(type.getKind().toString() + ":" + type.toString());
            this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/type.png");
        }
    }

    private static class NotFoundElementNode
    extends AbstractNode {
        public NotFoundElementNode(String name) {
            super(Children.LEAF);
            this.setName(name);
            this.setDisplayName(name);
            this.setIconBaseWithExtension("org/netbeans/modules/java/debug/resources/element.png");
        }
    }

    private static class NotFoundJavadocNode
    extends AbstractNode {
        public NotFoundJavadocNode(String name) {
            super(Children.LEAF);
            this.setName(name);
            this.setDisplayName(name);
        }
    }

    private static class FindChildrenTreeVisitor
    extends CancellableTreePathScanner<Void, List<Node>> {
        private final CompilationInfo info;

        public FindChildrenTreeVisitor(CompilationInfo info, AtomicBoolean cancel) {
            super(cancel);
            this.info = info;
        }

        public Void visitAnnotation(AnnotationTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitAnnotation(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitMethodInvocation(MethodInvocationTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitMethodInvocation(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitAssert(AssertTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitAssert(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitAssignment(AssignmentTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitAssignment(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitCompoundAssignment(CompoundAssignmentTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitCompoundAssignment(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitBinary(BinaryTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitBinary(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitBlock(BlockTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitBlock(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitBreak(BreakTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitBreak(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitCase(CaseTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitCase(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitCatch(CatchTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitCatch(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitClass(ClassTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            this.addCorrespondingJavadoc(below);
            super.visitClass(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitConditionalExpression(ConditionalExpressionTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitConditionalExpression(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitContinue(ContinueTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitContinue(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitUnionType(UnionTypeTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitUnionType(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitDoWhileLoop(DoWhileLoopTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitDoWhileLoop(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitErroneous(ErroneousTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            this.scan(tree.getErrorTrees(), below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitExpressionStatement(ExpressionStatementTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitExpressionStatement(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitEnhancedForLoop(EnhancedForLoopTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitEnhancedForLoop(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitForLoop(ForLoopTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitForLoop(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitIdentifier(IdentifierTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitIdentifier(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitIf(IfTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitIf(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitImport(ImportTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitImport(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitArrayAccess(ArrayAccessTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitArrayAccess(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitLabeledStatement(LabeledStatementTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitLabeledStatement(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitLambdaExpression(LambdaExpressionTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitLambdaExpression(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitLiteral(LiteralTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitLiteral(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitMemberReference(MemberReferenceTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitMemberReference(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitMethod(MethodTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            this.addCorrespondingJavadoc(below);
            super.visitMethod(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitModifiers(ModifiersTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitModifiers(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitNewArray(NewArrayTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitNewArray(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitNewClass(NewClassTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitNewClass(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitParenthesized(ParenthesizedTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitParenthesized(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitReturn(ReturnTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitReturn(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitMemberSelect(MemberSelectTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitMemberSelect(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitEmptyStatement(EmptyStatementTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitEmptyStatement(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitSwitch(SwitchTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitSwitch(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitSynchronized(SynchronizedTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitSynchronized(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitThrow(ThrowTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitThrow(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitCompilationUnit(CompilationUnitTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitCompilationUnit(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitTry(TryTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitTry(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitAnnotatedType(AnnotatedTypeTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitAnnotatedType(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitParameterizedType(ParameterizedTypeTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitParameterizedType(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitArrayType(ArrayTypeTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitArrayType(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitTypeCast(TypeCastTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitTypeCast(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitIntersectionType(IntersectionTypeTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitIntersectionType(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitPrimitiveType(PrimitiveTypeTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitPrimitiveType(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitTypeParameter(TypeParameterTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitTypeParameter(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitInstanceOf(InstanceOfTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitInstanceOf(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitUnary(UnaryTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitUnary(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitVariable(VariableTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingElement(below);
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            this.addCorrespondingJavadoc(below);
            super.visitVariable(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitWhileLoop(WhileLoopTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitWhileLoop(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        public Void visitWildcard(WildcardTree tree, List<Node> d) {
            ArrayList<Node> below = new ArrayList<Node>();
            this.addCorrespondingType(below);
            this.addCorrespondingComments(below);
            super.visitWildcard(tree, below);
            d.add((Node)new TreeNode(this.info, this.getCurrentPath(), below));
            return null;
        }

        private void addCorrespondingJavadoc(List<Node> below) {
            DocCommentTree docCommentTree = ((DocTrees)this.info.getTrees()).getDocCommentTree(this.getCurrentPath());
            if (docCommentTree != null) {
                below.add((Node)new DocTreeNode(this.info, this.getCurrentPath(), docCommentTree, docCommentTree));
            } else {
                below.add((Node)new NotFoundJavadocNode("<javadoc-not-found>"));
            }
        }

        private void addCorrespondingElement(List<Node> below) {
            Element el = this.info.getTrees().getElement(this.getCurrentPath());
            below.add(TreeNode.nodeForElement(this.info, el));
        }

        private void addCorrespondingType(List<Node> below) {
            TypeMirror tm = this.info.getTrees().getTypeMirror(this.getCurrentPath());
            if (tm != null) {
                below.add((Node)new TypeNode(tm));
            } else {
                below.add((Node)new NotFoundTypeNode(NbBundle.getMessage(TreeNode.class, (String)"Cannot_Resolve_Type")));
            }
        }

        private void addCorrespondingComments(List<Node> below) {
            below.add((Node)new CommentsNode(NbBundle.getMessage(TreeNode.class, (String)"NM_Preceding_Comments"), this.info.getTreeUtilities().getComments(this.getCurrentPath().getLeaf(), true)));
            below.add((Node)new CommentsNode(NbBundle.getMessage(TreeNode.class, (String)"NM_Trailing_Comments"), this.info.getTreeUtilities().getComments(this.getCurrentPath().getLeaf(), false)));
        }
    }

    static final class NodeChilren
    extends Children.Keys<Node> {
        public NodeChilren(List<Node> nodes) {
            this.setKeys(nodes);
        }

        protected Node[] createNodes(Node key) {
            return new Node[]{key};
        }
    }
}

