/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.Serializable;
import java.util.Date;
import java.util.Set;
import org.apache.subversion.javahl.ConflictDescriptor;
import org.apache.subversion.javahl.types.Checksum;
import org.apache.subversion.javahl.types.Info;
import org.tigris.subversion.javahl.ConflictDescriptor;
import org.tigris.subversion.javahl.Depth;
import org.tigris.subversion.javahl.Lock;
import org.tigris.subversion.javahl.NodeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Info2
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String path;
    private String url;
    private long rev;
    private int kind;
    private String reposRootUrl;
    private String reposUUID;
    private long lastChangedRev;
    private long lastChangedDate;
    private String lastChangedAuthor;
    private Lock lock;
    private boolean hasWcInfo;
    private int schedule;
    private String copyFromUrl;
    private long copyFromRev;
    private long textTime;
    private long propTime;
    private String checksum;
    private String conflictOld;
    private String conflictNew;
    private String conflictWrk;
    private String prejfile;
    private String changelistName;
    private long workingSize;
    private long reposSize;
    private int depth;
    private ConflictDescriptor treeConflict;

    Info2(String string, String string2, long l, int n, String string3, String string4, long l2, long l3, String string5, Lock lock, boolean bl, int n2, String string6, long l4, long l5, long l6, String string7, String string8, String string9, String string10, String string11, String string12, long l7, long l8, int n3, ConflictDescriptor conflictDescriptor) {
        this.path = string;
        this.url = string2;
        this.rev = l;
        this.kind = n;
        this.reposRootUrl = string3;
        this.reposUUID = string4;
        this.lastChangedRev = l2;
        this.lastChangedDate = l3;
        this.lastChangedAuthor = string5;
        this.lock = lock;
        this.hasWcInfo = bl;
        this.schedule = n2;
        this.copyFromUrl = string6;
        this.copyFromRev = l4;
        this.textTime = l5;
        this.propTime = l6;
        this.checksum = string7;
        this.conflictOld = string8;
        this.conflictNew = string9;
        this.conflictWrk = string10;
        this.prejfile = string11;
        this.changelistName = string12;
        this.workingSize = l7;
        this.reposSize = l8;
        this.depth = n3;
        this.treeConflict = conflictDescriptor;
    }

    private static String getConflictOld(Set<org.apache.subversion.javahl.ConflictDescriptor> set) {
        if (set == null) {
            return null;
        }
        for (org.apache.subversion.javahl.ConflictDescriptor conflictDescriptor : set) {
            if (conflictDescriptor.getKind() != ConflictDescriptor.Kind.text) continue;
            return conflictDescriptor.getBasePath();
        }
        return null;
    }

    private static String getConflictNew(Set<org.apache.subversion.javahl.ConflictDescriptor> set) {
        if (set == null) {
            return null;
        }
        for (org.apache.subversion.javahl.ConflictDescriptor conflictDescriptor : set) {
            if (conflictDescriptor.getKind() != ConflictDescriptor.Kind.text) continue;
            return conflictDescriptor.getTheirPath();
        }
        return null;
    }

    private static String getConflictWrk(Set<org.apache.subversion.javahl.ConflictDescriptor> set) {
        if (set == null) {
            return null;
        }
        for (org.apache.subversion.javahl.ConflictDescriptor conflictDescriptor : set) {
            if (conflictDescriptor.getKind() != ConflictDescriptor.Kind.text) continue;
            return conflictDescriptor.getMyPath();
        }
        return null;
    }

    private static String getPrejfile(Set<org.apache.subversion.javahl.ConflictDescriptor> set) {
        if (set == null) {
            return null;
        }
        for (org.apache.subversion.javahl.ConflictDescriptor conflictDescriptor : set) {
            if (conflictDescriptor.getKind() != ConflictDescriptor.Kind.property) continue;
            return conflictDescriptor.getTheirPath();
        }
        return null;
    }

    private static ConflictDescriptor getTreeConflict(Set<org.apache.subversion.javahl.ConflictDescriptor> set) {
        if (set == null) {
            return null;
        }
        for (org.apache.subversion.javahl.ConflictDescriptor conflictDescriptor : set) {
            if (conflictDescriptor.getKind() != ConflictDescriptor.Kind.tree) continue;
            return new ConflictDescriptor(conflictDescriptor);
        }
        return null;
    }

    private static String getChecksumDigest(Checksum checksum) {
        if (checksum == null) {
            return null;
        }
        if (checksum.getKind() != Checksum.Kind.MD5) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (byte by : checksum.getDigest()) {
            stringBuffer.append(Integer.toHexString(0xFF & by));
        }
        return stringBuffer.toString();
    }

    public Info2(Info info) {
        this(info.getPath(), info.getUrl(), info.getRev(), NodeKind.fromApache(info.getKind()), info.getReposRootUrl(), info.getReposUUID(), info.getLastChangedRev(), info.getLastChangedDate() == null ? 0L : info.getLastChangedDate().getTime() * 1000L, info.getLastChangedAuthor(), info.getLock() == null ? null : new Lock(info.getLock()), info.isHasWcInfo(), info.getSchedule() == null ? 0 : info.getSchedule().ordinal(), info.getCopyFromUrl(), info.getCopyFromRev(), info.getTextTime() == null ? 0L : info.getTextTime().getTime() * 1000L, 0L, Info2.getChecksumDigest(info.getChecksum()), Info2.getConflictOld(info.getConflicts()), Info2.getConflictNew(info.getConflicts()), Info2.getConflictWrk(info.getConflicts()), Info2.getPrejfile(info.getConflicts()), info.getChangelistName(), info.getWorkingSize(), info.getReposSize(), Depth.fromADepth(info.getDepth()), Info2.getTreeConflict(info.getConflicts()));
    }

    public String getPath() {
        return this.path;
    }

    public String getUrl() {
        return this.url;
    }

    public long getRev() {
        return this.rev;
    }

    public int getKind() {
        return this.kind;
    }

    public String getReposRootUrl() {
        return this.reposRootUrl;
    }

    public String getReposUUID() {
        return this.reposUUID;
    }

    public long getLastChangedRev() {
        return this.lastChangedRev;
    }

    public Date getLastChangedDate() {
        if (this.lastChangedDate == 0L) {
            return null;
        }
        return new Date(this.lastChangedDate / 1000L);
    }

    public String getLastChangedAuthor() {
        return this.lastChangedAuthor;
    }

    public Lock getLock() {
        return this.lock;
    }

    public boolean isHasWcInfo() {
        return this.hasWcInfo;
    }

    public int getSchedule() {
        return this.schedule;
    }

    public String getCopyFromUrl() {
        return this.copyFromUrl;
    }

    public long getCopyFromRev() {
        return this.copyFromRev;
    }

    public Date getTextTime() {
        if (this.textTime == 0L) {
            return null;
        }
        return new Date(this.textTime / 1000L);
    }

    public Date getPropTime() {
        if (this.propTime == 0L) {
            return null;
        }
        return new Date(this.propTime / 1000L);
    }

    public String getChecksum() {
        return this.checksum;
    }

    public String getConflictOld() {
        return this.conflictOld;
    }

    public String getConflictNew() {
        return this.conflictNew;
    }

    public String getConflictWrk() {
        return this.conflictWrk;
    }

    public String getPrejfile() {
        return this.prejfile;
    }

    public String getChangelistName() {
        return this.changelistName;
    }

    public long getWorkingSize() {
        return this.workingSize;
    }

    public long getReposSize() {
        return this.reposSize;
    }

    public int getDepth() {
        return this.depth;
    }

    public ConflictDescriptor getConflictDescriptor() {
        return this.treeConflict;
    }

    public String toString() {
        return this.getUrl();
    }
}

