/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.javahl;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.subversion.javahl.types.Revision;
import org.tigris.subversion.javahl.RevisionKind;

public class Revision
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected int revKind;
    public static final Revision HEAD = new Revision(7, true);
    public static final Revision START = new Revision(0, true);
    public static final Revision COMMITTED = new Revision(3, true);
    public static final Revision PREVIOUS = new Revision(4, true);
    public static final Revision BASE = new Revision(5, true);
    public static final Revision WORKING = new Revision(6, true);
    public static final int SVN_INVALID_REVNUM = -1;

    public Revision(int n) {
        this(n, true);
    }

    protected Revision(int n, boolean bl) {
        if (n < 0 || n > 7) {
            throw new IllegalArgumentException(n + " is not a legal revision kind");
        }
        this.revKind = n;
    }

    public int getKind() {
        return this.revKind;
    }

    public String toString() {
        switch (this.revKind) {
            case 5: {
                return "BASE";
            }
            case 3: {
                return "COMMITTED";
            }
            case 7: {
                return "HEAD";
            }
            case 4: {
                return "PREV";
            }
            case 6: {
                return "WORKING";
            }
        }
        return super.toString();
    }

    public int hashCode() {
        return this.revKind * -1;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Revision)) {
            return false;
        }
        return ((Revision)object).revKind == this.revKind;
    }

    public static Revision getInstance(long l) {
        return new Number(l);
    }

    static Number createNumber(long l) {
        return l < 0L ? null : new Number(l);
    }

    public static Revision getInstance(Date date) {
        return new DateSpec(date);
    }

    public org.apache.subversion.javahl.types.Revision toApache() {
        return new org.apache.subversion.javahl.types.Revision(Kind.toAKind(this.revKind));
    }

    public static Revision createFromApache(org.apache.subversion.javahl.types.Revision revision) {
        Revision.Kind kind = revision.getKind();
        switch (kind) {
            case number: {
                return Revision.getInstance(((Revision.Number)revision).getNumber());
            }
            case date: {
                return Revision.getInstance(((Revision.DateSpec)revision).getDate());
            }
        }
        return Revision.getInstance(Kind.fromAKind(kind));
    }

    public static final class Kind
    implements RevisionKind {
        public static int fromAKind(Revision.Kind kind) {
            switch (kind) {
                default: {
                    return 0;
                }
                case number: {
                    return 1;
                }
                case date: {
                    return 2;
                }
                case committed: {
                    return 3;
                }
                case previous: {
                    return 4;
                }
                case base: {
                    return 5;
                }
                case head: {
                    return 7;
                }
                case working: 
            }
            return 6;
        }

        public static Revision.Kind toAKind(int n) {
            switch (n) {
                default: {
                    return Revision.Kind.unspecified;
                }
                case 1: {
                    return Revision.Kind.number;
                }
                case 2: {
                    return Revision.Kind.date;
                }
                case 3: {
                    return Revision.Kind.committed;
                }
                case 4: {
                    return Revision.Kind.previous;
                }
                case 5: {
                    return Revision.Kind.base;
                }
                case 7: {
                    return Revision.Kind.head;
                }
                case 6: 
            }
            return Revision.Kind.working;
        }
    }

    public static class DateSpec
    extends Revision {
        private static final long serialVersionUID = 1L;
        protected Date revDate;

        public DateSpec(Date date) {
            super(2, true);
            if (date == null) {
                throw new IllegalArgumentException("a date must be specified");
            }
            this.revDate = date;
        }

        public Date getDate() {
            return this.revDate;
        }

        public String toString() {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
            return '{' + simpleDateFormat.format(this.revDate) + '}';
        }

        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            return ((DateSpec)object).revDate.equals(this.revDate);
        }

        public int hashCode() {
            return this.revDate.hashCode();
        }

        public org.apache.subversion.javahl.types.Revision toApache() {
            return org.apache.subversion.javahl.types.Revision.getInstance(this.revDate);
        }
    }

    public static class Number
    extends Revision {
        private static final long serialVersionUID = 1L;
        protected long revNumber;

        public Number(long l) {
            super(1, true);
            if (l < 0L) {
                throw new IllegalArgumentException("Invalid (negative) revision number: " + l);
            }
            this.revNumber = l;
        }

        public long getNumber() {
            return this.revNumber;
        }

        public String toString() {
            return Long.toString(this.revNumber);
        }

        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            return ((Number)object).revNumber == this.revNumber;
        }

        public int hashCode() {
            return (int)(this.revNumber ^ this.revNumber >>> 32);
        }

        public org.apache.subversion.javahl.types.Revision toApache() {
            return org.apache.subversion.javahl.types.Revision.getInstance(this.revNumber);
        }
    }
}

