/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class ELIndex {
    private final QuerySupport querySupport;

    private ELIndex(QuerySupport querySupport) {
        this.querySupport = querySupport;
    }

    public static ELIndex get(FileObject file) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        Collection sourceRoots = QuerySupport.findRoots((Project)project, null, Collections.emptyList(), Collections.emptyList());
        try {
            QuerySupport support = QuerySupport.forRoots((String)"EL", (int)1, (FileObject[])sourceRoots.toArray(new FileObject[sourceRoots.size()]));
            return new ELIndex(support);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Collection<? extends IndexResult> findIdentifierReferences(String identifierName) {
        Collection<? extends IndexResult> queryResults = this.query("identifier", identifierName, QuerySupport.Kind.EXACT);
        return queryResults;
    }

    public Collection<? extends IndexResult> findPropertyReferences(String propertyName) {
        return this.query("property", propertyName, QuerySupport.Kind.EXACT);
    }

    public Collection<? extends IndexResult> findMethodReferences(String methodName) {
        Collection<? extends IndexResult> queryResults = this.query("method", methodName, QuerySupport.Kind.EXACT);
        return queryResults;
    }

    private Collection<? extends IndexResult> query(String field, String value, QuerySupport.Kind kind) {
        try {
            return this.querySupport.query(field, value, kind, new String[0]);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptySet();
        }
    }
}

