/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el.completion;

import com.sun.el.parser.Node;
import java.util.HashSet;
import java.util.Set;
import javax.el.ELException;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParser;
import org.netbeans.modules.web.el.ELPreprocessor;
import org.openide.util.Pair;

public final class ELSanitizer {
    static final String ADDED_SUFFIX = "x";
    static final String ADDED_QUOTED_SUFFIX = "'x'";
    private final ELPreprocessor expression;
    private final ELElement element;
    private static final Set<Pair<ELTokenId, ELTokenId>> BRACKETS = new HashSet<Pair<ELTokenId, ELTokenId>>();
    private final int relativeOffset;

    public ELSanitizer(ELElement element, int relativeOffset) {
        this.element = element;
        this.expression = element.getExpression();
        this.relativeOffset = relativeOffset;
    }

    public ELElement sanitized() {
        try {
            String sanitizedExpression = ELSanitizer.sanitize(this.expression.getOriginalExpression(), this.relativeOffset);
            ELPreprocessor elp = new ELPreprocessor(sanitizedExpression, new String[][][]{ELPreprocessor.XML_ENTITY_REFS_CONVERSION_TABLE});
            Node sanitizedNode = ELParser.parse(elp);
            return this.element.makeValidCopy(sanitizedNode, elp);
        }
        catch (ELException ex) {
            return this.element;
        }
    }

    static String sanitize(String expression) {
        return ELSanitizer.sanitize(expression, -1);
    }

    static String sanitize(String expression, int relativeOffset) {
        CleanExpression cleanExpression;
        boolean closingCurlyBracketAdded = false;
        String copy = expression;
        if (!expression.endsWith("}")) {
            copy = copy + "}";
            closingCurlyBracketAdded = true;
        }
        if ((cleanExpression = CleanExpression.getCleanExression(copy)) == null) {
            return expression;
        }
        String result = cleanExpression.clean;
        if (closingCurlyBracketAdded && (relativeOffset -= 2) >= 0) {
            result = ELSanitizer.secondPass(result, relativeOffset);
        }
        if (result.trim().isEmpty()) {
            result = result + ADDED_SUFFIX;
        }
        if (relativeOffset > 0 && relativeOffset < result.length()) {
            String exprEnd = result.substring(relativeOffset);
            String exprStart = result.substring(0, relativeOffset);
            result = ELSanitizer.thirdPass(exprStart, exprEnd) + exprEnd;
        } else {
            result = ELSanitizer.thirdPass(result, "");
        }
        return cleanExpression.prefix + result + cleanExpression.suffix;
    }

    private static String secondPass(String expression, int relativeOffset) {
        return expression.substring(0, relativeOffset);
    }

    private static String thirdPass(String expression, String ending) {
        char lastChar;
        int lastNonWhiteSpace;
        String spaces = "";
        if (expression.endsWith(" ") && (lastNonWhiteSpace = ELSanitizer.findLastNonWhiteSpace(expression)) > 0) {
            spaces = expression.substring(lastNonWhiteSpace + 1);
            expression = expression.substring(0, lastNonWhiteSpace + 1);
        }
        if (!(expression.isEmpty() || (lastChar = expression.charAt(expression.length() - 1)) != '\'' && lastChar != '\"')) {
            expression = expression + lastChar;
        }
        for (ELTokenId elToken : ELTokenId.values()) {
            if (elToken.fixedText() == null || !expression.endsWith(elToken.fixedText())) continue;
            for (Pair<ELTokenId, ELTokenId> bracket : BRACKETS) {
                if (expression.endsWith(((ELTokenId)bracket.first()).fixedText())) {
                    if (expression.endsWith(ELTokenId.LBRACKET.fixedText())) {
                        return expression + ADDED_QUOTED_SUFFIX + ((ELTokenId)bracket.second()).fixedText();
                    }
                    return expression + ((ELTokenId)bracket.second()).fixedText();
                }
                if (!expression.endsWith(((ELTokenId)bracket.second()).fixedText())) continue;
                if (expression.endsWith(ELTokenId.RBRACKET.fixedText())) {
                    return expression.substring(0, expression.length() - 1) + ADDED_QUOTED_SUFFIX + ELTokenId.RBRACKET.fixedText();
                }
                if (!expression.endsWith(ELTokenId.DOT.fixedText() + ELTokenId.RPAREN.fixedText()) && !expression.endsWith(ELTokenId.LAMBDA.fixedText() + ELTokenId.RPAREN.fixedText())) continue;
                return expression.substring(0, expression.length() - 1) + ADDED_SUFFIX + ELTokenId.RPAREN.fixedText();
            }
            if (ELTokenId.DOT == elToken) {
                if (ELSanitizer.unbalancedLeftParen(expression + ending)) {
                    return expression + ADDED_SUFFIX + ELTokenId.RPAREN.fixedText() + spaces;
                }
                return expression + ADDED_SUFFIX + spaces;
            }
            if (ELTokenId.COLON == elToken) {
                return expression + ADDED_SUFFIX + ELTokenId.LPAREN.fixedText() + ELTokenId.RPAREN.fixedText() + spaces;
            }
            if (ELTokenId.ELTokenCategories.OPERATORS.hasCategory((TokenId)elToken)) {
                return expression + spaces + ADDED_SUFFIX;
            }
            if (!ELTokenId.ELTokenCategories.KEYWORDS.hasCategory((TokenId)elToken)) continue;
            return expression + " " + spaces + ADDED_SUFFIX;
        }
        if (expression.contains(ELTokenId.COLON.fixedText())) {
            return expression + ELTokenId.LPAREN.fixedText() + ELTokenId.RPAREN.fixedText() + spaces;
        }
        if (ELSanitizer.unbalancedLeftBracket(expression)) {
            return expression + ELTokenId.RBRACKET.fixedText();
        }
        return expression + spaces;
    }

    private static boolean unbalancedLeftBracket(String expression) {
        return expression.indexOf(ELTokenId.LBRACKET.fixedText()) > expression.indexOf(ELTokenId.RBRACKET.fixedText());
    }

    private static boolean unbalancedLeftParen(String expression) {
        return expression.indexOf(ELTokenId.LPAREN.fixedText()) > expression.indexOf(ELTokenId.RPAREN.fixedText());
    }

    static int findLastNonWhiteSpace(String str) {
        int lastNonWhiteSpace = -1;
        for (int i = str.length() - 1; i >= 0; --i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            lastNonWhiteSpace = i;
            break;
        }
        return lastNonWhiteSpace;
    }

    static {
        BRACKETS.add((Pair<ELTokenId, ELTokenId>)Pair.of((Object)ELTokenId.LBRACKET, (Object)ELTokenId.RBRACKET));
        BRACKETS.add((Pair<ELTokenId, ELTokenId>)Pair.of((Object)ELTokenId.LPAREN, (Object)ELTokenId.RPAREN));
    }

    private static class CleanExpression {
        private final String clean;
        private final String prefix;
        private final String suffix;

        public CleanExpression(String clean, String prefix, String suffix) {
            this.clean = clean;
            this.prefix = prefix;
            this.suffix = suffix;
        }

        private static CleanExpression getCleanExression(String expression) {
            if ((expression.startsWith("#{") || expression.startsWith("${")) && expression.endsWith("}")) {
                String prefix = expression.substring(0, 2);
                String clean = expression.substring(2, expression.length() - 1);
                String suffix = expression.substring(expression.length() - 1);
                return new CleanExpression(clean, prefix, suffix);
            }
            return null;
        }
    }
}

