/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.actions;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.common.api.ServerURLMapping;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;

public final class Resource {
    private static final Map<Ref, FileObject> cache = new HashMap<Ref, FileObject>();
    private final String name;
    private final Project project;

    public Resource(Project project, String name) {
        this.project = project;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Project getProject() {
        return this.project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject toFileObject() {
        Object cached;
        Ref ref = new Ref(this);
        Map<Ref, FileObject> map = cache;
        synchronized (map) {
            if (cache.containsKey(ref) && ((cached = cache.get(ref)) == null || cached.isValid())) {
                return cached;
            }
        }
        FileObject result = null;
        assert (!Children.MUTEX.isReadAccess() && !Children.MUTEX.isWriteAccess());
        if (this.project != null) {
            try {
                result = ServerURLMapping.fromServer((Project)this.project, (URL)new URL(this.name));
                cached = cache;
                synchronized (cached) {
                    cache.put(ref, result);
                }
                return result;
            }
            catch (MalformedURLException ex) {
                // empty catch block
            }
        }
        if (this.name != null && this.name.startsWith("file://")) {
            try {
                URI uri = new URI(this.name);
                if (uri.getAuthority() != null || uri.getFragment() != null || uri.getQuery() != null) {
                    uri = new URI(uri.getScheme(), null, uri.getPath(), null, null);
                }
                File file = new File(uri);
                file = FileUtil.normalizeFile((File)file);
                result = FileUtil.toFileObject((File)file);
            }
            catch (URISyntaxException ex) {
                Logger.getLogger(Resource.class.getName()).log(Level.INFO, null, ex);
            }
        }
        Map<Ref, FileObject> map2 = cache;
        synchronized (map2) {
            cache.put(ref, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearCache() {
        Map<Ref, FileObject> map = cache;
        synchronized (map) {
            cache.clear();
        }
    }

    static class Ref {
        private final Resource resource;

        Ref(Resource resource) {
            this.resource = resource;
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + (this.resource.name == null ? 0 : this.resource.name.hashCode());
            hash = 97 * hash + (this.resource.project == null ? 0 : this.resource.project.hashCode());
            return hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Ref)) {
                return false;
            }
            Ref other = (Ref)object;
            if (this.resource.name == null ? other.resource.name != null : !this.resource.name.equals(other.resource.name)) {
                return false;
            }
            return this.resource.project == other.resource.project || this.resource.project != null && this.resource.project.equals(other.resource.project);
        }
    }
}

