/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit;

import java.awt.Image;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.web.inspect.actions.Resource;
import org.netbeans.modules.web.inspect.webkit.AttributesPropertySet;
import org.netbeans.modules.web.inspect.webkit.DOMNodeAnnotator;
import org.netbeans.modules.web.inspect.webkit.DOMSourceElementHandle;
import org.netbeans.modules.web.inspect.webkit.WebKitPageModel;
import org.netbeans.modules.web.inspect.webkit.actions.GoToNodeSourceAction;
import org.netbeans.modules.web.inspect.webkit.actions.ShowKnockoutContextAction;
import org.netbeans.modules.web.inspect.webkit.knockout.KnockoutTCController;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class DOMNode
extends AbstractNode {
    private static final String ACTIONS_PATH = "Navigation/DOM/Actions";
    static final String ICON_BASE = "org/netbeans/modules/web/inspect/resources/domElement.png";
    private Node node;
    private Node.PropertySet[] propertySets;
    private final boolean nodeIdInDisplayName = Boolean.getBoolean("org.netbeans.modules.web.inspect.nodeIdInDisplayName");
    private final WebKitPageModel model;

    public DOMNode(WebKitPageModel model, Node node) {
        super((Children)(DOMNode.shouldBeLeaf(node) ? Children.LEAF : new DOMChildren(model)), DOMNode.lookupFor(model, node));
        this.node = node;
        this.model = model;
        this.setIconBaseWithExtension(ICON_BASE);
        this.setName(node.getNodeName());
        this.updateDisplayName();
    }

    private static Lookup lookupFor(WebKitPageModel model, Node node) {
        ArrayList<Object> items = new ArrayList<Object>();
        items.add(node);
        Project project = model.getProject();
        items.add(new DOMSourceElementHandle(node, project));
        String documentURL = node.getDocumentURL();
        if (documentURL != null) {
            items.add(new Resource(project, documentURL));
        }
        if (project != null) {
            items.add(project);
        }
        return Lookups.fixed((Object[])items.toArray());
    }

    public static String htmlDisplayName(String tagName, String selector) {
        String pattern = NbBundle.getMessage(DOMNode.class, (String)"DOMNode.elementDisplayName");
        int maxSelectorLength = 100;
        if (selector.length() > maxSelectorLength) {
            selector = selector.substring(0, maxSelectorLength) + "...";
        }
        return MessageFormat.format(pattern, tagName.toLowerCase(), selector);
    }

    public static String selector(String nodeId, String nodeClasses) {
        StringBuilder selector = new StringBuilder();
        if (nodeId != null) {
            selector.append('#').append(nodeId);
        }
        if (nodeClasses != null) {
            StringTokenizer st = new StringTokenizer(nodeClasses);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                selector.append('.').append(token.trim());
            }
        }
        return selector.toString();
    }

    public String getHtmlDisplayName() {
        String displayName;
        ResourceBundle bundle = NbBundle.getBundle(DOMNode.class);
        int nodeType = this.node.getNodeType();
        if (nodeType == 1) {
            String tagName = this.node.getNodeName().toLowerCase(Locale.ENGLISH);
            String selector = this.getSelector();
            displayName = DOMNode.htmlDisplayName(tagName, selector);
        } else {
            displayName = nodeType == 9 ? bundle.getString("DOMNode.documentDisplayName") : (nodeType == 11 ? bundle.getString("DOMNode.shadowRootDisplayName") : this.node.getNodeType() + " " + this.node.getNodeName() + " " + this.node.getNodeValue());
        }
        if (this.nodeIdInDisplayName) {
            displayName = displayName + " (" + this.getNode().getNodeId() + ")";
        }
        return displayName;
    }

    public Image getIcon(int type) {
        Image image = super.getIcon(type);
        return DOMNodeAnnotator.getDefault().annotateIcon(this.node, image);
    }

    public Image getOpenedIcon(int type) {
        Image image = super.getIcon(type);
        return DOMNodeAnnotator.getDefault().annotateIcon(this.node, image);
    }

    void updateIcon() {
        this.fireIconChange();
        this.fireOpenedIconChange();
    }

    private String getSelector() {
        Node.Attribute idAttr = this.node.getAttribute("id");
        String nodeId = idAttr == null ? null : idAttr.getValue();
        Node.Attribute classAttr = this.node.getAttribute("class");
        String nodeClasses = classAttr == null ? null : classAttr.getValue();
        return DOMNode.selector(nodeId, nodeClasses);
    }

    public synchronized Node.PropertySet[] getPropertySets() {
        if (this.propertySets == null) {
            this.propertySets = this.createPropertySets();
        }
        return this.propertySets;
    }

    private Node.PropertySet[] createPropertySets() {
        return new Node.PropertySet[]{new AttributesPropertySet(this)};
    }

    synchronized void updateAttributes() {
        if (this.propertySets != null) {
            for (Node.PropertySet set : this.propertySets) {
                if (!(set instanceof AttributesPropertySet)) continue;
                ((AttributesPropertySet)set).update();
            }
            this.firePropertySetsChange(null, null);
        }
        this.updateDisplayName();
    }

    void updateCharacterData() {
        this.updateDisplayName();
    }

    private void updateDisplayName() {
        String tagName = this.node.getNodeName().toLowerCase(Locale.ENGLISH);
        String selector = this.getSelector();
        this.setDisplayName(tagName + selector);
    }

    Node getNode() {
        return this.node;
    }

    void updateChildren(Node node) {
        this.updateChildren(node, null);
    }

    void updateChildren(Node node, Node childToRefresh) {
        this.node = node;
        boolean shouldBeLeaf = DOMNode.shouldBeLeaf(node);
        if (shouldBeLeaf != this.isLeaf()) {
            this.setChildren((Children)(shouldBeLeaf ? Children.LEAF : new DOMChildren(this.model)));
        }
        if (!shouldBeLeaf) {
            DOMChildren children = (DOMChildren)this.getChildren();
            children.updateKeys(node, childToRefresh);
        }
    }

    private static boolean shouldBeLeaf(Node node) {
        if (node.getContentDocument() != null || !node.getShadowRoots().isEmpty()) {
            return false;
        }
        List subNodes = node.getChildren();
        if (subNodes == null) {
            return false;
        }
        for (Node subNode : subNodes) {
            boolean isElement = subNode.getNodeType() == 1;
            if (!isElement || subNode.isInjectedByNetBeans()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return super.toString() + "[nodeId=" + this.getNode().getNodeId() + ", identityHashCode=" + System.identityHashCode((Object)this) + "]";
    }

    public Action[] getActions(boolean context) {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(SystemAction.get(GoToNodeSourceAction.class));
        if (KnockoutTCController.isKnockoutUsed()) {
            actions.add(SystemAction.get(ShowKnockoutContextAction.class));
        }
        if (this.node.getNodeType() == 1) {
            for (Action action : Utilities.actionsForPath((String)ACTIONS_PATH)) {
                if (action instanceof ContextAwareAction) {
                    ProxyLookup lookup = new ProxyLookup(new Lookup[]{Lookups.fixed((Object[])new Object[]{this}), this.getLookup()});
                    action = ((ContextAwareAction)action).createContextAwareInstance((Lookup)lookup);
                }
                actions.add(action);
            }
            actions.add(null);
            actions.add(SystemAction.get(PropertiesAction.class));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public Action getPreferredAction() {
        return SystemAction.get(GoToNodeSourceAction.class);
    }

    static class DOMChildren
    extends Children.Keys<Integer> {
        private final WebKitPageModel pageModel;

        DOMChildren(WebKitPageModel pageModel) {
            this.pageModel = pageModel;
        }

        void updateKeys(Node node, Node childToRefresh) {
            Node contentDocument;
            ArrayList<Integer> keys = new ArrayList<Integer>();
            List subNodes = node.getChildren();
            if (subNodes != null) {
                for (Node subNode : subNodes) {
                    boolean isElement = subNode.getNodeType() == 1;
                    if (!isElement || subNode.isInjectedByNetBeans()) continue;
                    keys.add(subNode.getNodeId());
                }
            }
            if ((contentDocument = node.getContentDocument()) != null) {
                keys.add(contentDocument.getNodeId());
            }
            for (Node shadowRoot : node.getShadowRoots()) {
                keys.add(shadowRoot.getNodeId());
            }
            this.setKeys(keys);
            if (childToRefresh != null) {
                this.refreshKey(childToRefresh.getNodeId());
            }
            this.getNodes(true);
        }

        protected org.openide.nodes.Node[] createNodes(Integer nodeId) {
            org.openide.nodes.Node[] result;
            DOMNode node = this.pageModel.getNode(nodeId);
            if (node == null) {
                result = null;
            } else {
                org.openide.nodes.Node oldParent = node.getParentNode();
                org.openide.nodes.Node newParent = this.getNode();
                if (oldParent == null || oldParent == newParent) {
                    result = new org.openide.nodes.Node[]{node};
                } else {
                    Logger.getLogger(DOMChildren.class.getName()).log(Level.INFO, "Node {0} cannot be added to node {1} because it already belongs to {2}!", new Object[]{node, newParent, oldParent});
                    result = null;
                }
            }
            return result;
        }
    }
}

