/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.inspect.webkit.knockout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.netbeans.modules.web.inspect.webkit.knockout.KnockoutNode;
import org.netbeans.modules.web.webkit.debugging.api.WebKitDebugging;
import org.netbeans.modules.web.webkit.debugging.api.debugger.PropertyDescriptor;
import org.netbeans.modules.web.webkit.debugging.api.debugger.RemoteObject;
import org.netbeans.modules.web.webkit.debugging.api.dom.Node;
import org.openide.nodes.ChildFactory;

public class KnockoutChildFactory
extends ChildFactory<PropertyDescriptor> {
    private RemoteObject remoteObject;
    private WebKitDebugging webKit;
    private Node webKitNode;

    KnockoutChildFactory(WebKitDebugging webKit, Node webKitNode) {
        this.webKit = webKit;
        this.webKitNode = webKitNode;
    }

    KnockoutChildFactory(RemoteObject remoteObject) {
        this.remoteObject = remoteObject;
    }

    protected boolean createKeys(List<PropertyDescriptor> toPopulate) {
        if (this.webKitNode != null) {
            RemoteObject jsNode = this.webKit.getDOM().resolveNode(this.webKitNode, null);
            String function = "function() { return window.NetBeans && NetBeans.getKnockoutVersion() ? NetBeans.getKnockout().contextFor(this) : null; }";
            this.remoteObject = this.webKit.getRuntime().callFunctionOn(jsNode, function);
        }
        if (this.remoteObject.getType() == RemoteObject.Type.OBJECT) {
            List properties = this.remoteObject.getProperties();
            toPopulate.addAll(KnockoutChildFactory.sort(properties));
        }
        return true;
    }

    static List<PropertyDescriptor> sort(List<PropertyDescriptor> list) {
        ArrayList<PropertyDescriptor> copy = new ArrayList<PropertyDescriptor>();
        copy.addAll(list);
        Collections.sort(copy, PropertyDescriptorComparator.getInstance());
        return copy;
    }

    protected org.openide.nodes.Node createNodeForKey(PropertyDescriptor key) {
        return new KnockoutNode(key.getName(), key.getValue());
    }

    void refresh() {
        this.remoteObject.resetProperties();
        this.refresh(false);
    }

    private static class PropertyDescriptorComparator
    implements Comparator<PropertyDescriptor> {
        private static final PropertyDescriptorComparator INSTANCE = new PropertyDescriptorComparator();
        private static final String PROTOTYPE = "__proto__";

        private PropertyDescriptorComparator() {
        }

        static final PropertyDescriptorComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(PropertyDescriptor descriptor1, PropertyDescriptor descriptor2) {
            String name1 = descriptor1.getName();
            String name2 = descriptor2.getName();
            Data data1 = PropertyDescriptorComparator.data(name1);
            Data data2 = PropertyDescriptorComparator.data(name2);
            int diff = data1.group - data2.group;
            if (diff == 0) {
                diff = data1.item.compareTo(data2.item);
            }
            return diff;
        }

        private static Data data(String name) {
            Data data = new Data();
            if (PROTOTYPE.equals(name)) {
                data.item = name;
                data.group = 3;
            } else {
                try {
                    data.item = Long.valueOf(Long.parseLong(name));
                    data.group = 1;
                }
                catch (NumberFormatException nfex) {
                    data.item = name;
                    data.group = 2;
                }
            }
            return data;
        }

        static class Data {
            int group;
            Comparable item;

            Data() {
            }
        }
    }
}

