/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.swing.AbstractButton;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.HgLogMessage;
import org.netbeans.modules.mercurial.ui.merge.MergeAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.AccessibleJFileChooser;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ImportDiffAction
extends ContextAction {
    @Override
    protected boolean enable(Node[] nodes) {
        return HgUtils.isFromHgRepository(HgUtils.getCurrentContext(nodes));
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_ImportDiff";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        ImportDiffAction.importDiff(context);
    }

    private static void importDiff(VCSContext ctx) {
        File[] roots = HgUtils.getActionRoots(ctx);
        if (roots == null || roots.length == 0) {
            return;
        }
        File root = Mercurial.getInstance().getRepositoryRoot(roots[0]);
        AccessibleJFileChooser fileChooser = new AccessibleJFileChooser(NbBundle.getMessage(ImportDiffAction.class, (String)"ACSD_ImportBrowseFolder"), null);
        fileChooser.setDialogTitle(NbBundle.getMessage(ImportDiffAction.class, (String)"ImportBrowse_title"));
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setDialogType(0);
        fileChooser.setApproveButtonMnemonic(NbBundle.getMessage(ImportDiffAction.class, (String)"Import").charAt(0));
        fileChooser.setApproveButtonText(NbBundle.getMessage(ImportDiffAction.class, (String)"Import"));
        fileChooser.setCurrentDirectory(new File(HgModuleConfig.getDefault().getImportFolder()));
        JPanel panel = new JPanel();
        JRadioButton asPatch = new JRadioButton(NbBundle.getMessage(ImportDiffAction.class, (String)"CTL_Import_PatchOption"));
        Mnemonics.setLocalizedText((AbstractButton)asPatch, (String)asPatch.getText());
        JRadioButton asBundle = new JRadioButton(NbBundle.getMessage(ImportDiffAction.class, (String)"CTL_Import_BundleOption"));
        Mnemonics.setLocalizedText((AbstractButton)asBundle, (String)asBundle.getText());
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(asBundle);
        buttonGroup.add(asPatch);
        asPatch.setSelected(true);
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(asPatch);
        panel.add(asBundle);
        fileChooser.setAccessory(panel);
        DialogDescriptor dd = new DialogDescriptor((Object)fileChooser, NbBundle.getMessage(ImportDiffAction.class, (String)"ImportBrowse_title"));
        dd.setOptions(new Object[0]);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
        fileChooser.addActionListener(new ActionListener((JFileChooser)fileChooser, root, asBundle, asPatch, dialog){
            final /* synthetic */ JFileChooser val$fileChooser;
            final /* synthetic */ File val$root;
            final /* synthetic */ JRadioButton val$asBundle;
            final /* synthetic */ JRadioButton val$asPatch;
            final /* synthetic */ Dialog val$dialog;
            {
                this.val$fileChooser = jFileChooser;
                this.val$root = file;
                this.val$asBundle = jRadioButton;
                this.val$asPatch = jRadioButton2;
                this.val$dialog = dialog;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String state = e.getActionCommand();
                if (state.equals("ApproveSelection")) {
                    File patchFile = this.val$fileChooser.getSelectedFile();
                    HgModuleConfig.getDefault().setImportFolder(patchFile.getParent());
                    RequestProcessor rp = Mercurial.getInstance().getRequestProcessor(this.val$root);
                    ImportDiffProgressSupport.Kind kind = this.val$asBundle.isSelected() ? ImportDiffProgressSupport.Kind.BUNDLE : (this.val$asPatch.isSelected() ? ImportDiffProgressSupport.Kind.PATCH : null);
                    ImportDiffProgressSupport support = new ImportDiffProgressSupport(this.val$root, patchFile, true, kind);
                    support.start(rp, this.val$root, NbBundle.getMessage(ImportDiffAction.class, (String)"LBL_ImportDiff_Progress"));
                }
                this.val$dialog.dispose();
            }
        });
        dialog.setVisible(true);
    }

    static class ImportDiffProgressSupport
    extends HgProgressSupport {
        private final File patchFile;
        private final File repository;
        private final Kind kind;
        private final boolean commit;

        public ImportDiffProgressSupport(File repository, File patchFile, boolean commit, Kind kind) {
            this.repository = repository;
            this.patchFile = patchFile;
            this.kind = kind;
            this.commit = commit;
        }

        @Override
        public void perform() {
            if (this.kind == Kind.BUNDLE) {
                this.performUnbundle();
            } else if (this.kind == Kind.PATCH) {
                this.performImport();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performUnbundle() {
            final OutputLogger logger = this.getLogger();
            try {
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_UNBUNDLE_TITLE"));
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_UNBUNDLE_TITLE_SEP"));
                HgUtils.runWithoutIndexing(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        List<String> list = HgCommand.doUnbundle(ImportDiffProgressSupport.this.repository, ImportDiffProgressSupport.this.patchFile, true, logger);
                        if (list != null && !list.isEmpty()) {
                            List<String> updatedFilesList = list;
                            logger.output(HgUtils.replaceHttpPassword(list));
                            boolean bMergeNeededDueToPull = HgCommand.isMergeNeededMsg(list.get(list.size() - 1));
                            boolean bConfirmMerge = false;
                            boolean warnMoreHeads = true;
                            if (bMergeNeededDueToPull) {
                                bConfirmMerge = HgUtils.confirmDialog(ImportDiffAction.class, "MSG_UNBUNDLE_MERGE_CONFIRM_TITLE", "MSG_UNBUNDLE_MERGE_CONFIRM_QUERY");
                                warnMoreHeads = false;
                            } else {
                                boolean bOutStandingUncommittedMerges = HgCommand.isMergeAbortUncommittedMsg(list.get(list.size() - 1));
                                if (bOutStandingUncommittedMerges) {
                                    bConfirmMerge = HgUtils.confirmDialog(ImportDiffAction.class, "MSG_UNBUNDLE_MERGE_CONFIRM_TITLE", "MSG_UNBUNDLE_MERGE_UNCOMMITTED_CONFIRM_QUERY");
                                }
                            }
                            if (bConfirmMerge) {
                                logger.output("");
                                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_UNBUNDLE_MERGE_DO"));
                                List<String> mergeResult = MergeAction.doMergeAction(ImportDiffProgressSupport.this.repository, null, logger);
                                if (mergeResult != null) {
                                    updatedFilesList.addAll(mergeResult);
                                }
                            } else {
                                HgLogMessage[] heads = HgCommand.getHeadRevisionsInfo(ImportDiffProgressSupport.this.repository, false, OutputLogger.getLogger(null));
                                Map<String, Collection<HgLogMessage>> branchHeads = HgUtils.sortByBranch(heads);
                                if (!branchHeads.isEmpty()) {
                                    MergeAction.displayMergeWarning(branchHeads, logger, warnMoreHeads);
                                }
                            }
                            boolean fileUpdated = ImportDiffProgressSupport.isUpdated(updatedFilesList);
                            if (fileUpdated) {
                                HgUtils.notifyUpdatedFiles(ImportDiffProgressSupport.this.repository, updatedFilesList);
                                HgUtils.forceStatusRefresh(ImportDiffProgressSupport.this.repository);
                            }
                        }
                        return null;
                    }
                }, this.repository);
            }
            catch (HgException.HgCommandCanceledException ex) {
            }
            catch (HgException ex) {
                HgUtils.notifyException(ex);
            }
            finally {
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_UNBUNDLE_DONE"));
                logger.output("");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void performImport() {
            final OutputLogger logger = this.getLogger();
            try {
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_IMPORT_TITLE"));
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_IMPORT_TITLE_SEP"));
                HgUtils.runWithoutIndexing(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        List<String> list = HgCommand.doImport(ImportDiffProgressSupport.this.repository, ImportDiffProgressSupport.this.patchFile, ImportDiffProgressSupport.this.commit, logger);
                        if (ImportDiffProgressSupport.this.commit) {
                            Mercurial.getInstance().historyChanged(ImportDiffProgressSupport.this.repository);
                            Mercurial.getInstance().changesetChanged(ImportDiffProgressSupport.this.repository);
                        } else {
                            HgUtils.notifyUpdatedFiles(ImportDiffProgressSupport.this.repository, list);
                            HgUtils.forceStatusRefresh(ImportDiffProgressSupport.this.repository);
                        }
                        logger.output(list);
                        return null;
                    }
                }, this.repository);
            }
            catch (HgException.HgCommandCanceledException ex) {
            }
            catch (HgException ex) {
                HgUtils.notifyException(ex);
            }
            finally {
                logger.outputInRed(NbBundle.getMessage(ImportDiffAction.class, (String)"MSG_IMPORT_DONE"));
                logger.output("");
            }
        }

        private static boolean isUpdated(List<String> list) {
            boolean updated = false;
            for (String s : list) {
                if (!s.contains("getting ") && !s.startsWith("merging ")) continue;
                updated = true;
                break;
            }
            return updated;
        }

        static enum Kind {
            PATCH,
            BUNDLE;

        }
    }
}

