/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.FieldData;
import org.netbeans.modules.mobility.javon.JavonMapping;
import org.netbeans.modules.mobility.javon.JavonSerializer;
import org.netbeans.modules.mobility.javon.Traversable;

public class BeanTypeSerializer
implements JavonSerializer {
    private Map<String, ClassData> beanTypes = new HashMap<String, ClassData>();
    private static final Set<String> UNSUPPORTED_PACKAGES = new HashSet<String>(Arrays.asList("javax", "java"));

    @Override
    public String getName() {
        return "Bean type serializer";
    }

    @Override
    public boolean isTypeSupported(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        if (TypeKind.ARRAY == type.getKind()) {
            return false;
        }
        if (TypeKind.DECLARED == type.getKind()) {
            TypeElement clazz = (TypeElement)((DeclaredType)type).asElement();
            String shortName = clazz.getSimpleName().toString();
            String classFullQualifiedName = clazz.getQualifiedName().toString();
            if ("java.lang.Object".equals(classFullQualifiedName)) {
                return false;
            }
            if (classFullQualifiedName.startsWith("java.util")) {
                return false;
            }
            String packageName = "";
            if (shortName.length() != classFullQualifiedName.length()) {
                int fqnLength = classFullQualifiedName.length();
                int shortLength = shortName.length();
                packageName = classFullQualifiedName.substring(fqnLength - shortLength - 1);
            }
            if (clazz.getSuperclass().getKind() != TypeKind.DECLARED) {
                return false;
            }
            TypeElement superClass = (TypeElement)((DeclaredType)clazz.getSuperclass()).asElement();
            if (!traversable.isTypeSupported(clazz.getSuperclass(), typeCache) && !"java.lang.Object".equals(superClass.getQualifiedName().toString())) {
                return false;
            }
            List<ExecutableElement> constructors = ElementFilter.constructorsIn(clazz.getEnclosedElements());
            boolean validConstructor = false;
            for (ExecutableElement ee : constructors) {
                if (ee.getParameters().size() != 0 || !ee.getModifiers().contains((Object)Modifier.PUBLIC) || ee.getModifiers().contains((Object)Modifier.STATIC)) continue;
                validConstructor = true;
                break;
            }
            return validConstructor;
        }
        return false;
    }

    @Override
    public ClassData getType(Traversable traversable, TypeMirror type, Map<String, ClassData> typeCache) {
        if (TypeKind.ARRAY == type.getKind()) {
            return null;
        }
        if (TypeKind.DECLARED == type.getKind()) {
            TypeElement clazz = (TypeElement)((DeclaredType)type).asElement();
            String shortName = clazz.getSimpleName().toString();
            String classFullQualifiedName = clazz.getQualifiedName().toString();
            String packageName = "";
            if (shortName.length() != classFullQualifiedName.length()) {
                int fqnLength = classFullQualifiedName.length();
                int shortLength = shortName.length();
                packageName = classFullQualifiedName.substring(0, fqnLength - shortLength - 1);
            }
            for (String unsupportedPackage : UNSUPPORTED_PACKAGES) {
                if (!packageName.startsWith(unsupportedPackage)) continue;
                return null;
            }
            if (typeCache.get(classFullQualifiedName) != null) {
                return typeCache.get(classFullQualifiedName);
            }
            ClassData cd = this.beanTypes.get(classFullQualifiedName);
            if (cd != null) {
                return cd;
            }
            cd = new ClassData(packageName, shortName, false, false, (JavonSerializer)this);
            this.beanTypes.put(classFullQualifiedName, cd);
            typeCache.put(classFullQualifiedName, cd);
            for (VariableElement e : ElementFilter.fieldsIn(clazz.getEnclosedElements())) {
                if (e.getModifiers().contains((Object)Modifier.STATIC) || e.getModifiers().contains((Object)Modifier.FINAL)) continue;
                ClassData fieldClass = traversable.traverseType(e.asType(), typeCache);
                if (fieldClass == null) {
                    cd.addInvalidField(e);
                    continue;
                }
                String methodPartName = e.getSimpleName().toString().substring(0, 1).toUpperCase() + e.getSimpleName().toString().substring(1);
                String setterName = "set" + methodPartName;
                String getterName = (e.asType().getKind() == TypeKind.BOOLEAN ? "is" : "get") + methodPartName;
                FieldData field = new FieldData(e.getSimpleName().toString(), fieldClass);
                if (e.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    field.setModifier(ClassData.Modifier.PUBLIC);
                    cd.addField(field);
                    traversable.registerType(fieldClass);
                    continue;
                }
                boolean hasSetter = false;
                boolean hasGetter = false;
                for (ExecutableElement ee : ElementFilter.methodsIn(clazz.getEnclosedElements())) {
                    String eeName = ee.getSimpleName().toString();
                    if (setterName.equals(eeName)) {
                        field.setSetter(setterName);
                        hasSetter = true;
                    }
                    if (!getterName.equals(eeName)) continue;
                    field.setGetter(getterName);
                    hasGetter = true;
                }
                field.setModifier(ClassData.Modifier.PRIVATE);
                if (!hasGetter || !hasSetter) continue;
                cd.addField(field);
                traversable.registerType(fieldClass);
            }
            if (clazz.getSuperclass().getKind() == TypeKind.DECLARED) {
                TypeElement superclass = (TypeElement)((DeclaredType)clazz.getSuperclass()).asElement();
                ClassData superType = traversable.traverseType(superclass.asType(), typeCache);
                if (superType != null) {
                    traversable.registerType(superType);
                    cd.setParent(superType);
                } else if (!"java.lang.Object".equals(superclass.getQualifiedName().toString())) {
                    return null;
                }
            }
            return cd;
        }
        return null;
    }

    @Override
    public String instanceOf(JavonMapping mapping, ClassData type) {
        if (this.beanTypes.get(type.getFullyQualifiedName()) != null) {
            return type.getFullyQualifiedName();
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String toObject(JavonMapping mapping, ClassData type, String variable) {
        if (this.beanTypes.get(type.getFullyQualifiedName()) != null) {
            return "(" + type.getFullyQualifiedName() + ")" + (variable == null ? "" : variable);
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String fromObject(JavonMapping mapping, ClassData type, String object) {
        if (this.beanTypes.get(type.getFullyQualifiedName()) != null) {
            return "(" + type.getFullyQualifiedName() + ")" + object;
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String toStream(JavonMapping mapping, ClassData type, String stream, String object) {
        if (this.beanTypes.get(type.getFullyQualifiedName()) != null) {
            String serialization = "";
            String beanInstanceName = "b_" + type.getFullyQualifiedName().replace(".", "_");
            serialization = serialization + type.getFullyQualifiedName() + " " + beanInstanceName + " = (" + type.getFullyQualifiedName() + ")" + object + ";\n";
            for (FieldData field : type.getAllFields()) {
                String id = "";
                id = ", " + mapping.getRegistry().getRegisteredTypeId(field.getType());
                if (mapping.getProperty("target").equals("client") && mapping.getProperty("create-stubs").equals("true") || field.getModifier() == ClassData.Modifier.PUBLIC) {
                    if (field.getType().isPrimitive()) {
                        serialization = serialization + mapping.getRegistry().getTypeSerializer(field.getType()).toStream(mapping, field.getType(), stream, beanInstanceName + "." + field.getName()) + "\n";
                        continue;
                    }
                    serialization = serialization + "writeObject(" + stream + ", " + beanInstanceName + "." + field.getName() + id + ");\n";
                    continue;
                }
                if (field.getType().isPrimitive()) {
                    serialization = serialization + mapping.getRegistry().getTypeSerializer(field.getType()).toStream(mapping, field.getType(), stream, beanInstanceName + "." + this.getGetter(field) + "()") + "\n";
                    continue;
                }
                serialization = serialization + "writeObject(" + stream + ", " + beanInstanceName + "." + this.getGetter(field) + "()" + id + ");\n";
            }
            return serialization;
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    @Override
    public String fromStream(JavonMapping mapping, ClassData type, String stream, String object) {
        if (this.beanTypes.get(type.getFullyQualifiedName()) != null) {
            String beanInstanceName = "b_" + type.getFullyQualifiedName().replace(".", "_");
            String deserialization = type.getFullyQualifiedName() + " " + beanInstanceName + " = new " + type.getFullyQualifiedName() + "();\n";
            for (FieldData field : type.getAllFields()) {
                if (mapping.getProperty("target").equals("client") && mapping.getProperty("create-stubs").equals("true") || field.getModifier() == ClassData.Modifier.PUBLIC) {
                    if (field.getType().isPrimitive() && !field.getType().isArray()) {
                        deserialization = deserialization + beanInstanceName + "." + field.getName() + " = " + field.getType().getSerializer().fromStream(mapping, field.getType(), stream, null) + ";\n";
                        continue;
                    }
                    deserialization = deserialization + beanInstanceName + "." + field.getName() + " = (" + field.getType().getSerializer().instanceOf(mapping, field.getType()) + ") readObject(" + stream + ");\n";
                    continue;
                }
                if (field.getType().isPrimitive() && !field.getType().isArray()) {
                    deserialization = deserialization + beanInstanceName + "." + this.getSetter(field) + "(" + mapping.getRegistry().getTypeSerializer(field.getType()).fromStream(mapping, field.getType(), stream, null) + ");\n";
                    continue;
                }
                deserialization = deserialization + beanInstanceName + "." + this.getSetter(field) + "((" + field.getType().getSerializer().instanceOf(mapping, field.getType()) + ") readObject(" + stream + "));\n";
            }
            deserialization = deserialization + (object == null ? "" : object + " = " + beanInstanceName + ";\n");
            return deserialization;
        }
        throw new IllegalArgumentException("Invalid type: " + type.getName());
    }

    private String getSetter(FieldData field) {
        return "set" + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }

    private String getGetter(FieldData field) {
        return (!field.getType().getClassName().toLowerCase().equals("boolean") ? "get" : "is") + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }

    @Override
    public Set<ClassData> getReferencedTypes(ClassData rootClassData, Set<ClassData> usedTypes) {
        HashSet<ClassData> result = new HashSet<ClassData>();
        result.add(rootClassData);
        usedTypes.add(rootClassData);
        ClassData parent = rootClassData.getParent();
        if (parent != null && parent.getSerializer() != null && !usedTypes.contains(parent)) {
            usedTypes.addAll(parent.getSerializer().getReferencedTypes(parent, usedTypes));
        }
        for (FieldData fieldCD : rootClassData.getFields()) {
            ClassData cd = fieldCD.getType();
            if (usedTypes.contains(cd)) continue;
            result.addAll(cd.getSerializer().getReferencedTypes(cd, usedTypes));
            usedTypes.add(cd);
        }
        return result;
    }
}

