/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.ant.tasks;

import com.sun.javacard.ant.tasks.JavacardTaskBase;
import java.lang.reflect.Method;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class PackagerTask
extends JavacardTaskBase {
    private String classname = "com.sun.javacard.packager.Main";
    private CommandlineJava cmdj = this.getCommandLine();
    protected String command;
    protected String jarFile;
    protected String moduleFolderOrFile;
    protected String applicationType;
    protected String keystoreFile;
    protected String keystorePW;
    protected String privatekeyPW;
    protected String sign;
    protected String forced;
    protected String alias;
    protected Path classpath;
    protected String verbose;
    protected String subCommand;

    public void setCommand(String command) {
        this.command = command;
    }

    public void setSubCommand(String subCommand) {
        this.subCommand = subCommand;
    }

    public void setModuleFolderOrFile(String moduleFolderOrFile) {
        if (moduleFolderOrFile.startsWith(".")) {
            String basedir = this.getProject().getBaseDir().getAbsolutePath();
            this.moduleFolderOrFile = basedir + moduleFolderOrFile.substring(1);
        } else {
            this.moduleFolderOrFile = moduleFolderOrFile;
        }
    }

    public void setAppType(String applicationType) {
        this.applicationType = applicationType;
    }

    public void setOutputJarFile(String jarFile) {
        if (jarFile.startsWith(".")) {
            String basedir = this.getProject().getBaseDir().getAbsolutePath();
            this.jarFile = basedir + jarFile.substring(1);
        } else {
            this.jarFile = jarFile;
        }
    }

    public void setKeystoreFile(String keystoreFile) {
        if (keystoreFile.startsWith(".")) {
            String basedir = this.getProject().getBaseDir().getAbsolutePath();
            this.keystoreFile = basedir + keystoreFile.substring(1);
        } else {
            this.keystoreFile = keystoreFile;
        }
    }

    public void setKeystorePass(String keystorePW) {
        this.keystorePW = keystorePW;
    }

    public void setPrivateKeyPass(String privatekeyPW) {
        this.privatekeyPW = privatekeyPW;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setForced(String forced) {
        this.forced = forced;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    protected void doIt(String command) throws BuildException {
        this.cmdj.clearJavaArgs();
        this.cmdj.createArgument().setValue(command);
        if (command.equalsIgnoreCase("create")) {
            if (this.moduleFolderOrFile == null) {
                throw new BuildException(messages.getString("packager.noModuleFolderOrFile"));
            }
            if (this.applicationType != null) {
                this.cmdj.createArgument().setValue("--type");
                this.cmdj.createArgument().setValue(this.applicationType);
            }
            this.cmdj.createArgument().setValue(this.moduleFolderOrFile);
            if (this.jarFile == null) {
                throw new BuildException(messages.getString("packager.noOutputJarFile"));
            }
            this.cmdj.createArgument().setValue("--out");
            this.cmdj.createArgument().setValue(this.jarFile);
            if (this.sign != null || this.sign.equalsIgnoreCase("yes")) {
                this.cmdj.createArgument().setValue("--sign");
                if (this.keystoreFile == null) {
                    throw new BuildException(messages.getString("packager.noKeystoreFile"));
                }
                if (this.keystorePW == null) {
                    throw new BuildException(messages.getString("packager.noKeystorePassword"));
                }
                if (this.privatekeyPW == null) {
                    throw new BuildException(messages.getString("packager.noPrivatekeyPassword"));
                }
                this.cmdj.createArgument().setValue("-K");
                this.cmdj.createArgument().setValue(this.keystoreFile);
                this.cmdj.createArgument().setValue("-P");
                this.cmdj.createArgument().setValue(this.keystorePW);
                this.cmdj.createArgument().setValue("-S");
                this.cmdj.createArgument().setValue(this.privatekeyPW);
                if (this.alias == null) {
                    throw new BuildException(messages.getString("packager.noAlias"));
                }
                this.cmdj.createArgument().setValue("-A");
                this.cmdj.createArgument().setValue(this.alias);
            }
            if (this.forced != null && this.forced.equalsIgnoreCase("yes")) {
                this.cmdj.createArgument().setValue("--force");
            }
        }
        if (command.equalsIgnoreCase("validate")) {
            if (this.moduleFolderOrFile == null) {
                throw new BuildException(messages.getString("packager.noModuleFolderOrFile"));
            }
            if (this.applicationType != null) {
                this.cmdj.createArgument().setValue("--type");
                this.cmdj.createArgument().setValue(this.applicationType);
            }
            this.cmdj.createArgument().setValue(this.moduleFolderOrFile);
        }
        if (command.equalsIgnoreCase("help") && this.subCommand != null) {
            this.cmdj.createArgument().setValue(this.subCommand);
        }
        if (this.verbose != null && this.verbose.equalsIgnoreCase("yes")) {
            this.cmdj.createArgument().setValue("-v");
        }
        String[] args = this.cmdj.getJavaCommand().getArguments();
        Object[] arguments = new Object[]{args};
        AntClassLoader loader = this.getProject().createClassLoader(this.classpath);
        loader.setParent(this.getProject().getCoreLoader());
        loader.setParentFirst(true);
        loader.addJavaLibraries();
        loader.setIsolated(true);
        loader.setThreadContextLoader();
        Class<?> target = null;
        try {
            loader.forceLoadClass(this.classname);
            target = Class.forName(this.classname, true, (ClassLoader)loader);
        }
        catch (Exception e) {
            throw new BuildException(messages.getString("packager.loadPackagerError"));
        }
        Method execute = null;
        try {
            execute = target.getMethod("execute", String[].class);
        }
        catch (Exception e) {
            throw new BuildException(messages.getString("packager.noExecuteMethod"));
        }
        try {
            execute.invoke(null, arguments);
        }
        catch (Exception e) {
            throw new BuildException(messages.getString("packager.packagerError"));
        }
    }

    public void execute() throws BuildException {
        if (this.command == null) {
            throw new BuildException(messages.getString("packager.noCommand"));
        }
        this.classpath = this.cmdj.getClasspath();
        if (this.classpath == null) {
            throw new BuildException(messages.getString("packager.noClassPath"));
        }
        this.doIt(this.command);
    }
}

