/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.netbeans.modules.php.editor.api.AliasedName;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.TypeNameResolver;
import org.netbeans.modules.php.editor.elements.Bundle;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.UseScope;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;

public abstract class TypeNameResolverImpl
implements TypeNameResolver {
    public static TypeNameResolver forNull() {
        return new TypeNameResolver(){

            @Override
            public QualifiedName resolve(QualifiedName qualifiedName) {
                return qualifiedName;
            }
        };
    }

    public static TypeNameResolver forChainOf(final List<TypeNameResolver> typeNameResolvers) {
        return new TypeNameResolver(){

            @Override
            public QualifiedName resolve(QualifiedName qualifiedName) {
                QualifiedName result = qualifiedName;
                for (TypeNameResolver nameResolver : typeNameResolvers) {
                    result = nameResolver.resolve(result);
                }
                return result;
            }
        };
    }

    public static TypeNameResolver forFullyQualifiedName(Scope scope, int offset) {
        return new FullyQualifiedTypeNameResolver(scope, offset);
    }

    public static TypeNameResolver forQualifiedName(Scope scope, int offset) {
        return new CommonQualifiedTypeNameResolver(scope, offset);
    }

    public static TypeNameResolver forUnqualifiedName() {
        return new TypeNameResolver(){

            @Override
            public QualifiedName resolve(QualifiedName qualifiedName) {
                return qualifiedName.toName();
            }
        };
    }

    public static TypeNameResolver forSmartName(Scope scope, int offset) {
        return new SmartQualifiedTypeNameResolver(scope, offset);
    }

    private static class FullyQualifiedNameProcessor {
        private final int offset;
        private final QualifiedTypeNameResolver qualifiedTypeNameResolver;

        public static int countSkipLength(UseScope matchedUseElement) {
            List<String> segments;
            int result = "\\".length();
            if (matchedUseElement != null && !(segments = FullyQualifiedNameProcessor.createSegments(matchedUseElement)).isEmpty()) {
                result += QualifiedName.create(true, segments).toString().length();
            }
            return result;
        }

        private static List<String> createSegments(UseScope matchedUseElement) {
            ArrayList<String> segments = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(matchedUseElement.getName(), "\\");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                segments.add(token);
            }
            return Collections.unmodifiableList(segments);
        }

        private static boolean isFromCurrentNamespace(QualifiedName fullyQualifiedName, QualifiedName namespaceName) {
            return fullyQualifiedName.toString().substring("\\".length()).startsWith(namespaceName.toString() + "\\");
        }

        public FullyQualifiedNameProcessor(QualifiedTypeNameResolver qualifiedTypeNameResolver, int offset) {
            this.qualifiedTypeNameResolver = qualifiedTypeNameResolver;
            this.offset = offset;
        }

        public QualifiedName process(QualifiedName fullyQualifiedName, NamespaceScope namespaceScope) {
            QualifiedName result = fullyQualifiedName;
            if (namespaceScope != null) {
                QualifiedName namespaceName = namespaceScope.getNamespaceName();
                result = FullyQualifiedNameProcessor.isFromCurrentNamespace(fullyQualifiedName, namespaceName) ? this.resolveFromCurrentNamespace(fullyQualifiedName, namespaceName) : this.resolveFromAnotherNamespace(fullyQualifiedName, namespaceScope.getDeclaredUses());
            }
            return result;
        }

        private QualifiedName resolveFromCurrentNamespace(QualifiedName fullyQualifiedName, QualifiedName namespaceName) {
            int namespaceNameSegmentsSize = namespaceName.getSegments().size();
            int qualifiedNameSegmentsSize = fullyQualifiedName.getSegments().size();
            assert (namespaceNameSegmentsSize < qualifiedNameSegmentsSize) : namespaceName.toString() + ":" + namespaceNameSegmentsSize + " < " + fullyQualifiedName.toString() + ":" + qualifiedNameSegmentsSize;
            String resultName = fullyQualifiedName.toString().substring("\\".length() + namespaceName.toString().length() + "\\".length());
            return QualifiedName.create(resultName);
        }

        private QualifiedName resolveFromAnotherNamespace(QualifiedName fullyQualifiedName, Collection<? extends UseScope> declaredUses) {
            UseScope matchedUseScope = this.getMatchedUseScopeForFullyQualifiedName(fullyQualifiedName, declaredUses);
            return this.qualifiedTypeNameResolver.resolveForUseScope(fullyQualifiedName, matchedUseScope);
        }

        private UseScope getMatchedUseScopeForFullyQualifiedName(QualifiedName fullyQualifiedName, Collection<? extends UseScope> declaredUses) {
            UseScope result = null;
            String firstSegmentName = fullyQualifiedName.getSegments().getFirst();
            int lastOffset = -1;
            for (UseScope useScope : declaredUses) {
                String modifiedUseElementName;
                if (useScope.getOffset() >= this.offset) continue;
                AliasedName aliasName = useScope.getAliasedName();
                if (aliasName != null) {
                    if (!firstSegmentName.equals(aliasName.getAliasName())) continue;
                    result = useScope;
                    continue;
                }
                if (lastOffset >= useScope.getOffset()) continue;
                String useElementName = useScope.getName();
                String string = modifiedUseElementName = useElementName.startsWith("\\") ? useElementName : "\\" + useElementName;
                if (!fullyQualifiedName.toString().startsWith(modifiedUseElementName)) continue;
                lastOffset = useScope.getOffset();
                result = useScope;
            }
            return result;
        }
    }

    private static class SmartQualifiedTypeNameResolver
    extends BaseTypeNameResolver
    implements QualifiedTypeNameResolver {
        public SmartQualifiedTypeNameResolver(Scope scope, int offset) {
            super(scope, offset);
        }

        @Override
        public QualifiedName resolveForUseScope(QualifiedName fullyQualifiedName, UseScope matchedUseScope) {
            QualifiedName result = fullyQualifiedName;
            if (matchedUseScope != null) {
                int skipLength = FullyQualifiedNameProcessor.countSkipLength(matchedUseScope);
                result = QualifiedName.create(fullyQualifiedName.toString().substring(skipLength));
            }
            return result;
        }

        @Override
        protected QualifiedName processFullyQualifiedName(QualifiedName fullyQualifiedName, NamespaceScope namespaceScope) {
            return new FullyQualifiedNameProcessor(this, this.getOffset()).process(fullyQualifiedName, namespaceScope);
        }

        @Override
        protected QualifiedName processQualifiedName(QualifiedName fullyQualifiedName, NamespaceScope namespaceScope) {
            throw new IllegalArgumentException(Bundle.IllegalArgument(this.getClass().getName()));
        }

        @Override
        protected QualifiedName processUnQualifiedName(QualifiedName fullyQualifiedName, NamespaceScope namespaceScope) {
            throw new IllegalArgumentException(Bundle.IllegalArgument(this.getClass().getName()));
        }
    }

    private static class CommonQualifiedTypeNameResolver
    extends BaseTypeNameResolver
    implements QualifiedTypeNameResolver {
        public CommonQualifiedTypeNameResolver(Scope scope, int offset) {
            super(scope, offset);
        }

        @Override
        protected QualifiedName processFullyQualifiedName(QualifiedName fullyQualifiedName, NamespaceScope namespaceScope) {
            return new FullyQualifiedNameProcessor(this, this.getOffset()).process(fullyQualifiedName, namespaceScope);
        }

        @Override
        protected QualifiedName processQualifiedName(QualifiedName qualifiedName, NamespaceScope namespaceScope) {
            return this.resolveNonFullyQualifiedName(qualifiedName, namespaceScope);
        }

        @Override
        protected QualifiedName processUnQualifiedName(QualifiedName unQualifiedName, NamespaceScope namespaceScope) {
            return this.resolveNonFullyQualifiedName(unQualifiedName, namespaceScope);
        }

        @Override
        public QualifiedName resolveForUseScope(QualifiedName fullyQualifiedName, UseScope matchedUseScope) {
            int skipLength = FullyQualifiedNameProcessor.countSkipLength(matchedUseScope);
            return QualifiedName.create(fullyQualifiedName.toString().substring(skipLength));
        }

        private QualifiedName resolveNonFullyQualifiedName(QualifiedName nonFullyQualifiedName, NamespaceScope namespaceScope) {
            QualifiedName result = nonFullyQualifiedName;
            UseScope matchedUseScope = this.getMatchedUseScopeForNonFullyQualifiedName(nonFullyQualifiedName, namespaceScope);
            if (matchedUseScope == null) {
                result = namespaceScope.getNamespaceName().append(nonFullyQualifiedName);
            }
            return result;
        }

        private UseScope getMatchedUseScopeForNonFullyQualifiedName(QualifiedName nonFullyQualifiedName, NamespaceScope namespaceScope) {
            UseScope result = null;
            String firstSegmentName = nonFullyQualifiedName.getSegments().getFirst();
            int lastOffset = -1;
            for (UseScope useScope : namespaceScope.getDeclaredUses()) {
                if (useScope.getOffset() >= this.getOffset()) continue;
                AliasedName aliasName = useScope.getAliasedName();
                if (aliasName != null) {
                    if (!firstSegmentName.equals(aliasName.getAliasName())) continue;
                    result = useScope;
                    continue;
                }
                if (lastOffset >= useScope.getOffset() || !useScope.getName().endsWith(firstSegmentName)) continue;
                result = useScope;
                lastOffset = useScope.getOffset();
            }
            return result;
        }
    }

    private static interface QualifiedTypeNameResolver {
        public QualifiedName resolveForUseScope(QualifiedName var1, UseScope var2);
    }

    private static class FullyQualifiedTypeNameResolver
    extends BaseTypeNameResolver {
        public FullyQualifiedTypeNameResolver(Scope scope, int offset) {
            super(scope, offset);
        }

        @Override
        protected QualifiedName processFullyQualifiedName(QualifiedName fullyQualifiedName, NamespaceScope namespaceScope) {
            return fullyQualifiedName;
        }

        @Override
        protected QualifiedName processQualifiedName(QualifiedName qualifiedName, NamespaceScope namespaceScope) {
            return this.resolveFullyQualifiedName(qualifiedName, namespaceScope);
        }

        @Override
        protected QualifiedName processUnQualifiedName(QualifiedName unQualifiedName, NamespaceScope namespaceScope) {
            return this.resolveFullyQualifiedName(unQualifiedName, namespaceScope);
        }

        private QualifiedName resolveFullyQualifiedName(QualifiedName qualifiedName, NamespaceScope namespaceScope) {
            QualifiedName result = qualifiedName;
            String firstSegmentName = qualifiedName.getSegments().getFirst();
            UseScope matchedUseScope = null;
            int lastOffset = -1;
            for (UseScope useScope : namespaceScope.getDeclaredUses()) {
                if (useScope.getNameRange().containsInclusive(this.getOffset())) {
                    result = QualifiedName.create(true, qualifiedName.getSegments());
                    break;
                }
                if (useScope.getOffset() >= this.getOffset()) continue;
                AliasedName aliasName = useScope.getAliasedName();
                if (aliasName != null) {
                    if (!firstSegmentName.equals(aliasName.getAliasName())) continue;
                    matchedUseScope = useScope;
                    continue;
                }
                if (lastOffset >= useScope.getOffset() || !useScope.getName().equals(firstSegmentName) && !useScope.getName().endsWith("\\" + firstSegmentName)) continue;
                matchedUseScope = useScope;
                lastOffset = useScope.getOffset();
            }
            if (matchedUseScope != null) {
                result = this.resolveForMatchedUseScope(result, matchedUseScope);
            } else if (!result.getKind().isFullyQualified()) {
                String fullNamespaceName = namespaceScope.getNamespaceName().toString();
                if (result.getKind().isQualified()) {
                    fullNamespaceName = fullNamespaceName + (fullNamespaceName.trim().isEmpty() ? "" : "\\");
                    fullNamespaceName = fullNamespaceName + result.getNamespaceName();
                }
                result = QualifiedName.createFullyQualified(result.getName(), fullNamespaceName);
            }
            return result;
        }

        private QualifiedName resolveForMatchedUseScope(QualifiedName qualifiedName, UseScope matchedUseScope) {
            QualifiedName result = qualifiedName;
            ArrayList<String> segments = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(matchedUseScope.getName(), "\\");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                segments.add(token);
            }
            LinkedList<String> origName = result.getSegments();
            for (int i = 1; i < origName.size(); ++i) {
                segments.add((String)origName.get(i));
            }
            return QualifiedName.create(true, segments);
        }
    }

    private static abstract class BaseTypeNameResolver
    extends TypeNameResolverImpl {
        private final Scope scope;
        private final int offset;

        public BaseTypeNameResolver(Scope scope, int offset) {
            this.scope = scope;
            this.offset = offset;
        }

        protected abstract QualifiedName processFullyQualifiedName(QualifiedName var1, NamespaceScope var2);

        protected abstract QualifiedName processQualifiedName(QualifiedName var1, NamespaceScope var2);

        protected abstract QualifiedName processUnQualifiedName(QualifiedName var1, NamespaceScope var2);

        @Override
        public QualifiedName resolve(QualifiedName qualifiedName) {
            QualifiedName result = qualifiedName;
            if (!VariousUtils.isSpecialClassName(qualifiedName.getName()) && !Type.isPrimitive(qualifiedName.toString())) {
                result = this.processExactType(qualifiedName);
            }
            return result;
        }

        protected int getOffset() {
            return this.offset;
        }

        private QualifiedName processExactType(QualifiedName qualifiedName) {
            QualifiedName result = qualifiedName;
            NamespaceScope namespaceScope = this.retrieveNamespaceScope();
            if (namespaceScope != null) {
                result = qualifiedName.getKind().isFullyQualified() ? this.processFullyQualifiedName(qualifiedName, namespaceScope) : (qualifiedName.getKind().isQualified() ? this.processQualifiedName(qualifiedName, namespaceScope) : this.processUnQualifiedName(qualifiedName, namespaceScope));
            }
            return result;
        }

        private NamespaceScope retrieveNamespaceScope() {
            Scope inScope;
            NamespaceScope result = null;
            for (inScope = this.scope; inScope != null && !(inScope instanceof NamespaceScope); inScope = inScope.getInScope()) {
            }
            if (inScope != null) {
                result = (NamespaceScope)inScope;
            }
            return result;
        }
    }
}

