/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.BaseFunctionElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.ParameterElement;
import org.netbeans.modules.php.editor.elements.ParameterElementImpl;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.FunctionScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableName;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariableNameFactory;
import org.netbeans.modules.php.editor.model.impl.VariableNameImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.FunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.LambdaFunctionDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MagicMethodDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.MethodDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;

class FunctionScopeImpl
extends ScopeImpl
implements FunctionScope,
VariableNameFactory {
    private static final String TYPE_SEPARATOR = "|";
    private static final String TYPE_SEPARATOR_REGEXP = "\\|";
    private List<? extends ParameterElement> paremeters;
    private String returnType;
    private static Set<String> recursionDetection = new HashSet<String>();

    FunctionScopeImpl(Scope inScope, FunctionDeclarationInfo info, String returnType, boolean isDeprecated) {
        super(inScope, info, PhpModifiers.fromBitMask(1), ((FunctionDeclaration)info.getOriginalNode()).getBody(), isDeprecated);
        this.paremeters = info.getParameters();
        this.returnType = returnType;
    }

    FunctionScopeImpl(Scope inScope, LambdaFunctionDeclarationInfo info) {
        super(inScope, info, PhpModifiers.fromBitMask(1), ((LambdaFunctionDeclaration)info.getOriginalNode()).getBody(), inScope.isDeprecated());
        this.paremeters = info.getParameters();
    }

    protected FunctionScopeImpl(Scope inScope, MethodDeclarationInfo info, String returnType, boolean isDeprecated) {
        super(inScope, info, info.getAccessModifiers(), ((MethodDeclaration)info.getOriginalNode()).getFunction().getBody(), isDeprecated);
        this.paremeters = info.getParameters();
        this.returnType = returnType;
    }

    protected FunctionScopeImpl(Scope inScope, MagicMethodDeclarationInfo info, String returnType, boolean isDeprecated) {
        super(inScope, info, info.getAccessModifiers(), null, isDeprecated);
        this.paremeters = info.getParameters();
        this.returnType = returnType;
    }

    FunctionScopeImpl(Scope inScope, BaseFunctionElement indexedFunction) {
        this(inScope, indexedFunction, PhpElementKind.FUNCTION);
    }

    protected FunctionScopeImpl(Scope inScope, BaseFunctionElement element, PhpElementKind kind) {
        super(inScope, element, kind);
        this.paremeters = element.getParameters();
        this.returnType = element.asString(BaseFunctionElement.PrintAs.ReturnSemiTypes);
    }

    public static FunctionScopeImpl createElement(Scope scope, LambdaFunctionDeclaration node) {
        return new FunctionScopeImpl(scope, LambdaFunctionDeclarationInfo.create(node)){

            @Override
            public boolean isAnonymous() {
                return true;
            }
        };
    }

    public synchronized void addReturnType(String type) {
        if (!StringUtils.hasText((String)this.returnType)) {
            this.returnType = type;
        } else {
            HashSet<String> distinctTypes = new HashSet<String>();
            distinctTypes.addAll(Arrays.asList(this.returnType.split(TYPE_SEPARATOR_REGEXP)));
            distinctTypes.add(type);
            this.returnType = StringUtils.implode(distinctTypes, (String)TYPE_SEPARATOR);
        }
    }

    protected synchronized String getReturnType() {
        return this.returnType;
    }

    @Override
    public Collection<? extends TypeScope> getReturnTypes() {
        return this.getReturnTypesDescriptor(this.getReturnType(), false).getModifiedResult(Collections.emptyList());
    }

    @Override
    public synchronized Collection<? extends String> getReturnTypeNames() {
        List retval = Collections.emptyList();
        String type = this.getReturnType();
        if (type != null && type.length() > 0) {
            retval = new ArrayList();
            for (String typeName : type.split(TYPE_SEPARATOR_REGEXP)) {
                if (VariousUtils.isSemiType(typeName)) continue;
                retval.add(typeName);
            }
        }
        return retval;
    }

    @Override
    public Collection<? extends TypeScope> getReturnTypes(boolean resolveSemiTypes, Collection<? extends TypeScope> callerTypes) {
        assert (callerTypes != null);
        String types = this.getReturnType();
        Collection<? extends TypeScope> result = this.getReturnTypesDescriptor(types, resolveSemiTypes).getModifiedResult(callerTypes);
        this.updateReturnTypes(types, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReturnTypesDescriptor getReturnTypesDescriptor(String types, boolean resolveSemiTypes) {
        ReturnTypesDescriptor result = ReturnTypesDescriptor.NONE;
        if (StringUtils.hasText((String)types)) {
            String[] typeNames = types.split(TYPE_SEPARATOR_REGEXP);
            if (FunctionScopeImpl.containsCallerDependentType(typeNames)) {
                result = new CallerDependentTypesDescriptor();
            } else if (this.getInScope() instanceof ClassScope && FunctionScopeImpl.containsSelfDependentType(typeNames)) {
                result = new CommonTypesDescriptor(Collections.singleton((TypeScope)this.getInScope()));
            } else {
                HashSet<TypeScope> retval = new HashSet<TypeScope>();
                for (String typeName : typeNames) {
                    if (typeName.trim().length() <= 0) continue;
                    boolean added = false;
                    try {
                        added = recursionDetection.add(typeName);
                        if (!added || recursionDetection.size() >= 15) continue;
                        if (resolveSemiTypes && VariousUtils.isSemiType(typeName)) {
                            retval.addAll(VariousUtils.getType(this, typeName, this.getLastValidMethodOffset(), false));
                            continue;
                        }
                        String modifiedTypeName = typeName;
                        if (typeName.indexOf("[") != -1) {
                            modifiedTypeName = typeName.replaceAll("\\[.*\\]", "");
                        }
                        retval.addAll(IndexScopeImpl.getTypes(QualifiedName.create(modifiedTypeName), this));
                    }
                    finally {
                        if (added) {
                            recursionDetection.remove(typeName);
                        }
                    }
                }
                result = new CommonTypesDescriptor(retval);
            }
        }
        return result;
    }

    private int getLastValidMethodOffset() {
        int result = this.getOffset();
        List<? extends ModelElement> elements = ModelUtils.getElements(this, true);
        if (elements != null && !elements.isEmpty()) {
            Collections.sort(elements, new ModelElementsPositionComparator());
            result = elements.get(0).getNameRange().getEnd();
        }
        return result;
    }

    private static boolean containsCallerDependentType(String[] typeNames) {
        return Arrays.binarySearch(typeNames, "\\this") >= 0 || Arrays.binarySearch(typeNames, "\\static") >= 0;
    }

    private static boolean containsSelfDependentType(String[] typeNames) {
        return Arrays.binarySearch(typeNames, "\\self") >= 0 || Arrays.binarySearch(typeNames, "object") >= 0;
    }

    private void updateReturnTypes(String oldTypes, Collection<? extends TypeScope> resolvedReturnTypes) {
        if (VariousUtils.isSemiType(oldTypes)) {
            this.updateSemiReturnTypes(oldTypes, resolvedReturnTypes);
        }
    }

    private void updateSemiReturnTypes(String oldTypes, Collection<? extends TypeScope> resolvedReturnTypes) {
        StringBuilder sb = new StringBuilder();
        for (TypeScope typeScope : resolvedReturnTypes) {
            if (sb.length() != 0) {
                sb.append(TYPE_SEPARATOR);
            }
            sb.append(typeScope.getNamespaceName().append(typeScope.getName()).toString());
        }
        this.updateReturnTypesIfNotChanged(oldTypes, sb.toString());
    }

    private synchronized void updateReturnTypesIfNotChanged(String oldTypes, String newTypes) {
        if (oldTypes.equals(this.getReturnType()) && StringUtils.hasText((String)newTypes)) {
            this.returnType = newTypes;
        }
    }

    @Override
    @NonNull
    public List<? extends String> getParameterNames() {
        assert (this.paremeters != null);
        ArrayList<String> parameterNames = new ArrayList<String>();
        for (ParameterElement parameterElement : this.paremeters) {
            parameterNames.add(parameterElement.getName());
        }
        return parameterNames;
    }

    @Override
    @NonNull
    public List<? extends ParameterElement> getParameters() {
        return this.paremeters;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var4_6;
        StringBuilder sb = new StringBuilder();
        Collection<? extends TypeScope> returnTypes = this.getReturnTypes();
        sb.append('[');
        for (TypeScope typeScope : returnTypes) {
            if (sb.length() == 1) {
                sb.append(TYPE_SEPARATOR);
            }
            sb.append(typeScope.getName());
        }
        sb.append("] ");
        sb.append(super.toString()).append("(");
        List<? extends String> parameters = this.getParameterNames();
        boolean bl = false;
        while (var4_6 < parameters.size()) {
            String param = parameters.get((int)var4_6);
            if (var4_6 > 0) {
                sb.append(",");
            }
            sb.append(param);
            ++var4_6;
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public Collection<? extends VariableName> getDeclaredVariables() {
        return FunctionScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.VARIABLE);
            }
        });
    }

    @Override
    public VariableNameImpl createElement(Variable node) {
        VariableNameImpl retval = new VariableNameImpl((Scope)this, node, false);
        this.addElement(retval);
        return retval;
    }

    @Override
    public void addSelfToIndex(IndexDocument indexDocument) {
        indexDocument.addPair("base", this.getIndexSignature(), true, true);
        indexDocument.addPair("top", this.getName().toLowerCase(), true, true);
    }

    private String getIndexSignature() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName().toLowerCase()).append(';');
        sb.append(this.getName()).append(';');
        sb.append(this.getOffset()).append(';');
        List<? extends ParameterElement> parameters = this.getParameters();
        for (int idx = 0; idx < parameters.size(); ++idx) {
            ParameterElementImpl parameter = (ParameterElementImpl)parameters.get(idx);
            if (idx > 0) {
                sb.append(',');
            }
            sb.append(parameter.getSignature());
        }
        sb.append(';');
        String type = this.getReturnType();
        if (type != null && !"mixed".equalsIgnoreCase(type)) {
            sb.append(type);
        }
        sb.append(';');
        NamespaceScope namespaceScope = ModelUtils.getNamespaceScope(this);
        assert (namespaceScope != null);
        QualifiedName qualifiedName = namespaceScope.getQualifiedName();
        sb.append(qualifiedName.toString()).append(';');
        sb.append(this.isDeprecated() ? 1 : 0).append(';');
        sb.append(this.getFilenameUrl()).append(';');
        return sb.toString();
    }

    @Override
    public QualifiedName getNamespaceName() {
        if (this.indexedElement instanceof FunctionElement) {
            FunctionElement indexedFunction = (FunctionElement)this.indexedElement;
            return indexedFunction.getNamespaceName();
        }
        return super.getNamespaceName();
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    private static final class CallerDependentTypesDescriptor
    implements ReturnTypesDescriptor {
        private CallerDependentTypesDescriptor() {
        }

        @Override
        public Collection<? extends TypeScope> getModifiedResult(Collection<? extends TypeScope> callerTypes) {
            assert (callerTypes != null);
            return callerTypes;
        }
    }

    private static final class CommonTypesDescriptor
    implements ReturnTypesDescriptor {
        private final Collection<? extends TypeScope> rawTypes;

        public CommonTypesDescriptor(Collection<? extends TypeScope> rawTypes) {
            assert (rawTypes != null);
            this.rawTypes = rawTypes;
        }

        @Override
        public Collection<? extends TypeScope> getModifiedResult(Collection<? extends TypeScope> callerTypes) {
            assert (callerTypes != null);
            return this.rawTypes;
        }
    }

    private static interface ReturnTypesDescriptor {
        public static final ReturnTypesDescriptor NONE = new ReturnTypesDescriptor(){

            @Override
            public Collection<? extends TypeScope> getModifiedResult(Collection<? extends TypeScope> callerTypes) {
                return Collections.emptyList();
            }
        };

        public Collection<? extends TypeScope> getModifiedResult(Collection<? extends TypeScope> var1);
    }

    @SuppressWarnings(value={"SE_COMPARATOR_SHOULD_BE_SERIALIZABLE"})
    private static final class ModelElementsPositionComparator
    implements Comparator<ModelElement> {
        private ModelElementsPositionComparator() {
        }

        @Override
        public int compare(ModelElement o1, ModelElement o2) {
            int o2End;
            int o1End = o1.getNameRange().getEnd();
            if (o1End < (o2End = o2.getNameRange().getEnd())) {
                return 1;
            }
            if (o1End > o2End) {
                return -1;
            }
            return 0;
        }
    }
}

