/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class FunctionDeclaration
extends Statement {
    private boolean isReference;
    private Identifier name;
    private final ArrayList<FormalParameter> formalParameters = new ArrayList();
    private Block body;

    private FunctionDeclaration(int start, int end, Identifier functionName, FormalParameter[] formalParameters, Block body, boolean isReference) {
        super(start, end);
        this.isReference = isReference;
        this.name = functionName;
        this.formalParameters.addAll(Arrays.asList(formalParameters));
        this.body = body;
    }

    public FunctionDeclaration(int start, int end, Identifier functionName, List<FormalParameter> formalParameters, Block body, boolean isReference) {
        this(start, end, functionName, formalParameters.toArray(new FormalParameter[formalParameters.size()]), body, isReference);
    }

    public Block getBody() {
        return this.body;
    }

    public List<FormalParameter> getFormalParameters() {
        return this.formalParameters;
    }

    public Identifier getFunctionName() {
        return this.name;
    }

    public boolean isReference() {
        return this.isReference;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (FormalParameter formalParameter : this.getFormalParameters()) {
            sb.append(formalParameter).append(",");
        }
        return "function " + (this.isReference() ? "&" : "") + this.getFunctionName() + "(" + sb.toString() + ")" + this.getBody();
    }
}

