/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.QualifiedNameKind;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.GotoLabel;
import org.netbeans.modules.php.editor.parser.astnodes.GotoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.UseStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public class PHP53UnhandledError
extends UnhandledErrorRule {
    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && this.appliesTo(fileObject)) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            errors.addAll(checkVisitor.getErrors());
        }
    }

    private boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhp52(fileObject);
    }

    public String getDisplayName() {
        return Bundle.PHP53VersionErrorHintDispName();
    }

    private static class PhpVersionError
    extends VerificationError {
        private static final String ERROR_KEY = "Php.Version.53";

        public PhpVersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.PhpVersionErrorDisp();
        }

        public String getDescription() {
            return Bundle.PhpVersionErrorDesc();
        }

        public String getKey() {
            return ERROR_KEY;
        }
    }

    private static class CheckVisitor
    extends DefaultVisitor {
        private final List<Error> errors = new ArrayList<Error>();
        private final Stack<ASTNode> parent = new Stack();
        private final FileObject fileObject;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public List<Error> getErrors() {
            return this.errors;
        }

        @Override
        public void visit(ClassDeclaration node) {
            this.parent.push(node);
            super.visit(node);
            this.parent.pop();
        }

        @Override
        public void visit(InterfaceDeclaration node) {
            this.parent.push(node);
            super.visit(node);
            this.parent.pop();
        }

        @Override
        public void visit(NamespaceDeclaration node) {
            NamespaceName name = node.getName();
            if (name != null) {
                this.createError(node.getStartOffset(), name.getEndOffset());
            } else {
                this.createError(node);
            }
            super.visit(node);
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            this.createError(node);
            super.visit(node);
        }

        @Override
        public void visit(GotoLabel node) {
            this.createError(node);
            super.visit(node);
        }

        @Override
        public void visit(ConstantDeclaration node) {
            if (!this.parent.empty() && this.parent.peek() instanceof TypeDeclaration) {
                return;
            }
            this.createError(node);
            super.visit(node);
        }

        @Override
        public void visit(GotoStatement node) {
            this.createError(node);
            super.visit(node);
        }

        @Override
        public void visit(UseStatement node) {
            this.createError(node);
            super.visit(node);
        }

        @Override
        public void visit(StaticMethodInvocation node) {
            if (node.getClassName() instanceof Variable) {
                this.createError(node.getClassName());
            }
            super.visit(node);
        }

        @Override
        public void visit(NamespaceName node) {
            QualifiedName qname = QualifiedName.create(node);
            if (qname.getKind() != QualifiedNameKind.UNQUALIFIED) {
                this.createError(node);
            }
            super.visit(node);
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add((Error)new PhpVersionError(this.fileObject, startOffset, endOffset));
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }
    }
}

