/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintErrorRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class TypeRedeclarationHintError
extends HintErrorRule {
    private Set<Statement> conditionStatements = Collections.emptySet();
    private FileObject fileObject;
    private List<Hint> hints;
    private Set<String> typeNames;
    private Collection<? extends TypeScope> declaredTypes;

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileScope fileScope = context.fileScope;
        this.fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileScope != null && this.fileObject != null) {
            this.hints = hints;
            CheckVisitor checkVisitor = new CheckVisitor();
            phpParseResult.getProgram().accept(checkVisitor);
            this.conditionStatements = checkVisitor.getConditionStatements();
            this.declaredTypes = ModelUtils.getDeclaredTypes(fileScope);
            this.typeNames = new HashSet<String>();
            for (TypeScope typeScope : this.declaredTypes) {
                if (this.isInConditionStatament(typeScope)) continue;
                this.checkDeclaredTypeScope(typeScope);
            }
        }
    }

    private boolean isInConditionStatament(TypeScope typeScope) {
        boolean result = false;
        for (Statement statement : this.conditionStatements) {
            OffsetRange statementOffsetRange = new OffsetRange(statement.getStartOffset(), statement.getEndOffset());
            if (!statementOffsetRange.containsInclusive(typeScope.getOffset())) continue;
            result = true;
            break;
        }
        return result;
    }

    private void checkDeclaredTypeScope(TypeScope typeScope) {
        QualifiedName qualifiedName = typeScope.getNamespaceName().append(typeScope.getName()).toFullyQualified();
        String name = qualifiedName.toString();
        if (!this.typeNames.contains(name)) {
            this.typeNames.add(name);
            List<? extends TypeScope> instances = ModelUtils.filter(this.declaredTypes, qualifiedName);
            if (instances.size() > 1) {
                TypeScope firstDeclaredInstance = null;
                for (TypeScope typeScope2 : instances) {
                    if (firstDeclaredInstance == null) {
                        firstDeclaredInstance = typeScope2;
                        continue;
                    }
                    if (firstDeclaredInstance.getOffset() <= typeScope2.getOffset()) continue;
                    firstDeclaredInstance = typeScope2;
                }
                for (TypeScope typeScope3 : instances) {
                    if (typeScope3 == firstDeclaredInstance) continue;
                    assert (firstDeclaredInstance != null);
                    this.hints.add(new Hint((Rule)this, Bundle.TypeRedeclarationDesc(firstDeclaredInstance.getName()), this.fileObject, typeScope3.getNameRange(), Collections.emptyList(), 500));
                }
            }
        }
    }

    public String getDisplayName() {
        return Bundle.TypeRedeclarationRuleDispName();
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private final Set<Statement> conditionStatements = new HashSet<Statement>();

        private CheckVisitor() {
        }

        public Set<Statement> getConditionStatements() {
            return new HashSet<Statement>(this.conditionStatements);
        }

        @Override
        public void visit(IfStatement node) {
            this.addStatement(node.getTrueStatement());
            this.addStatement(node.getFalseStatement());
        }

        @Override
        public void visit(SwitchCase node) {
            this.addStatement(node);
        }

        private void addStatement(Statement statement) {
            if (statement != null) {
                this.conditionStatements.add(statement);
            }
        }
    }
}

