/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.BreakStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ContinueStatement;
import org.netbeans.modules.php.editor.parser.astnodes.DoStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForEachStatement;
import org.netbeans.modules.php.editor.parser.astnodes.ForStatement;
import org.netbeans.modules.php.editor.parser.astnodes.IfStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Program;
import org.netbeans.modules.php.editor.parser.astnodes.ReturnStatement;
import org.netbeans.modules.php.editor.parser.astnodes.Statement;
import org.netbeans.modules.php.editor.parser.astnodes.SwitchCase;
import org.netbeans.modules.php.editor.parser.astnodes.ThrowStatement;
import org.netbeans.modules.php.editor.parser.astnodes.WhileStatement;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.HintRule;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.openide.filesystems.FileObject;

public class UnreachableStatementHint
extends HintRule {
    private static final String HINT_ID = "Unreachable.Statement.Hint";

    @Override
    public void invoke(PHPRuleContext context, List<Hint> hints) {
        FileObject fileObject;
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() != null && (fileObject = phpParseResult.getSnapshot().getSource().getFileObject()) != null) {
            CheckVisitor checkVisitor = new CheckVisitor(fileObject, context.doc);
            phpParseResult.getProgram().accept(checkVisitor);
            hints.addAll(checkVisitor.getHints());
        }
    }

    public String getId() {
        return HINT_ID;
    }

    public String getDescription() {
        return Bundle.UnreachableStatementHintDesc();
    }

    public String getDisplayName() {
        return Bundle.UnreachableStatementHintDisp();
    }

    private static final class CheckedBlock {
        private Statement lastStatement;
        private ASTNode unreachableStatement;

        private CheckedBlock() {
        }

        public void setLastStatement(Statement lastStatement) {
            this.lastStatement = lastStatement;
        }

        public boolean hasLastStatement() {
            return this.lastStatement != null;
        }

        public void setUnreachableStatement(ASTNode unreachableStatement) {
            this.unreachableStatement = unreachableStatement;
        }

        public ASTNode getUnreachableStatement() {
            return this.unreachableStatement;
        }
    }

    private final class CheckVisitor
    extends DefaultVisitor {
        private final FileObject fileObject;
        private final BaseDocument baseDocument;
        private final Stack<CheckedBlock> blocks;
        private final List<CheckedBlock> processedBlocks;
        private final List<Hint> hints;

        public CheckVisitor(FileObject fileObject, BaseDocument baseDocument) {
            this.fileObject = fileObject;
            this.baseDocument = baseDocument;
            this.blocks = new Stack();
            this.processedBlocks = new ArrayList<CheckedBlock>();
            this.hints = new ArrayList<Hint>();
        }

        public List<Hint> getHints() {
            for (CheckedBlock checkedBlock : this.processedBlocks) {
                ASTNode unreachableStatement = checkedBlock.getUnreachableStatement();
                if (unreachableStatement == null) continue;
                this.createHint(unreachableStatement);
            }
            return this.hints;
        }

        private void createHint(ASTNode unreachableStatement) {
            OffsetRange offsetRange = new OffsetRange(unreachableStatement.getStartOffset(), unreachableStatement.getEndOffset());
            if (UnreachableStatementHint.this.showHint(offsetRange, this.baseDocument)) {
                this.hints.add(new Hint((Rule)UnreachableStatementHint.this, Bundle.UnreachableStatementHintText(), this.fileObject, offsetRange, null, 500));
            }
        }

        @Override
        public void visit(ForStatement node) {
            Statement body = node.getBody();
            if (body instanceof Block) {
                super.visit(node);
            } else {
                this.blocks.push(new CheckedBlock());
                super.visit(node);
                this.processedBlocks.add(this.blocks.pop());
            }
        }

        @Override
        public void visit(ForEachStatement node) {
            Statement body = node.getStatement();
            if (body instanceof Block) {
                super.visit(node);
            } else {
                this.blocks.push(new CheckedBlock());
                super.visit(node);
                this.processedBlocks.add(this.blocks.pop());
            }
        }

        @Override
        public void visit(DoStatement node) {
            Statement body = node.getBody();
            if (body instanceof Block) {
                super.visit(node);
            } else {
                this.blocks.push(new CheckedBlock());
                super.visit(node);
                this.processedBlocks.add(this.blocks.pop());
            }
        }

        @Override
        public void visit(IfStatement node) {
            this.scan(node.getCondition());
            Statement trueStatement = node.getTrueStatement();
            if (trueStatement instanceof Block) {
                this.scan(trueStatement);
            } else {
                this.blocks.push(new CheckedBlock());
                this.scan(trueStatement);
                this.processedBlocks.add(this.blocks.pop());
            }
            Statement falseStatement = node.getFalseStatement();
            if (falseStatement instanceof Block) {
                this.scan(falseStatement);
            } else {
                this.blocks.push(new CheckedBlock());
                this.scan(falseStatement);
                this.processedBlocks.add(this.blocks.pop());
            }
        }

        @Override
        public void visit(WhileStatement node) {
            Statement body = node.getBody();
            if (body instanceof Block) {
                super.visit(node);
            } else {
                this.blocks.push(new CheckedBlock());
                super.visit(node);
                this.processedBlocks.add(this.blocks.pop());
            }
        }

        @Override
        public void visit(SwitchCase node) {
            this.scan(node.getValue());
            this.blocks.push(new CheckedBlock());
            this.scan(node.getActions());
            this.processedBlocks.add(this.blocks.pop());
        }

        @Override
        public void visit(Program node) {
            this.blocks.push(new CheckedBlock());
            super.visit(node);
            this.processedBlocks.add(this.blocks.pop());
        }

        @Override
        public void visit(Block node) {
            this.blocks.push(new CheckedBlock());
            super.visit(node);
            this.processedBlocks.add(this.blocks.pop());
        }

        @Override
        public void visit(ReturnStatement node) {
            super.visit(node);
            this.processLastStatement(node);
        }

        @Override
        public void visit(BreakStatement node) {
            super.visit(node);
            this.processLastStatement(node);
        }

        @Override
        public void visit(ContinueStatement node) {
            super.visit(node);
            this.processLastStatement(node);
        }

        @Override
        public void visit(ThrowStatement node) {
            super.visit(node);
            this.processLastStatement(node);
        }

        private void processLastStatement(Statement node) {
            if (!this.blocks.empty()) {
                CheckedBlock lastCheckedBlock = this.blocks.peek();
                lastCheckedBlock.setLastStatement(node);
            }
        }

        @Override
        public void scan(ASTNode node) {
            CheckedBlock lastCheckedBlock;
            if (!this.blocks.empty() && (lastCheckedBlock = this.blocks.peek()).hasLastStatement() && lastCheckedBlock.getUnreachableStatement() == null) {
                lastCheckedBlock.setUnreachableStatement(node);
            }
            super.scan(node);
        }
    }
}

