/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.eecommon.api;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.openide.ErrorManager;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class ExecSupport {
    ExecSupport() {
    }

    void displayProcessOutputs(final Process child, String displayName, String initialMessage) throws IOException, InterruptedException {
        InputOutput io = IOProvider.getDefault().getIO(displayName, false);
        OutputWriter ow = io.getOut();
        try {
            io.getOut().reset();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        ow.println(initialMessage);
        final Thread[] copyMakers = new Thread[3];
        copyMakers[0] = new OutputCopier(new InputStreamReader(child.getInputStream()), (Writer)ow, true);
        copyMakers[0].start();
        copyMakers[1] = new OutputCopier(new InputStreamReader(child.getErrorStream()), (Writer)io.getErr(), true);
        copyMakers[1].start();
        copyMakers[2] = new OutputCopier(io.getIn(), new OutputStreamWriter(child.getOutputStream()), true);
        copyMakers[2].start();
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    child.waitFor();
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                }
                finally {
                    try {
                        copyMakers[0].interrupt();
                        copyMakers[1].interrupt();
                        copyMakers[2].interrupt();
                    }
                    catch (Exception e) {
                        ErrorManager.getDefault().notify(1, (Throwable)e);
                    }
                }
            }
        }.start();
    }

    public static class OutputCopier
    extends Thread {
        final Writer os;
        final Reader is;
        final boolean autoflush;
        private boolean done = false;

        public OutputCopier(Reader is, Writer os, boolean b) {
            this.os = os;
            this.is = is;
            this.autoflush = b;
        }

        @Override
        public void run() {
            char[] buff = new char[256];
            try {
                int read;
                while ((read = this.read(this.is, buff, 0, 256)) > 0) {
                    if (this.os == null) continue;
                    this.os.write(buff, 0, read);
                    if (!this.autoflush) continue;
                    this.os.flush();
                }
            }
            catch (IOException ex) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void interrupt() {
            super.interrupt();
            this.done = true;
        }

        private int read(Reader is, char[] buff, int start, int count) throws InterruptedException, IOException {
            while (!is.ready() && !this.done) {
                OutputCopier.sleep(100L);
            }
            return is.read(buff, start, count);
        }
    }
}

