/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLClassLoader;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.manager.ui.ArrayTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.HolderTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.JAXBElementTreeNode;
import org.netbeans.modules.websvc.manager.ui.ListTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.ReflectionHelper;
import org.netbeans.modules.websvc.manager.ui.StructureTypeTreeNode;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.netbeans.modules.websvc.manager.ui.WebServiceReflectionException;
import org.openide.ErrorManager;

public final class NodeHelper {
    private final URLClassLoader loader;
    private static NodeHelper instance;

    private NodeHelper(URLClassLoader loader) {
        this.loader = loader;
    }

    public static NodeHelper createInstance(URLClassLoader loader) {
        NodeHelper result;
        instance = result = new NodeHelper(loader);
        return result;
    }

    public static NodeHelper getInstance() {
        return instance;
    }

    private URLClassLoader getRuntimeClassLoader() {
        return this.loader;
    }

    public DefaultMutableTreeNode createNodeFromData(TypeNodeData data) throws WebServiceReflectionException {
        DefaultMutableTreeNode node = null;
        String parameterClass = data.getTypeClass();
        if (ReflectionHelper.isHolder(parameterClass)) {
            node = new HolderTypeTreeNode(data, this.getRuntimeClassLoader());
            DefaultMutableTreeNode childNode = null;
            String holderType = data.getGenericType();
            if (holderType == null) {
                holderType = "java.lang.Object";
                data.setGenericType(holderType);
            }
            TypeNodeData heldData = ReflectionHelper.createTypeData(holderType, "value");
            heldData.setTypeValue(this.getParameterDefaultValue(heldData));
            heldData.setAssignable(data.isAssignable());
            ReflectionHelper.setHolderValue(data.getTypeValue(), heldData.getTypeValue());
            childNode = this.createNodeFromData(heldData);
            node.add(childNode);
        } else if (ReflectionHelper.isJAXBElement(parameterClass)) {
            node = new JAXBElementTreeNode(data, this.getRuntimeClassLoader());
            TypeNodeData localPartData = ReflectionHelper.createTypeData("java.lang.String", "localPart");
            DefaultMutableTreeNode localPartNode = new DefaultMutableTreeNode(localPartData);
            node.add(localPartNode);
            String valueType = data.getGenericType();
            if (valueType == null) {
                valueType = "java.lang.Object";
                data.setGenericType(valueType);
            }
            TypeNodeData heldData = ReflectionHelper.createTypeData(valueType, "value");
            heldData.setTypeValue(this.getParameterDefaultValue(heldData));
            heldData.setAssignable(data.isAssignable());
            DefaultMutableTreeNode valueNode = this.createNodeFromData(heldData);
            node.add(valueNode);
        } else if (ReflectionHelper.isArray(parameterClass)) {
            node = new ArrayTypeTreeNode((Object)data, this.getRuntimeClassLoader());
            this.addParameterArrayInstances(node);
        } else if (ReflectionHelper.isCollection(data.getTypeClass(), this.getRuntimeClassLoader())) {
            node = new ListTypeTreeNode(data, this.getRuntimeClassLoader());
            this.addParameterArrayInstances(node);
        } else if (ReflectionHelper.isComplexType(data.getTypeClass(), this.getRuntimeClassLoader())) {
            node = new StructureTypeTreeNode(data, this.getRuntimeClassLoader());
            this.traverseType(node);
        } else {
            node = new DefaultMutableTreeNode(data);
        }
        return node;
    }

    public DefaultMutableTreeNode createResultNodeFromData(TypeNodeData data) throws WebServiceReflectionException {
        DefaultMutableTreeNode node = null;
        String typeClass = data.getTypeClass();
        if (ReflectionHelper.isCollection(typeClass, this.getRuntimeClassLoader())) {
            node = new ListTypeTreeNode(data, this.getRuntimeClassLoader());
            this.addResultArrayInstances(node);
        } else if (ReflectionHelper.isComplexType(typeClass, this.getRuntimeClassLoader())) {
            node = new StructureTypeTreeNode(data, this.getRuntimeClassLoader());
            this.traverseResultType(node);
        } else {
            node = new DefaultMutableTreeNode(data);
        }
        return node;
    }

    private void traverseType(DefaultMutableTreeNode inNode) throws WebServiceReflectionException {
        if (null == inNode) {
            return;
        }
        TypeNodeData inData = (TypeNodeData)inNode.getUserObject();
        String inType = inData.getTypeClass();
        List<String> members = ReflectionHelper.getPropertyNames(inType, this.getRuntimeClassLoader());
        for (String fieldName : members) {
            String fieldType = ReflectionHelper.getPropertyType(inType, fieldName, this.getRuntimeClassLoader());
            TypeNodeData childData = ReflectionHelper.createTypeData(fieldType, fieldName);
            childData.setTypeValue(this.getParameterDefaultValue(childData));
            if (!ReflectionHelper.isPropertySettable(inType, fieldName, this.getRuntimeClassLoader())) {
                childData.setAssignable(false);
            }
            DefaultMutableTreeNode childNode = this.createNodeFromData(childData);
            inNode.add(childNode);
        }
    }

    private void traverseResultType(DefaultMutableTreeNode inParentNode) throws WebServiceReflectionException {
        if (null == inParentNode) {
            return;
        }
        TypeNodeData parentData = (TypeNodeData)inParentNode.getUserObject();
        String parentType = parentData.getTypeClass();
        Object parentValue = parentData.getTypeValue();
        if (parentValue != null) {
            List<String> members = ReflectionHelper.getPropertyNames(parentType, this.getRuntimeClassLoader());
            for (String fieldName : members) {
                String fieldType = ReflectionHelper.getPropertyType(parentType, fieldName, this.getRuntimeClassLoader());
                Object fieldValue = ReflectionHelper.getPropertyValue(parentValue, fieldName, this.getRuntimeClassLoader());
                TypeNodeData resultData = ReflectionHelper.createTypeData(fieldType, fieldName, fieldValue);
                DefaultMutableTreeNode resultNode = this.createResultNodeFromData(resultData);
                inParentNode.add(resultNode);
            }
        }
    }

    private void addParameterArrayInstances(DefaultMutableTreeNode parentNode) throws WebServiceReflectionException {
        TypeNodeData inData = (TypeNodeData)parentNode.getUserObject();
        String elementType = inData.getGenericType();
        for (int ii = 0; ii < 9; ++ii) {
            TypeNodeData data = ReflectionHelper.createTypeData(elementType, "[" + ii + "]");
            data.setTypeValue(this.getParameterDefaultValue(data));
            data.setAssignable(inData.isAssignable());
            DefaultMutableTreeNode childNode = this.createNodeFromData(data);
            parentNode.add(childNode);
        }
    }

    private void addResultArrayInstances(DefaultMutableTreeNode parentNode) throws WebServiceReflectionException {
        Collection collection;
        TypeNodeData parentData = (TypeNodeData)parentNode.getUserObject();
        String elementType = parentData.getGenericType();
        if (elementType == null) {
            elementType = "java.lang.Object";
            parentData.setGenericType(elementType);
        }
        if ((collection = (Collection)parentData.getTypeValue()) == null) {
            return;
        }
        int i = 0;
        for (Object nextValue : collection) {
            TypeNodeData childData = ReflectionHelper.createTypeData(elementType, "[" + i + "]", nextValue);
            DefaultMutableTreeNode childNode = this.createResultNodeFromData(childData);
            parentNode.add(childNode);
            ++i;
        }
    }

    public Object getParameterDefaultValue(TypeNodeData data) {
        assert (data != null);
        try {
            String typeClass = data.getTypeClass();
            if (ReflectionHelper.isComplexType(typeClass, this.getRuntimeClassLoader())) {
                return ReflectionHelper.makeComplexType(typeClass, this.getRuntimeClassLoader());
            }
            if (ReflectionHelper.isCollection(typeClass, this.getRuntimeClassLoader())) {
                return ReflectionHelper.makeCollection(typeClass, this.getRuntimeClassLoader());
            }
            if (ReflectionHelper.isHolder(typeClass)) {
                return ReflectionHelper.makeHolder(this.getRuntimeClassLoader());
            }
            if (ReflectionHelper.isEnumeration(typeClass, this.getRuntimeClassLoader())) {
                return ReflectionHelper.makeEnumeration(typeClass, this.getRuntimeClassLoader());
            }
            if (ReflectionHelper.isArray(typeClass)) {
                return ReflectionHelper.makeGenericArray(data.getGenericType(), 0, this.getRuntimeClassLoader());
            }
            String currentType = typeClass;
            Object value = null;
            if (currentType.equals(Integer.TYPE.getName()) || currentType.equals(Integer.class.getName())) {
                value = 0;
            } else if (currentType.equals(Byte.TYPE.getName()) || currentType.equals(Byte.class.getName())) {
                value = Byte.valueOf("0");
            } else if (currentType.equals(Boolean.TYPE.getName()) || currentType.equals(Boolean.class.getName())) {
                value = false;
            } else if (currentType.equals(Float.TYPE.getName()) || currentType.equals(Float.class.getName())) {
                value = Float.valueOf(0.0f);
            } else if (currentType.equals(Double.TYPE.getName()) || currentType.equals(Double.class.getName())) {
                value = 0.0;
            } else if (currentType.equals(Long.TYPE.getName()) || currentType.equals(Long.class.getName())) {
                value = 0L;
            } else if (currentType.equals(Short.TYPE.getName()) || currentType.equals(Short.class.getName())) {
                value = Short.valueOf("0");
            } else if (currentType.equals(String.class.getName())) {
                value = "";
            } else if (currentType.equals(BigDecimal.class.getName())) {
                value = BigDecimal.valueOf(0L);
            } else if (currentType.equals(BigInteger.class.getName())) {
                value = BigInteger.valueOf(0L);
            } else if (currentType.equals(URI.class.getName())) {
                try {
                    value = new URI("http://java.sun.com");
                }
                catch (URISyntaxException uri) {}
            } else if (currentType.equals(Calendar.class.getName())) {
                value = Calendar.getInstance();
            } else if (currentType.equalsIgnoreCase(Date.class.getName())) {
                value = new Date();
            }
            return value;
        }
        catch (WebServiceReflectionException wsre) {
            Throwable cause = wsre.getCause();
            ErrorManager.getDefault().notify(cause);
            ErrorManager.getDefault().log(this.getClass().getName() + ": Error trying to do Class.forName on: " + data.getRealTypeName() + "WebServiceReflectionException=" + cause);
            return null;
        }
    }
}

