/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.manager.ui;

import java.net.URLClassLoader;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.netbeans.modules.websvc.manager.ui.AbstractParameterTreeNode;
import org.netbeans.modules.websvc.manager.ui.NodeHelper;
import org.netbeans.modules.websvc.manager.ui.ParameterTreeNode;
import org.netbeans.modules.websvc.manager.ui.ReflectionHelper;
import org.netbeans.modules.websvc.manager.ui.TypeNodeData;
import org.netbeans.modules.websvc.manager.ui.WebServiceReflectionException;
import org.openide.ErrorManager;

public class StructureTypeTreeNode
extends AbstractParameterTreeNode {
    private URLClassLoader urlClassLoader;

    public StructureTypeTreeNode(TypeNodeData userObject, URLClassLoader inClassLoader) {
        super(userObject);
        this.urlClassLoader = inClassLoader;
    }

    @Override
    public void updateValueFromChildren(TypeNodeData inData) {
        TypeNodeData data = (TypeNodeData)this.getUserObject();
        try {
            Object structObject = data.getTypeValue();
            String propType = inData.getTypeClass();
            String propName = inData.getTypeName();
            Object propObject = inData.getTypeValue();
            ReflectionHelper.setPropertyValue(structObject, propName, propType, propObject, this.urlClassLoader);
        }
        catch (WebServiceReflectionException wsfe) {
            Throwable cause = wsfe.getCause();
            ErrorManager.getDefault().notify(cause);
            ErrorManager.getDefault().log(this.getClass().getName() + ": Error trying to update Children of a Structure on: " + data.getRealTypeName() + "WebServiceReflectionException=" + cause);
        }
        DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.getParent();
        if (parentNode != null && parentNode instanceof ParameterTreeNode) {
            ((ParameterTreeNode)((Object)parentNode)).updateValueFromChildren(data);
        }
    }

    @Override
    public void updateChildren() {
        TypeNodeData data = (TypeNodeData)this.getUserObject();
        Object structObj = data.getTypeValue();
        if (structObj == null) {
            return;
        }
        try {
            String type = data.getTypeClass();
            List<String> fields = ReflectionHelper.getPropertyNames(type, this.urlClassLoader);
            for (int i = 0; i < fields.size(); ++i) {
                TypeNodeData childData;
                String fieldName = fields.get(i);
                String fieldType = ReflectionHelper.getPropertyType(type, fieldName, this.urlClassLoader);
                Object newChildValue = ReflectionHelper.getPropertyValue(structObj, fieldName, this.urlClassLoader);
                DefaultMutableTreeNode currentChildNode = null;
                if (i >= this.getChildCount()) {
                    childData = ReflectionHelper.createTypeData(fieldType, fieldName);
                    Object defaultChildValue = NodeHelper.getInstance().getParameterDefaultValue(childData);
                    childData.setTypeValue(defaultChildValue);
                    currentChildNode = NodeHelper.getInstance().createNodeFromData(childData);
                    this.add(currentChildNode);
                } else {
                    currentChildNode = (DefaultMutableTreeNode)this.getChildAt(i);
                }
                childData = (TypeNodeData)currentChildNode.getUserObject();
                childData.setTypeValue(newChildValue);
                currentChildNode.setUserObject(childData);
                if (!(currentChildNode instanceof ParameterTreeNode)) continue;
                ((ParameterTreeNode)((Object)currentChildNode)).updateChildren();
            }
        }
        catch (WebServiceReflectionException wsfe) {
            Throwable cause = wsfe.getCause();
            ErrorManager.getDefault().notify(cause);
            ErrorManager.getDefault().log(this.getClass().getName() + ": Error trying to update Children of a Structure on: " + data.getRealTypeName() + "WebServiceReflectionException=" + cause);
        }
    }
}

