/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.refactoring.utils;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.groovy.support.api.GroovyExtender;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class GroovyProjectUtil {
    public static boolean isFromEditor(EditorCookie ec) {
        return ec != null && ec.getOpenedPanes() != null;
    }

    public static boolean isOnSourceClasspath(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project == null) {
            return false;
        }
        if (OpenProjects.getDefault().isProjectOpen(project)) {
            for (SourceGroup group : GroovySources.getGroovySourceGroups((Sources)ProjectUtils.getSources((Project)project))) {
                if (group.getRootFolder().equals(fo)) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)group.getRootFolder(), (FileObject)fo)) continue;
                return true;
            }
        }
        return false;
    }

    public static ClasspathInfo getClasspathInfoFor(FileObject ... files) {
        assert (files.length > 0);
        HashSet<URL> dependentRoots = new HashSet<URL>();
        for (FileObject fo : files) {
            if (fo == null) continue;
            Project p = FileOwnerQuery.getOwner((FileObject)fo);
            if (p != null) {
                ClassPath sourceClasspath = ClassPath.getClassPath((FileObject)fo, (String)"classpath/source");
                if (sourceClasspath != null) {
                    URL sourceRoot = URLMapper.findURL((FileObject)sourceClasspath.findOwnerRoot(fo), (int)0);
                    for (URL root : SourceUtils.getDependentRoots((URL)sourceRoot)) {
                        dependentRoots.add(root);
                    }
                }
                for (SourceGroup root : ProjectUtils.getSources((Project)p).getSourceGroups("java")) {
                    dependentRoots.add(URLMapper.findURL((FileObject)root.getRootFolder(), (int)0));
                }
                continue;
            }
            for (ClassPath cp : GlobalPathRegistry.getDefault().getPaths("classpath/source")) {
                for (FileObject root : cp.getRoots()) {
                    dependentRoots.add(URLMapper.findURL((FileObject)root, (int)0));
                }
            }
        }
        ClassPath bootCP = GroovyProjectUtil.getClassPath(files[0], "classpath/boot");
        ClassPath compileCP = GroovyProjectUtil.getClassPath(files[0], "classpath/compile");
        ClassPath sourceCP = ClassPathSupport.createClassPath((URL[])dependentRoots.toArray(new URL[dependentRoots.size()]));
        return ClasspathInfo.create((ClassPath)bootCP, (ClassPath)compileCP, (ClassPath)sourceCP);
    }

    private static ClassPath getClassPath(FileObject fo, String classPathType) {
        if (fo != null) {
            ClassPath classPath = ClassPath.getClassPath((FileObject)fo, (String)classPathType);
            if (classPath != null) {
                return classPath;
            }
            return ClassPath.EMPTY;
        }
        return ClassPath.EMPTY;
    }

    public static List<FileObject> getGroovyFilesInProject(FileObject fileInProject) {
        ClasspathInfo cpInfo = GroovyProjectUtil.getClasspathInfoFor(fileInProject);
        ClassPath cp = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        ArrayList<FileObject> list = new ArrayList<FileObject>(100);
        for (ClassPath.Entry entry : cp.entries()) {
            FileObject root = entry.getRoot();
            GroovyProjectUtil.addGroovyFiles(list, root);
        }
        return list;
    }

    private static void addGroovyFiles(List<FileObject> list, FileObject f) {
        if (f.isFolder()) {
            for (FileObject child : f.getChildren()) {
                GroovyProjectUtil.addGroovyFiles(list, child);
            }
        } else if (GroovyProjectUtil.isGroovyFile(f)) {
            list.add(f);
        }
    }

    public static boolean isInGroovyProject(FileObject f) {
        Project project = FileOwnerQuery.getOwner((FileObject)f);
        if (project != null) {
            return GroovyExtender.isActive((Project)project);
        }
        return false;
    }

    public static boolean isGroovyFile(FileObject f) {
        return "text/x-groovy".equals(f.getMIMEType());
    }

    private static LineCookie getLineCookie(FileObject fo) {
        LineCookie result = null;
        try {
            DataObject dataObject = DataObject.find((FileObject)fo);
            if (dataObject != null) {
                result = (LineCookie)dataObject.getLookup().lookup(LineCookie.class);
            }
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public static Line getLine(FileObject fileObject, int lineNumber) {
        LineCookie lineCookie = GroovyProjectUtil.getLineCookie(fileObject);
        assert (lineCookie != null);
        try {
            return lineCookie.getLineSet().getCurrent(lineNumber);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
    }

    public static CloneableEditorSupport findCloneableEditorSupport(FileObject fileObject) {
        try {
            DataObject dob = DataObject.find((FileObject)fileObject);
            return GroovyProjectUtil.findCloneableEditorSupport(dob);
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dob) {
        Object obj = dob.getLookup().lookup(OpenCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        obj = dob.getLookup().lookup(EditorCookie.class);
        if (obj instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)obj;
        }
        return null;
    }

    public static BaseDocument getDocument(ParserResult info, FileObject fo) {
        BaseDocument doc = null;
        try {
            DataObject dataObject;
            EditorCookie ec;
            if (info != null) {
                doc = (BaseDocument)info.getSnapshot().getSource().getDocument(false);
            }
            if (doc == null && (ec = (EditorCookie)(dataObject = DataObject.find((FileObject)fo)).getLookup().lookup(EditorCookie.class)) != null) {
                doc = (BaseDocument)ec.openDocument();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return doc;
    }

    public static Problem addToEnd(Problem toAdd, Problem existing) {
        if (existing == null) {
            return toAdd;
        }
        if (toAdd == null) {
            return existing;
        }
        Problem tail = existing;
        while (tail.getNext() != null) {
            tail = tail.getNext();
        }
        tail.setNext(toAdd);
        return tail;
    }
}

