/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.modules.web.beans.impl.model.AbstractAssignabilityChecker;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.RestrictedTypedFilter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelProviderImpl;

class TypeBindingFilter
extends Filter<TypeElement> {
    private TypeMirror myVarType;
    private WebBeansModelImplementation myImpl;
    private String mySimpleName;
    private boolean isGeneric;
    private Element myInjectionPoint;

    TypeBindingFilter() {
    }

    static TypeBindingFilter get() {
        return new TypeBindingFilter();
    }

    void init(TypeMirror varType, Element injectionPoint, WebBeansModelImplementation modelImpl) {
        this.mySimpleName = injectionPoint.getSimpleName().toString();
        this.myImpl = modelImpl;
        this.myVarType = varType;
        this.myInjectionPoint = injectionPoint;
        this.setIsGeneric();
    }

    @Override
    void filter(Set<TypeElement> set) {
        super.filter(set);
        if (set.size() == 0) {
            return;
        }
        TypeKind kind = this.getType().getKind();
        if (kind == TypeKind.DECLARED) {
            this.filterDeclaredTypes(set);
        } else if (kind.isPrimitive()) {
            WebBeansModelProviderImpl.LOGGER.fine("Variable element " + this.mySimpleName + " " + "couldn't have type as eligible for inection becuase its " + "type is primitive. It is unproxyable bean types");
            set.clear();
        } else if (kind == TypeKind.ARRAY) {
            WebBeansModelProviderImpl.LOGGER.fine("Variable element " + this.mySimpleName + " " + "couldn't have type as eligible for inection becuase its " + "type has array type. It is unproxyable bean types");
            set.clear();
        }
    }

    boolean isAssignable(TypeMirror type, Element sourceElement) {
        if (!this.isGeneric) {
            Collection<TypeMirror> restrictedTypes = RestrictedTypedFilter.getRestrictedTypes(sourceElement, this.getImplementation());
            if (restrictedTypes == null) {
                if (this.getImplementation().getHelper().getCompilationController().getTypes().isAssignable(type, this.getType())) {
                    WebBeansModelProviderImpl.LOGGER.fine("Found type  " + type + " for variable element " + this.mySimpleName + " by typesafe resolution");
                    return true;
                }
            } else {
                Types types = this.getImplementation().getHelper().getCompilationController().getTypes();
                for (TypeMirror restrictedType : restrictedTypes) {
                    if (!types.isSameType(types.erasure(this.getType()), types.erasure(restrictedType))) continue;
                    WebBeansModelProviderImpl.LOGGER.fine("Found type  " + type + " for variable element " + this.mySimpleName + " by typesafe resolution");
                    return true;
                }
            }
        }
        if (this.checkAssignability(type, sourceElement)) {
            WebBeansModelProviderImpl.LOGGER.fine("Probably found castable parametrizied or raw type " + type + " for variable element " + this.mySimpleName + " by typesafe resolution");
            return true;
        }
        return false;
    }

    private void setIsGeneric() {
        Element typeElement = this.getImplementation().getHelper().getCompilationController().getTypes().asElement(this.getType());
        this.isGeneric = typeElement instanceof TypeElement && ((TypeElement)typeElement).getTypeParameters().size() != 0;
    }

    private void filterDeclaredTypes(Set<TypeElement> set) {
        Iterator<TypeElement> iterator = set.iterator();
        while (iterator.hasNext()) {
            TypeElement type = iterator.next();
            if (this.isAssignable(type.asType(), type)) continue;
            iterator.remove();
        }
    }

    private boolean checkAssignability(TypeMirror type, Element originalElement) {
        if (!(type instanceof ReferenceType)) {
            return false;
        }
        Element injectionPoint = this.getInjectionPoint();
        AbstractAssignabilityChecker.AssignabilityType assignType = AbstractAssignabilityChecker.AssignabilityType.PLAIN;
        if (injectionPoint != null && AnnotationObjectProvider.hasAnnotation(injectionPoint, "javax.decorator.Delegate", this.getImplementation().getHelper())) {
            assignType = AbstractAssignabilityChecker.AssignabilityType.DECORATOR;
        }
        AbstractAssignabilityChecker checker = AbstractAssignabilityChecker.get(assignType);
        checker.init((DeclaredType)this.getType(), (ReferenceType)type, originalElement, this.getImplementation());
        return checker.check();
    }

    private TypeMirror getType() {
        return this.myVarType;
    }

    private Element getInjectionPoint() {
        return this.myInjectionPoint;
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }
}

