/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.section;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitInterface;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnitStab;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.reader.DwarfReader;
import org.netbeans.modules.cnd.dwarfdump.section.DwarfDebugInfoSection;
import org.netbeans.modules.cnd.dwarfdump.section.ElfSection;
import org.netbeans.modules.cnd.dwarfdump.section.StabIndexStrSection;
import org.netbeans.modules.cnd.dwarfdump.source.CompileLineOrigin;
import org.netbeans.modules.cnd.dwarfdump.source.DefaultDriver;

public class StabIndexSection
extends ElfSection {
    private final StabIndexStrSection strings;
    private final List<CompilationUnitInterface> list = new ArrayList<CompilationUnitInterface>();
    private static final int N_UNDF = 0;
    private static final int N_ILDPAD = 76;
    private static final int N_FUN = 36;
    private static final int N_SO = 100;
    private static final int N_OBJ = 56;
    private static final int N_CMDLINE = 52;
    private static final int N_MAIN = 42;

    public StabIndexSection(DwarfReader reader, int sectionIdx) throws IOException {
        super(reader, sectionIdx);
        this.strings = (StabIndexStrSection)reader.getSection(".stab.indexstr");
        this.read();
    }

    public Dwarf.CompilationUnitIterator compilationUnits() throws IOException {
        return new DwarfDebugInfoSection.ListIterator(this.list.iterator());
    }

    public final StabIndexSection read() throws IOException {
        long sectionStart = this.header.getSectionOffset();
        long sectionEnd = this.header.getSectionSize() + sectionStart;
        this.reader.seek(sectionStart);
        long StabStrtab = 0L;
        long StrTabSize = 0L;
        String compileDir = "";
        String source = "";
        String line = "";
        String object = "";
        String lastUndef = "";
        String cuName = "";
        boolean isMain = false;
        int mainLine = 0;
        int state = 1;
        int lang = 0;
        while (this.reader.getFilePointer() < sectionEnd) {
            String s;
            long str;
            int offset = this.reader.readInt();
            int type = this.reader.readByte() & 0xFF;
            int other = this.reader.readByte() & 0xFF;
            short desc = this.reader.readShort();
            int value = this.reader.readInt();
            if (type == 0 || type == 76) {
                StabStrtab += StrTabSize;
                StrTabSize = value;
            }
            if (offset == 0) continue;
            if (type == 36 && other == 1) {
                if (offset == 1) {
                    ++StrTabSize;
                }
                str = StabStrtab + StrTabSize;
                s = this.strings.getString(str);
                StrTabSize += (long)(s.length() + 1);
            } else {
                str = StabStrtab + (long)offset;
                s = this.strings.getString(str);
            }
            switch (type) {
                case 100: {
                    if (state != 1) {
                        this.list.add(this.createCompilationUnitStab(compileDir, source, line, object, isMain, mainLine, lang, cuName));
                        compileDir = "";
                        source = "";
                        line = "";
                        object = "";
                        cuName = "";
                        isMain = false;
                        mainLine = 0;
                        lang = 0;
                    }
                    if (compileDir.isEmpty()) {
                        cuName = lastUndef;
                        compileDir = s;
                    } else {
                        source = s;
                    }
                    state = 1;
                    if (lang != 0 || desc == 0) break;
                    lang = desc;
                    break;
                }
                case 56: {
                    object = object + s;
                    state = 2;
                    break;
                }
                case 52: {
                    line = s;
                    state = 3;
                    break;
                }
                case 42: {
                    isMain = true;
                    mainLine = value;
                    break;
                }
                case 0: {
                    lastUndef = s;
                    break;
                }
            }
        }
        if (state >= 1) {
            this.list.add(this.createCompilationUnitStab(compileDir, source, line, object, isMain, mainLine, lang, cuName));
        }
        return null;
    }

    private CompilationUnitStab createCompilationUnitStab(String compileDir, String sourceName, String line, String objectFile, boolean hasMain, int mainLine, int desc, String lastUndef) {
        String compileLine;
        int i;
        if (lastUndef.length() > 0 && !sourceName.endsWith(lastUndef) && (i = line.indexOf(59)) > 0 && (compileLine = line.substring(i + 1).trim()).length() > 0) {
            DefaultDriver driver = new DefaultDriver();
            for (String s : driver.splitCommandLine(compileLine, CompileLineOrigin.DwarfCompileLine)) {
                if (!s.endsWith(lastUndef)) continue;
                sourceName = s;
                break;
            }
        }
        String trueSource = sourceName.startsWith("/") ? sourceName : compileDir + sourceName;
        return new CompilationUnitStab(trueSource, line, objectFile, hasMain, mainLine, desc);
    }
}

