/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.weblogic.common.api;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.extexecution.base.BaseExecutionDescriptor;
import org.netbeans.api.extexecution.base.BaseExecutionService;
import org.netbeans.api.extexecution.base.ProcessBuilder;
import org.netbeans.api.extexecution.base.input.InputProcessor;
import org.netbeans.api.extexecution.base.input.InputProcessors;
import org.netbeans.api.extexecution.base.input.LineProcessor;
import org.netbeans.api.extexecution.base.input.LineProcessors;
import org.netbeans.modules.weblogic.common.ProxyUtils;
import org.netbeans.modules.weblogic.common.api.BatchDeployListener;
import org.netbeans.modules.weblogic.common.api.DeployListener;
import org.netbeans.modules.weblogic.common.api.Version;
import org.netbeans.modules.weblogic.common.api.WebLogicConfiguration;
import org.netbeans.modules.weblogic.common.api.WebLogicRemote;
import org.netbeans.modules.weblogic.common.spi.WebLogicTrustHandler;
import org.openide.util.BaseUtilities;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class WebLogicDeployer {
    private static final Logger LOGGER = Logger.getLogger(WebLogicDeployer.class.getName());
    private static final RequestProcessor DEPLOYMENT_RP = new RequestProcessor(WebLogicDeployer.class);
    private static final int TIMEOUT = 300000;
    private static final Version VERSION_10 = Version.fromJsr277NotationWithFallback("10");
    private final WebLogicConfiguration config;
    private final File javaBinary;
    private final Callable<String> nonProxy;

    private WebLogicDeployer(WebLogicConfiguration config, File javaBinary, @NullAllowed Callable<String> nonProxy) {
        this.config = config;
        this.javaBinary = javaBinary;
        this.nonProxy = nonProxy;
    }

    @NonNull
    public static WebLogicDeployer getInstance(@NonNull WebLogicConfiguration config, @NullAllowed File javaBinary, @NullAllowed Callable<String> nonProxy) {
        return new WebLogicDeployer(config, javaBinary, nonProxy);
    }

    @NonNull
    public Future<Collection<Application>> list(final @NullAllowed InetAddress publicAddress) {
        return DEPLOYMENT_RP.submit((Callable)new Callable<Collection<Application>>(){

            @Override
            public Collection<Application> call() throws Exception {
                return WebLogicDeployer.this.config.getRemote().executeAction(new WebLogicRemote.JmxAction<Collection<Application>>(){

                    @Override
                    public Collection<Application> execute(MBeanServerConnection connection) throws Exception {
                        ObjectName[] beans;
                        ArrayList<Application> result = new ArrayList<Application>();
                        ObjectName service = new ObjectName("com.bea:Name=DomainRuntimeService,Type=weblogic.management.mbeanservers.domainruntime.DomainRuntimeServiceMBean");
                        ObjectName domainConfig = (ObjectName)connection.getAttribute(service, "DomainConfiguration");
                        for (ObjectName bean : beans = (ObjectName[])connection.getAttribute(domainConfig, "AppDeployments")) {
                            ObjectName[] runtimes;
                            ObjectName appRuntime;
                            String server;
                            ObjectName serverRuntime;
                            String name = (String)connection.getAttribute(bean, "Name");
                            String type = (String)connection.getAttribute(bean, "Type");
                            if (!"AppDeployment".equals(type)) continue;
                            String moduleType = (String)connection.getAttribute(bean, "ModuleType");
                            String contextRoot = null;
                            ObjectName[] targets = (ObjectName[])connection.getAttribute(bean, "Targets");
                            if (targets != null && targets.length > 0 && (serverRuntime = (ObjectName)connection.invoke(service, "lookupServerRuntime", new Object[]{server = (String)connection.getAttribute(targets[0], "Name")}, new String[]{"java.lang.String"})) != null && (appRuntime = (ObjectName)connection.invoke(serverRuntime, "lookupApplicationRuntime", new Object[]{name}, new String[]{"java.lang.String"})) != null && (runtimes = (ObjectName[])connection.getAttribute(appRuntime, "ComponentRuntimes")) != null) {
                                ObjectName runtime;
                                String runtimeType;
                                ObjectName[] arr$ = runtimes;
                                int len$ = arr$.length;
                                for (int i$ = 0; !(i$ >= len$ || "WebAppComponentRuntime".equals(runtimeType = (String)connection.getAttribute(runtime = arr$[i$], "Type")) && (contextRoot = (String)connection.getAttribute(runtime, "ContextRoot")) != null); ++i$) {
                                }
                            }
                            if (contextRoot != null) {
                                URL url = publicAddress != null ? new URL("http://" + publicAddress.getHostAddress() + ":" + WebLogicDeployer.this.config.getPort() + contextRoot) : new URL("http://" + WebLogicDeployer.this.config.getHost() + ":" + WebLogicDeployer.this.config.getPort() + contextRoot);
                                result.add(new Application(name, moduleType, url, contextRoot));
                                continue;
                            }
                            result.add(new Application(name, moduleType, null, null));
                        }
                        return result;
                    }
                }, (Callable<String>)WebLogicDeployer.this.nonProxy);
            }
        });
    }

    @NonNull
    public Future<String> deploy(@NonNull File file, @NullAllowed DeployListener listener, @NullAllowed String name) {
        return this.performDeploy(file, listener, name);
    }

    @NonNull
    public Future<Void> redeploy(@NonNull String name, @NonNull File file, @NullAllowed BatchDeployListener listener) {
        return this.performRedeploy(Collections.singletonList(name), Collections.singletonList(file), listener);
    }

    @NonNull
    public Future<Void> redeploy(@NonNull List<String> names, @NullAllowed BatchDeployListener listener) {
        return this.performRedeploy(names, null, listener);
    }

    @NonNull
    public Future<Void> undeploy(final @NonNull Collection<String> names, final @NullAllowed BatchDeployListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        return DEPLOYMENT_RP.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LastLineProcessor lineProcessor = new LastLineProcessor();
                for (String name : names) {
                    BaseExecutionService service = WebLogicDeployer.this.createService("-undeploy", lineProcessor, new String[]{"-name", name});
                    if (listener != null) {
                        listener.onStepStart(name);
                    }
                    Future result = service.run();
                    try {
                        Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                        if (value != 0) {
                            if (listener != null) {
                                listener.onFail(lineProcessor.getLastLine());
                            }
                            throw new IOException("Command failed: " + lineProcessor.getLastLine());
                        }
                        if (listener == null) continue;
                        listener.onStepFinish(name);
                    }
                    catch (InterruptedException ex) {
                        if (listener != null) {
                            listener.onInterrupted();
                        }
                        result.cancel(true);
                        throw ex;
                    }
                    catch (TimeoutException ex) {
                        if (listener != null) {
                            listener.onTimeout();
                        }
                        result.cancel(true);
                        throw ex;
                    }
                    catch (ExecutionException ex) {
                        if (listener == null) continue;
                        Throwable cause = ex.getCause();
                        if (cause instanceof Exception) {
                            listener.onException((Exception)cause);
                            throw (Exception)cause;
                        }
                        listener.onException(ex);
                        throw ex;
                    }
                }
                if (listener != null) {
                    listener.onFinish();
                }
                return null;
            }
        });
    }

    @NonNull
    public Future<Void> start(final @NonNull Collection<String> names, final @NullAllowed BatchDeployListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        return DEPLOYMENT_RP.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LastLineProcessor lineProcessor = new LastLineProcessor();
                for (String name : names) {
                    BaseExecutionService service = WebLogicDeployer.this.createService("-start", lineProcessor, new String[]{"-name", name});
                    if (listener != null) {
                        listener.onStepStart(name);
                    }
                    Future result = service.run();
                    try {
                        Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                        if (value != 0) {
                            if (listener != null) {
                                listener.onFail(lineProcessor.getLastLine());
                            }
                            throw new IOException("Command failed: " + lineProcessor.getLastLine());
                        }
                        if (listener == null) continue;
                        listener.onStepFinish(name);
                    }
                    catch (InterruptedException ex) {
                        if (listener != null) {
                            listener.onInterrupted();
                        }
                        result.cancel(true);
                        throw ex;
                    }
                    catch (TimeoutException ex) {
                        if (listener != null) {
                            listener.onTimeout();
                        }
                        result.cancel(true);
                        throw ex;
                    }
                    catch (ExecutionException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof Exception) {
                            if (listener != null) {
                                listener.onException((Exception)cause);
                            }
                            throw (Exception)cause;
                        }
                        if (listener != null) {
                            listener.onException(ex);
                        }
                        throw ex;
                    }
                }
                if (listener != null) {
                    listener.onFinish();
                }
                return null;
            }
        });
    }

    @NonNull
    public Future<Void> stop(final @NonNull Collection<String> names, final @NullAllowed BatchDeployListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        return DEPLOYMENT_RP.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LastLineProcessor lineProcessor = new LastLineProcessor();
                for (String name : names) {
                    BaseExecutionService service = WebLogicDeployer.this.createService("-stop", lineProcessor, new String[]{"-name", name});
                    if (listener != null) {
                        listener.onStepStart(name);
                    }
                    Future result = service.run();
                    try {
                        Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                        if (value != 0) {
                            if (listener != null) {
                                listener.onFail(lineProcessor.getLastLine());
                            }
                            throw new IOException("Command failed: " + lineProcessor.getLastLine());
                        }
                        if (listener == null) continue;
                        listener.onStepFinish(name);
                    }
                    catch (InterruptedException ex) {
                        if (listener != null) {
                            listener.onInterrupted();
                        }
                        result.cancel(true);
                        throw ex;
                    }
                    catch (TimeoutException ex) {
                        if (listener != null) {
                            listener.onTimeout();
                        }
                        result.cancel(true);
                        throw ex;
                    }
                    catch (ExecutionException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof Exception) {
                            if (listener != null) {
                                listener.onException((Exception)cause);
                            }
                            throw (Exception)cause;
                        }
                        if (listener != null) {
                            listener.onException(ex);
                        }
                        throw ex;
                    }
                }
                if (listener != null) {
                    listener.onFinish();
                }
                return null;
            }
        });
    }

    private Future<String> performDeploy(final @NonNull File file, final @NullAllowed DeployListener listener, final @NullAllowed String name) {
        if (listener != null) {
            listener.onStart();
        }
        return DEPLOYMENT_RP.submit((Callable)new Callable<String>(){

            @Override
            public String call() throws Exception {
                ArrayList<String> parameters = new ArrayList<String>();
                if (WebLogicDeployer.this.config.isRemote()) {
                    parameters.add("-upload");
                    parameters.add("-remote");
                }
                parameters.add("-name");
                parameters.add(WebLogicDeployer.getName(file, name));
                if (file.isDirectory()) {
                    parameters.add("-nostage");
                }
                parameters.add("-source");
                parameters.add(file.getAbsolutePath());
                LastLineProcessor lineProcessor = new LastLineProcessor();
                BaseExecutionService service = WebLogicDeployer.this.createService("-deploy", lineProcessor, parameters.toArray(new String[parameters.size()]));
                Future result = service.run();
                try {
                    Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                    if (value != 0) {
                        if (listener != null) {
                            listener.onFail(lineProcessor.getLastLine());
                        }
                        throw new IOException("Command failed: " + lineProcessor.getLastLine());
                    }
                    if (listener != null) {
                        listener.onFinish();
                    }
                    if (name != null) {
                        return name;
                    }
                    String name2 = file.getName();
                    int index = name2.lastIndexOf(46);
                    if (file.isFile() && index > 0) {
                        name2 = name2.substring(0, index);
                    }
                    return name2;
                }
                catch (InterruptedException ex) {
                    if (listener != null) {
                        listener.onInterrupted();
                    }
                    result.cancel(true);
                    throw ex;
                }
                catch (TimeoutException ex) {
                    if (listener != null) {
                        listener.onTimeout();
                    }
                    result.cancel(true);
                    throw ex;
                }
                catch (ExecutionException ex) {
                    Throwable cause = ex.getCause();
                    if (cause instanceof Exception) {
                        if (listener != null) {
                            listener.onException((Exception)cause);
                        }
                        throw (Exception)cause;
                    }
                    if (listener != null) {
                        listener.onException(ex);
                    }
                    throw ex;
                }
            }
        });
    }

    private Future<Void> performRedeploy(final @NonNull List<String> names, final @NullAllowed List<File> files, final @NullAllowed BatchDeployListener listener) {
        assert (files == null || files.size() == names.size());
        if (listener != null) {
            listener.onStart();
        }
        return DEPLOYMENT_RP.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LastLineProcessor lineProcessor = new LastLineProcessor();
                int i = 0;
                for (String name : names) {
                    ArrayList<String> parameters = new ArrayList<String>();
                    if (WebLogicDeployer.this.config.isRemote()) {
                        parameters.add("-upload");
                        parameters.add("-remote");
                    }
                    parameters.add("-name");
                    parameters.add(name);
                    if (files != null) {
                        parameters.add("-source");
                        parameters.add(((File)files.get(i++)).getAbsolutePath());
                    }
                    BaseExecutionService service = WebLogicDeployer.this.createService("-redeploy", lineProcessor, parameters.toArray(new String[parameters.size()]));
                    if (listener != null) {
                        listener.onStepStart(name);
                    }
                    Future result = service.run();
                    try {
                        Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                        if (value != 0) {
                            if (listener != null) {
                                listener.onFail(lineProcessor.getLastLine());
                            }
                            throw new IOException("Command failed: " + lineProcessor.getLastLine());
                        }
                        if (listener == null) continue;
                        listener.onStepFinish(name);
                    }
                    catch (InterruptedException ex) {
                        if (listener != null) {
                            listener.onInterrupted();
                        }
                        result.cancel(true);
                        throw ex;
                    }
                    catch (TimeoutException ex) {
                        if (listener != null) {
                            listener.onTimeout();
                        }
                        result.cancel(true);
                        throw ex;
                    }
                    catch (ExecutionException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof Exception) {
                            if (listener != null) {
                                listener.onException((Exception)cause);
                            }
                            throw (Exception)cause;
                        }
                        if (listener != null) {
                            listener.onException(ex);
                        }
                        throw ex;
                    }
                }
                if (listener != null) {
                    listener.onFinish();
                }
                return null;
            }
        });
    }

    public Future<Void> deploy(final @NonNull List<Artifact> artifacts, final @NullAllowed BatchDeployListener listener) {
        if (listener != null) {
            listener.onStart();
        }
        return DEPLOYMENT_RP.submit((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                LastLineProcessor lineProcessor = new LastLineProcessor();
                for (Artifact artifact : artifacts) {
                    ArrayList<String> parameters = new ArrayList<String>();
                    parameters.add("-upload");
                    if (WebLogicDeployer.this.config.isRemote()) {
                        parameters.add("-remote");
                    }
                    String name = WebLogicDeployer.getName(artifact.getFile(), artifact.getName());
                    parameters.add("-name");
                    parameters.add(name);
                    if (artifact.isLibrary()) {
                        parameters.add("-library");
                    }
                    parameters.add(artifact.getFile().getAbsolutePath());
                    BaseExecutionService service = WebLogicDeployer.this.createService("-deploy", lineProcessor, parameters.toArray(new String[parameters.size()]));
                    if (listener != null) {
                        listener.onStepStart(name);
                    }
                    Future result = service.run();
                    try {
                        Integer value = (Integer)result.get(300000L, TimeUnit.MILLISECONDS);
                        if (value != 0) {
                            if (listener != null) {
                                listener.onFail(lineProcessor.getLastLine());
                            }
                            throw new IOException("Command failed: " + lineProcessor.getLastLine());
                        }
                        if (listener == null) continue;
                        listener.onStepFinish(name);
                    }
                    catch (InterruptedException ex) {
                        if (listener != null) {
                            listener.onInterrupted();
                        }
                        result.cancel(true);
                        throw ex;
                    }
                    catch (TimeoutException ex) {
                        if (listener != null) {
                            listener.onTimeout();
                        }
                        result.cancel(true);
                        throw ex;
                    }
                    catch (ExecutionException ex) {
                        Throwable cause = ex.getCause();
                        if (cause instanceof Exception) {
                            if (listener != null) {
                                listener.onException((Exception)cause);
                            }
                            throw (Exception)cause;
                        }
                        if (listener != null) {
                            listener.onException(ex);
                        }
                        throw ex;
                    }
                }
                if (listener != null) {
                    listener.onFinish();
                }
                return null;
            }
        });
    }

    private BaseExecutionService createService(String command, LineProcessor processor, String ... parameters) {
        WebLogicTrustHandler handler;
        ProcessBuilder builder = ProcessBuilder.getLocal();
        builder.setExecutable(this.getJavaBinary());
        builder.setRedirectErrorStream(true);
        ArrayList<String> arguments = new ArrayList<String>();
        Version version = this.config.getDomainVersion();
        if (version == null || !version.isAboveOrEqual(VERSION_10)) {
            arguments.add("-Dsun.lang.ClassLoader.allowArraySyntax=true");
        }
        if (this.config.isRemote()) {
            try {
                String nonProxyHosts;
                SocketAddress addr;
                Proxy first;
                List<Proxy> proxies = ProxySelector.getDefault().select(new URI((this.config.isSecured() ? "https://" : "http://") + this.config.getHost() + ":" + this.config.getPort()));
                if (!proxies.isEmpty() && (first = proxies.get(0)).type() != Proxy.Type.DIRECT && (addr = first.address()) instanceof InetSocketAddress) {
                    InetSocketAddress inet = (InetSocketAddress)addr;
                    if (first.type() == Proxy.Type.HTTP) {
                        arguments.add("-Dhttp.proxyHost=" + inet.getHostString());
                        arguments.add("-Dhttp.proxyPort=" + inet.getPort());
                        arguments.add("-Dhttps.proxyHost=" + inet.getHostString());
                        arguments.add("-Dhttps.proxyPort=" + inet.getPort());
                    } else if (first.type() == Proxy.Type.SOCKS) {
                        arguments.add("-DsocksProxyHost=" + inet.getHostString());
                        arguments.add("-DsocksProxyPort=" + inet.getPort());
                    }
                }
                if ((nonProxyHosts = ProxyUtils.getNonProxyHosts(this.nonProxy)) != null) {
                    arguments.add("-Dhttp.nonProxyHosts=\"" + nonProxyHosts + "\"");
                }
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        if (this.config.isSecured() && (handler = (WebLogicTrustHandler)Lookup.getDefault().lookup(WebLogicTrustHandler.class)) != null) {
            for (Map.Entry<String, String> e : handler.getTrustProperties(this.config).entrySet()) {
                arguments.add("-D" + e.getKey() + "=" + e.getValue());
            }
        }
        arguments.add("-cp");
        arguments.add(this.getClassPath());
        arguments.add("weblogic.Deployer");
        arguments.add("-adminurl");
        arguments.add(this.config.getAdminURL());
        arguments.add("-username");
        arguments.add(this.config.getUsername());
        arguments.add(command);
        arguments.addAll(Arrays.asList(parameters));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Java CL deployer arguments");
            for (String arg : arguments) {
                LOGGER.log(Level.FINE, arg);
            }
        }
        builder.setArguments(arguments);
        final LoggingLineProcessor realProcessor = processor != null || LOGGER.isLoggable(Level.FINEST) ? (processor == null ? new LoggingLineProcessor(Level.FINEST) : (!LOGGER.isLoggable(Level.FINEST) ? processor : LineProcessors.proxy((LineProcessor[])new LineProcessor[]{processor, new LoggingLineProcessor(Level.FINEST)}))) : null;
        BaseExecutionDescriptor descriptor = new BaseExecutionDescriptor().outProcessorFactory(new BaseExecutionDescriptor.InputProcessorFactory(){

            public InputProcessor newInputProcessor() {
                return InputProcessors.bridge((LineProcessor)realProcessor);
            }
        }).inReaderFactory(new BaseExecutionDescriptor.ReaderFactory(){

            public Reader newReader() {
                return new StringReader(WebLogicDeployer.this.config.getPassword() + "\n");
            }
        });
        return BaseExecutionService.newService((Callable)builder, (BaseExecutionDescriptor)descriptor);
    }

    private String getClassPath() {
        File[] files = this.config.getLayout().getClassPath();
        StringBuilder sb = new StringBuilder();
        for (File file : files) {
            sb.append(file.getAbsolutePath()).append(File.pathSeparatorChar);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private String getJavaBinary() {
        if (this.javaBinary != null) {
            return this.javaBinary.getAbsolutePath();
        }
        return BaseUtilities.isWindows() ? "java.exe" : "java";
    }

    private static String getName(File file, String name) {
        String realName = name;
        if (realName == null) {
            int dot;
            realName = file.getName();
            if (!file.isDirectory() && (dot = realName.lastIndexOf(46)) > 0) {
                realName = realName.substring(0, dot);
            }
        }
        return realName;
    }

    private static class LoggingLineProcessor
    implements LineProcessor {
        private final Level level;

        private LoggingLineProcessor(Level level) {
            this.level = level;
        }

        public void processLine(String line) {
            LOGGER.log(this.level, line);
        }

        public void reset() {
        }

        public void close() {
        }
    }

    private static class LastLineProcessor
    implements LineProcessor {
        private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("^\\s+((at)|(\\.\\.\\.)).*$");
        private String last = "";

        private LastLineProcessor() {
        }

        public synchronized void processLine(String line) {
            if (line.length() != 0 && !STACK_TRACE_PATTERN.matcher(line).matches()) {
                this.last = line;
            }
        }

        public synchronized String getLastLine() {
            return this.last;
        }

        public void reset() {
        }

        public void close() {
        }
    }

    public static final class Application {
        private final String name;
        private final String type;
        private final URL url;
        private final String webContext;

        private Application(String id, String type, URL url, String webContext) {
            this.name = id;
            this.type = type;
            this.url = url;
            this.webContext = webContext;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public URL getUrl() {
            return this.url;
        }

        public String getWebContext() {
            return this.webContext;
        }
    }

    public static final class Artifact {
        private final File file;
        private final String name;
        private final boolean library;

        public Artifact(File file, String name, boolean library) {
            this.file = file;
            this.name = name;
            this.library = library;
        }

        public File getFile() {
            return this.file;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLibrary() {
            return this.library;
        }
    }
}

