/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2me.project.Bundle;
import org.netbeans.modules.j2me.project.J2MEProject;
import org.netbeans.modules.j2me.project.api.PropertyEvaluatorProvider;
import org.netbeans.modules.j2me.project.ui.ChooseOtherPlatformPanel;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.ProjectProblemResolver;
import org.netbeans.spi.project.ui.ProjectProblemsProvider;
import org.netbeans.spi.project.ui.support.ProjectProblemsProviderSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

public class J2MEProjectProblems
implements ProjectProblemsProvider,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(J2MEProjectProblems.class.getName());
    private static final RequestProcessor RP = new RequestProcessor(J2MEProjectProblems.class);
    private final ProjectProblemsProviderSupport problemsProviderSupport = new ProjectProblemsProviderSupport((Object)this);
    private final Project prj;
    private final PropertyEvaluator eval;

    public J2MEProjectProblems(Lookup lkp) {
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        this.prj = (Project)lkp.lookup(Project.class);
        Parameters.notNull((CharSequence)"prj", (Object)this.prj);
        PropertyEvaluatorProvider evalProvider = (PropertyEvaluatorProvider)lkp.lookup(PropertyEvaluatorProvider.class);
        Parameters.notNull((CharSequence)"evalProvider", (Object)evalProvider);
        this.eval = evalProvider.getPropertyEvaluator();
        Parameters.notNull((CharSequence)"eval", (Object)this.eval);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.problemsProviderSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.problemsProviderSupport.removePropertyChangeListener(listener);
    }

    public Collection<? extends ProjectProblemsProvider.ProjectProblem> getProblems() {
        String activePlatformId = this.eval.getProperty("platform.active");
        JavaPlatform activePlatform = CommonProjectUtils.getActivePlatform((String)activePlatformId, (String)"j2me");
        if (activePlatform != null && activePlatform instanceof J2MEPlatform && ((J2MEPlatform)activePlatform).isValid()) {
            return Collections.emptySet();
        }
        return this.problemsProviderSupport.getProblems(new ProjectProblemsProviderSupport.ProblemsCollector(){

            public Collection<? extends ProjectProblemsProvider.ProjectProblem> collectProblems() {
                Collection currentProblems = (Collection)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Collection<? extends ProjectProblemsProvider.ProjectProblem>>(){

                    public Collection<? extends ProjectProblemsProvider.ProjectProblem> run() {
                        return Collections.singleton(ProjectProblemsProvider.ProjectProblem.createError((String)Bundle.LBL_InvalidPlatform(), (String)Bundle.LBL_InvalidPlatformDesc(), (ProjectProblemResolver)new J2MEPlatformResolver(J2MEProjectProblems.this.prj, "j2me", J2MEProjectProblems.this.problemsProviderSupport)));
                    }
                });
                return currentProblems;
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName == null || "platform.active".equals(propName)) {
            this.problemsProviderSupport.fireProblemsChange();
        }
    }

    private static final class Done
    implements Future<ProjectProblemsProvider.Result> {
        private final ProjectProblemsProvider.Result result;

        Done(@NonNull ProjectProblemsProvider.Result result) {
            Parameters.notNull((CharSequence)"result", (Object)result);
            this.result = result;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public ProjectProblemsProvider.Result get() throws InterruptedException, ExecutionException {
            return this.result;
        }

        @Override
        public ProjectProblemsProvider.Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }

    private static class J2MEPlatformResolver
    implements ProjectProblemResolver {
        private final Project project;
        private final String type;
        private final ProjectProblemsProviderSupport support;

        J2MEPlatformResolver(@NonNull Project project, @NonNull String type, @NonNull ProjectProblemsProviderSupport support) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"type", (Object)type);
            Parameters.notNull((CharSequence)"support", (Object)support);
            this.project = project;
            this.type = type;
            this.support = support;
        }

        public Future<ProjectProblemsProvider.Result> resolve() {
            JavaPlatform jp;
            ChooseOtherPlatformPanel choosePlatform = new ChooseOtherPlatformPanel(this.type);
            DialogDescriptor dd = new DialogDescriptor((Object)choosePlatform, Bundle.LBL_ResolveME_SDK(ProjectUtils.getInformation((Project)this.project).getDisplayName()));
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == DialogDescriptor.OK_OPTION && (jp = choosePlatform.getSelectedPlatform()) != null) {
                Callable<ProjectProblemsProvider.Result> resultFnc = new Callable<ProjectProblemsProvider.Result>(){

                    @Override
                    public ProjectProblemsProvider.Result call() throws Exception {
                        try {
                            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                                public Void run() throws IOException {
                                    AntProjectHelper helper = ((J2MEProject)J2MEPlatformResolver.this.project).getHelper();
                                    EditableProperties ep = helper.getProperties("nbproject/project.properties");
                                    ep.setProperty("platform.active", (String)jp.getProperties().get("platform.ant.name"));
                                    helper.putProperties("nbproject/project.properties", ep);
                                    try {
                                        ProjectManager.getDefault().saveProject(J2MEPlatformResolver.this.project);
                                    }
                                    catch (IOException e) {
                                        Exceptions.printStackTrace((Throwable)e);
                                    }
                                    return null;
                                }
                            });
                        }
                        catch (MutexException e) {
                            throw (IOException)e.getCause();
                        }
                        LOGGER.log(Level.INFO, "Set platform.active to platform {0}", jp);
                        J2MEPlatformResolver.this.support.fireProblemsChange();
                        return ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.RESOLVED);
                    }
                };
                return RP.submit((Callable)resultFnc);
            }
            return new Done(ProjectProblemsProvider.Result.create((ProjectProblemsProvider.Status)ProjectProblemsProvider.Status.UNRESOLVED));
        }

        public boolean equals(Object obj) {
            return obj instanceof J2MEPlatformResolver;
        }

        public int hashCode() {
            return 29;
        }
    }
}

