/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.TreeMap;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2me.project.J2MEProject;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.ProjectConfigurationProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.Pair;
import org.openide.util.Parameters;

public final class ConfigurationSupport {
    private static final String CFG_PATHS = "nbproject/configs/";
    private static final String CFG_PRIVATE_PATHS = "nbproject/private/configs/";

    private ConfigurationSupport() {
        throw new IllegalStateException("No instance allowed");
    }

    @NonNull
    public static Collection<? extends ProjectConfiguration> getConfigurations(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        ProjectConfigurationProvider pcp = (ProjectConfigurationProvider)project.getLookup().lookup(ProjectConfigurationProvider.class);
        return pcp == null ? Collections.emptySet() : pcp.getConfigurations();
    }

    @CheckForNull
    public static ProjectConfiguration getActiveConfiguration(@NonNull Project project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        ProjectConfigurationProvider pcp = (ProjectConfigurationProvider)project.getLookup().lookup(ProjectConfigurationProvider.class);
        return pcp == null ? null : pcp.getActiveConfiguration();
    }

    @NonNull
    public static EditableProperties getProperties(final @NonNull Project project, final @NullAllowed ProjectConfiguration cfg, final boolean shared) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        final J2MEProject j2meProject = (J2MEProject)project.getLookup().lookup(J2MEProject.class);
        if (j2meProject == null) {
            throw new IllegalArgumentException(String.format("The project: %s (%s) is not a J2ME Embedded project", ProjectUtils.getInformation((Project)project).getDisplayName(), FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory())));
        }
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            public EditableProperties run() {
                String path = ConfigurationSupport.getPath(project.getProjectDirectory(), cfg, shared);
                return j2meProject.getUpdateHelper().getProperties(path);
            }
        });
    }

    public static void putProperties(@NonNull Project project, @NullAllowed ProjectConfiguration cfg, boolean shared, @NonNull EditableProperties ep) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"ep", (Object)ep);
        J2MEProject j2meProject = (J2MEProject)project.getLookup().lookup(J2MEProject.class);
        if (j2meProject == null) {
            throw new IllegalArgumentException(String.format("The project: %s (%s) is not a J2ME Embedded project", ProjectUtils.getInformation((Project)project).getDisplayName(), FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory())));
        }
        String path = ConfigurationSupport.getPath(project.getProjectDirectory(), cfg, shared);
        j2meProject.getUpdateHelper().putProperties(path, ep);
    }

    @NonNull
    private static String getPath(@NonNull FileObject root, @NullAllowed ProjectConfiguration cfg, boolean shared) {
        Pair paths;
        Parameters.notNull((CharSequence)"root", (Object)root);
        if (cfg == null) {
            return shared ? "nbproject/project.properties" : "nbproject/private/private.properties";
        }
        TreeMap<String, Pair> nameToPaths = new TreeMap<String, Pair>();
        FileObject cfgFolder = root.getFileObject(CFG_PATHS);
        if (cfgFolder != null) {
            for (FileObject fo : cfgFolder.getChildren()) {
                if (!"properties".equals(fo.getExt())) continue;
                Properties p = new Properties();
                try (InputStream in = fo.getInputStream();){
                    p.load(in);
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
                String name = p.getProperty("$label");
                if (name == null) {
                    name = fo.getName();
                }
                nameToPaths.put(name, Pair.of((Object)(CFG_PATHS + fo.getNameExt()), (Object)(CFG_PRIVATE_PATHS + fo.getNameExt())));
            }
        }
        return (paths = (Pair)nameToPaths.get(cfg.getDisplayName())) == null ? (shared ? "nbproject/project.properties" : "nbproject/private/private.properties") : (shared ? (String)paths.first() : (String)paths.second());
    }
}

