/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui.customizer;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.netbeans.modules.j2me.project.ui.customizer.AddPermissionPanel;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.j2me.project.ui.customizer.PermissionsProvider;
import org.netbeans.modules.mobility.cldcplatform.J2MEPlatform;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class J2MEAPIPermissionsPanel
extends JPanel {
    protected JTable table;
    private final StorableTableModel tableModel;
    private final J2MEProjectProperties uiProperties;
    private final ListSelectionListener listSelectionListener;
    private JButton bAdd;
    private JButton bEdit;
    private JButton bRemove;
    private JLabel lTable;
    private JScrollPane scrollPane;

    public J2MEAPIPermissionsPanel(J2MEProjectProperties uiProperties) {
        this.uiProperties = uiProperties;
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(J2MEAPIPermissionsPanel.class, (String)"ACSN_Perm"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(J2MEAPIPermissionsPanel.class, (String)"ACSD_Perm"));
        this.tableModel = this.uiProperties.API_PERMISSIONS_TABLE_MODEL;
        this.table = new JTable(this.tableModel);
        this.scrollPane.setViewportView(this.table);
        this.table.setSelectionMode(0);
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent lse) {
                J2MEAPIPermissionsPanel.this.bRemove.setEnabled(J2MEAPIPermissionsPanel.this.table.isEnabled() && J2MEAPIPermissionsPanel.this.table.getSelectedRow() >= 0);
                J2MEAPIPermissionsPanel.this.bEdit.setEnabled(J2MEAPIPermissionsPanel.this.table.isEnabled() && J2MEAPIPermissionsPanel.this.table.getSelectedRow() >= 0);
            }
        };
        this.table.getSelectionModel().addListSelectionListener(this.listSelectionListener);
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    J2MEAPIPermissionsPanel.this.bEditActionPerformed(null);
                }
            }
        });
        TableColumn col0 = this.table.getColumnModel().getColumn(0);
        TableColumn col1 = this.table.getColumnModel().getColumn(1);
        col0.setResizable(true);
        col0.setPreferredWidth(300);
        col1.setResizable(true);
        col1.setPreferredWidth(80);
        this.postInitComponents();
    }

    private void postInitComponents() {
        String[] propertyNames = this.uiProperties.API_PERMISSIONS_PROPERTY_NAMES;
        String[] values = new String[propertyNames.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.uiProperties.getEvaluator().getProperty(propertyNames[i]);
        }
        this.tableModel.setDataDelegates(values);
        this.table.setBackground(UIManager.getDefaults().getColor("Table.background"));
        this.listSelectionListener.valueChanged(null);
    }

    private void initComponents() {
        this.lTable = new JLabel();
        this.scrollPane = new JScrollPane();
        this.bAdd = new JButton();
        this.bRemove = new JButton();
        this.bEdit = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.lTable, (String)NbBundle.getMessage(J2MEAPIPermissionsPanel.class, (String)"J2MEAPIPermissionsPanel.lTable.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 0, 6);
        this.add((Component)this.lTable, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 8, 8, 0);
        this.add((Component)this.scrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bAdd, (String)NbBundle.getMessage(J2MEAPIPermissionsPanel.class, (String)"J2MEAPIPermissionsPanel.bAdd.text"));
        this.bAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEAPIPermissionsPanel.this.bAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(6, 11, 5, 8);
        this.add((Component)this.bAdd, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bRemove, (String)NbBundle.getMessage(J2MEAPIPermissionsPanel.class, (String)"J2MEAPIPermissionsPanel.bRemove.text"));
        this.bRemove.setEnabled(false);
        this.bRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEAPIPermissionsPanel.this.bRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 11, 5, 8);
        this.add((Component)this.bRemove, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.bEdit, (String)MessageFormat.format(ResourceBundle.getBundle("org/netbeans/modules/j2me/project/ui/customizer/Bundle").getString("J2MEAPIPermissionsPanel.bEdit.text"), new Object[0]));
        this.bEdit.setEnabled(false);
        this.bEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                J2MEAPIPermissionsPanel.this.bEditActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 11, 5, 8);
        this.add((Component)this.bEdit, gridBagConstraints);
    }

    private void bAddActionPerformed(ActionEvent evt) {
        J2MEPlatform selectedPlatform = (J2MEPlatform)this.uiProperties.J2ME_PLATFORM_MODEL.getSelectedItem();
        if (selectedPlatform != null) {
            File libsDir = new File(selectedPlatform.getHomePath() + File.separator + "lib");
            final AddPermissionPanel add = new AddPermissionPanel(null, new PermissionsProvider(libsDir), this.tableModel.getKeys(), null);
            DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(J2MEAPIPermissionsPanel.class, (String)"TITLE_AddAPI"), true, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PermissionsProvider.PermissionDefinition pd;
                    if (NotifyDescriptor.OK_OPTION.equals(e.getSource()) && (pd = add.getPermission()) != null) {
                        int row = J2MEAPIPermissionsPanel.this.tableModel.addRow(pd.toString(), pd.isPermissionClass());
                        J2MEAPIPermissionsPanel.this.table.getSelectionModel().setSelectionInterval(row, row);
                    }
                }
            });
            add.setDialogDescriptor(dd);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
        }
    }

    private void bRemoveActionPerformed(ActionEvent evt) {
        int i = this.table.getSelectedRow();
        if (i < 0) {
            return;
        }
        this.tableModel.removeRow(i);
        int max = this.tableModel.getRowCount();
        if (max <= 0) {
            this.table.getSelectionModel().clearSelection();
        } else if (i < max) {
            this.table.getSelectionModel().setSelectionInterval(i, i);
        } else {
            this.table.getSelectionModel().setSelectionInterval(max - 1, max - 1);
        }
    }

    private void bEditActionPerformed(ActionEvent evt) {
        J2MEPlatform selectedPlatform = (J2MEPlatform)this.uiProperties.J2ME_PLATFORM_MODEL.getSelectedItem();
        final int selectedRow = this.table.getSelectedRow();
        StorableTableModel.Item selectedPermission = (StorableTableModel.Item)this.tableModel.getValueAt(selectedRow, 0);
        if (selectedPlatform != null) {
            File libsDir = new File(selectedPlatform.getHomePath() + File.separator + "lib");
            final AddPermissionPanel add = new AddPermissionPanel(null, new PermissionsProvider(libsDir), this.tableModel.getKeys(), selectedPermission.getName());
            DialogDescriptor dd = new DialogDescriptor((Object)add, NbBundle.getMessage(J2MEAPIPermissionsPanel.class, (String)"TITLE_EditAPI"), true, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PermissionsProvider.PermissionDefinition pd;
                    if (NotifyDescriptor.OK_OPTION.equals(e.getSource()) && (pd = add.getPermission()) != null) {
                        J2MEAPIPermissionsPanel.this.tableModel.updateRow(selectedRow, pd.toString(), pd.isPermissionClass());
                        J2MEAPIPermissionsPanel.this.table.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                    }
                }
            });
            add.setDialogDescriptor(dd);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
        }
    }

    static class StorableTableModel
    extends AbstractTableModel {
        private HashMap<String, String> map = new HashMap();
        private HashMap<String, String> mapClassPerm = new LinkedHashMap<String, String>();
        private final ArrayList<Item> items = new ArrayList();
        private static final long serialVersionUID = -6523408202243150812L;
        private final J2MEProjectProperties uiProperties;
        private boolean dataDelegatesWereSet = false;

        public StorableTableModel(J2MEProjectProperties uiProperties) {
            this.uiProperties = uiProperties;
        }

        public HashSet<String> getKeys() {
            HashSet<String> set = new HashSet<String>();
            for (int a = 0; a < this.items.size(); ++a) {
                set.add(this.items.get(a).getName());
            }
            return set;
        }

        @Override
        public int getRowCount() {
            return this.items.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return NbBundle.getMessage(J2MEAPIPermissionsPanel.class, (String)"LBL_Perm_Column_API");
                }
                case 1: {
                    return NbBundle.getMessage(J2MEAPIPermissionsPanel.class, (String)"LBL_Perm_Column_Required");
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
            }
            return null;
        }

        public synchronized Object[] getDataDelegates() {
            if (!this.dataDelegatesWereSet) {
                String[] propertyNames = this.uiProperties.API_PERMISSIONS_PROPERTY_NAMES;
                String[] values = new String[propertyNames.length];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = this.uiProperties.getEvaluator().getProperty(propertyNames[i]);
                }
                this.setDataDelegates(values);
            }
            this.updateMapFromItems();
            return new Object[]{this.map, this.mapClassPerm};
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            assert (rowIndex < this.items.size());
            switch (columnIndex) {
                case 0: {
                    return this.items.get(rowIndex);
                }
                case 1: {
                    return this.items.get(rowIndex).isRequired();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            assert (columnIndex == 1 && value instanceof Boolean);
            this.items.get(rowIndex).setRequired((Boolean)value);
            this.fireTableRowsUpdated(rowIndex, rowIndex);
        }

        public synchronized void setDataDelegates(String[] data) {
            assert (data != null);
            this.map = data[0] == null ? new HashMap() : (HashMap)this.uiProperties.decode(data[0]);
            this.mapClassPerm = data[1] == null ? new LinkedHashMap<String, String>() : (HashMap)this.uiProperties.decode(data[1]);
            this.updateItemsFromMap();
            this.fireTableDataChanged();
            this.dataDelegatesWereSet = true;
        }

        public void updateItemsFromMap() {
            StringTokenizer tokens;
            this.items.clear();
            String packaging = !this.uiProperties.LIBLET_PACKAGING ? "MIDlet" : "LIBlet";
            String perms = this.map.get(packaging + "-Permissions");
            if (perms != null) {
                tokens = new StringTokenizer(perms, ",");
                while (tokens.hasMoreTokens()) {
                    this.items.add(new Item(tokens.nextToken().trim(), true, false));
                }
            }
            if ((perms = this.map.get(packaging + "-Permissions-Opt")) != null) {
                tokens = new StringTokenizer(perms, ",");
                while (tokens.hasMoreTokens()) {
                    this.items.add(new Item(tokens.nextToken().trim(), false, false));
                }
            }
            int i = 1;
            while ((perms = this.mapClassPerm.get(packaging + "-Permission-" + i)) != null) {
                this.items.add(new Item(perms.trim(), true, true));
                ++i;
            }
            i = 1;
            while ((perms = this.mapClassPerm.get(packaging + "-Permission-Opt-" + i)) != null) {
                this.items.add(new Item(perms.trim(), false, true));
                ++i;
            }
        }

        public void updateMapFromItems() {
            ArrayList<String> reqClass = new ArrayList<String>();
            ArrayList<String> optClass = new ArrayList<String>();
            ArrayList<String> reqNotClass = new ArrayList<String>();
            ArrayList<String> optNotClass = new ArrayList<String>();
            for (int a = 0; a < this.items.size(); ++a) {
                Item i = this.items.get(a);
                if (i.isPermissionClass()) {
                    if (i.isRequired()) {
                        reqClass.add(i.getName());
                        continue;
                    }
                    optClass.add(i.getName());
                    continue;
                }
                if (i.isRequired()) {
                    reqNotClass.add(i.getName());
                    continue;
                }
                optNotClass.add(i.getName());
            }
            String packaging = !this.uiProperties.LIBLET_PACKAGING ? "MIDlet" : "LIBlet";
            this.map = new HashMap();
            if (!reqNotClass.isEmpty()) {
                this.map.put(packaging + "-Permissions", this.commaSeparatedList(reqNotClass));
            }
            if (!optNotClass.isEmpty()) {
                this.map.put(packaging + "-Permissions-Opt", this.commaSeparatedList(optNotClass));
            }
            this.mapClassPerm = new LinkedHashMap<String, String>();
            if (!reqClass.isEmpty()) {
                for (int i = 0; i < reqClass.size(); ++i) {
                    this.mapClassPerm.put(packaging + "-Permission-" + (i + 1), (String)reqClass.get(i));
                }
            }
            if (!optClass.isEmpty()) {
                for (int i = 0; i < optClass.size(); ++i) {
                    this.mapClassPerm.put(packaging + "-Permission-Opt-" + (i + 1), (String)optClass.get(i));
                }
            }
        }

        public String commaSeparatedList(ArrayList<String> list) {
            StringBuffer sb = new StringBuffer();
            boolean first = true;
            if (list != null) {
                for (int a = 0; a < list.size(); ++a) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(list.get(a));
                }
            }
            return sb.toString();
        }

        public int addRow(String name, boolean permissionClass) {
            int row = this.items.size();
            this.items.add(new Item(name, true, permissionClass));
            this.fireTableRowsInserted(row, row);
            return row;
        }

        public void updateRow(int row, String name, boolean permissionClass) {
            assert (row < this.items.size());
            this.items.get(row).setName(name);
            this.items.get(row).setPermissionClass(permissionClass);
            this.fireTableRowsUpdated(row, row);
        }

        public void removeRow(int row) {
            assert (row < this.items.size());
            this.items.remove(row);
            this.fireTableRowsDeleted(row, this.items.size() + 1);
        }

        static class Item {
            private String name;
            private boolean required;
            private boolean permissionClass;

            public Item(String name, boolean required, boolean permissionClass) {
                this.name = name;
                this.required = required;
                this.permissionClass = permissionClass;
            }

            public String getName() {
                return this.name;
            }

            public void setName(String name) {
                this.name = name;
            }

            public boolean isRequired() {
                return this.required;
            }

            public void setRequired(boolean required) {
                this.required = required;
            }

            public boolean isPermissionClass() {
                return this.permissionClass;
            }

            public void setPermissionClass(boolean permissionClass) {
                this.permissionClass = permissionClass;
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

