/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.utils.CndFileVisibilityQuery;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.DriverFactory;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompileLineStorage;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.CompilerSettings;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.FSImpl;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatableImpl;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.RelocatablePathMapper;
import org.netbeans.modules.cnd.dwarfdump.source.Artifacts;
import org.netbeans.modules.cnd.dwarfdump.source.CompileLineOrigin;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.MIMESupport;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class MakeLogReader {
    private String workingDir;
    private String guessWorkingDir;
    private String baseWorkingDir;
    private final String root;
    private final FileObject logFileObject;
    private List<SourceFileProperties> result;
    private List<String> buildArtifacts;
    private final PathMap pathMapper;
    private final ProjectProxy project;
    private final CompilerSettings compilerSettings;
    private final RelocatablePathMapper localMapper;
    private final FileSystem fileSystem;
    private final RelocatablePathMapper.FS fs;
    private final Map<String, String> alreadyConverted = new HashMap<String, String>();
    private final Set<String> C_NAMES;
    private final Set<String> CPP_NAMES;
    private final Set<String> FORTRAN_NAMES;
    private boolean isWindows = false;
    private Interrupter isStoped;
    private final ArrayList<List<String>> makeStack = new ArrayList();
    private static final String CURRENT_DIRECTORY = "Current working directory";
    private static final String ENTERING_DIRECTORY = "Entering directory";
    private static final String LEAVING_DIRECTORY = "Leaving directory";
    private static final Pattern MAKE_DIRECTORY = Pattern.compile(".*make(?:\\.exe)?(?:\\[([0-9]+)\\])?: .*`([^']*)'$");
    private boolean isEntered;
    private final Stack<Integer> relativesLevel = new Stack();
    private final Stack<String> relativesTo = new Stack();
    private static final String LABEL_CD = "cd ";
    private static final String MAKE_DELIMITER = ";";
    private static final String PKG_CONFIG_PATTERN = "pkg-config ";
    private static final String ECHO_PATTERN = "echo ";
    private static final String CYGPATH_PATTERN = "cygpath ";
    private HashSet<String> subFolders;
    private Map<String, List<String>> findBase;

    public MakeLogReader(FileObject logFileObject, String root, ProjectProxy project, RelocatablePathMapper relocatablePathMapper, FileSystem fileSystem) {
        this.root = root.length() > 0 ? CndFileUtils.normalizeAbsolutePath((FileSystem)fileSystem, (String)root) : root;
        this.logFileObject = logFileObject;
        this.project = project;
        this.pathMapper = this.getPathMapper(project);
        this.compilerSettings = new CompilerSettings(project);
        this.localMapper = relocatablePathMapper;
        this.fileSystem = fileSystem;
        this.fs = new FSImpl(fileSystem);
        this.C_NAMES = DiscoveryUtils.getCompilerNames((ProjectProxy)project, (PredefinedToolKind)PredefinedToolKind.CCompiler);
        this.CPP_NAMES = DiscoveryUtils.getCompilerNames((ProjectProxy)project, (PredefinedToolKind)PredefinedToolKind.CCCompiler);
        this.FORTRAN_NAMES = DiscoveryUtils.getCompilerNames((ProjectProxy)project, (PredefinedToolKind)PredefinedToolKind.FortranCompiler);
    }

    private String convertPath(String path) {
        if (this.isPathAbsolute(path)) {
            String local;
            String originalPath = path;
            String converted = this.alreadyConverted.get(path);
            if (converted != null) {
                return converted;
            }
            if (this.pathMapper != null && (local = this.pathMapper.getLocalPath(path)) != null) {
                path = local;
            }
            if (this.localMapper != null && this.fileSystem != null) {
                FileObject fo = this.fileSystem.findResource(path);
                if (fo == null || !fo.isValid()) {
                    RelocatablePathMapper.ResolvedPath resolvedPath = this.localMapper.getPath(path);
                    if (resolvedPath == null) {
                        if (this.root != null && this.localMapper.discover(this.fs, this.root, path) && (fo = this.fileSystem.findResource((resolvedPath = this.localMapper.getPath(path)).getPath())) != null && fo.isValid()) {
                            path = fo.getPath();
                        }
                    } else {
                        fo = this.fileSystem.findResource(resolvedPath.getPath());
                        if (fo != null && fo.isValid()) {
                            path = fo.getPath();
                        }
                    }
                } else {
                    RelocatablePathMapper.ResolvedPath resolvedPath = this.localMapper.getPath(fo.getPath());
                    if (resolvedPath == null) {
                        FSImpl fs;
                        if (this.root != null && this.localMapper.discover(fs = new FSImpl(this.fileSystem), this.root, path) && (fo = this.fileSystem.findResource((resolvedPath = this.localMapper.getPath(path)).getPath())) != null && fo.isValid()) {
                            path = fo.getPath();
                        }
                    } else {
                        path = fo.getPath();
                        fo = this.fileSystem.findResource(resolvedPath.getPath());
                        if (fo != null && fo.isValid()) {
                            path = fo.getPath();
                        }
                    }
                }
            }
            this.alreadyConverted.put(originalPath, path);
        }
        return path;
    }

    private PathMap getPathMapper(ProjectProxy project) {
        Project p;
        if (project != null && (p = project.getProject()) != null) {
            return RemoteSyncSupport.getPathMap((Lookup.Provider)p);
        }
        return null;
    }

    private ExecutionEnvironment getExecutionEnvironment(MakeConfiguration conf) {
        ExecutionEnvironment env = null;
        if (conf != null) {
            env = conf.getDevelopmentHost().getExecutionEnvironment();
        }
        if (env == null) {
            env = ExecutionEnvironmentFactory.getLocal();
        }
        return env;
    }

    private MakeConfiguration getConfiguration(ProjectProxy project) {
        MakeConfigurationDescriptor confDescr;
        ConfigurationDescriptorProvider pdp;
        if (project != null && project.getProject() != null && (pdp = (ConfigurationDescriptorProvider)project.getProject().getLookup().lookup(ConfigurationDescriptorProvider.class)) != null && pdp.gotDescriptor() && (confDescr = pdp.getConfigurationDescriptor()) != null) {
            return confDescr.getActiveConfiguration();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runImpl(Progress progress, CompileLineStorage storage) {
        if (DwarfSource.LOG.isLoggable(Level.FINE)) {
            DwarfSource.LOG.log(Level.FINE, "LogReader is run for {0}", this.logFileObject);
        }
        Pattern pattern = Pattern.compile(";|\\|\\||&&");
        this.result = new ArrayList<SourceFileProperties>();
        this.buildArtifacts = new ArrayList<String>();
        if (this.logFileObject != null && this.logFileObject.isValid() && this.logFileObject.canRead()) {
            try {
                MakeConfiguration conf = this.getConfiguration(this.project);
                ExecutionEnvironment executionEnvironment = this.getExecutionEnvironment(conf);
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
                    if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS) {
                        this.isWindows = true;
                    }
                }
                catch (ConnectionManager.CancellationException ex) {
                    ex.printStackTrace(System.err);
                }
                PkgConfigManager.PkgConfig pkgConfig = PkgConfigManager.getDefault().getPkgConfig(executionEnvironment);
                BufferedReader in = new BufferedReader(new InputStreamReader(this.logFileObject.getInputStream()));
                long length = this.logFileObject.getSize();
                long read = 0L;
                int done = 0;
                if (length <= 0L) {
                    progress = null;
                }
                if (progress != null) {
                    progress.start(100);
                }
                int nFoundFiles = 0;
                try {
                    while (!this.isStoped.cancelled()) {
                        String oneMoreLine;
                        String line = in.readLine();
                        if (line == null) {
                            break;
                        }
                        read += (long)(line.length() + 1);
                        line = line.trim();
                        while (line.endsWith("\\") && (oneMoreLine = in.readLine()) != null) {
                            line = line.substring(0, line.length() - 1) + " " + oneMoreLine.trim();
                        }
                        line = MakeLogReader.trimBackApostropheCalls(line, pkgConfig);
                        String[] cmds = pattern.split(line);
                        for (int i = 0; i < cmds.length; ++i) {
                            if (!this.parseLine(cmds[i].trim(), storage)) continue;
                            ++nFoundFiles;
                        }
                        if (read * 100L / length <= (long)done || done >= 100) continue;
                        ++done;
                        if (progress == null) continue;
                        progress.increment(null);
                    }
                }
                finally {
                    if (progress != null) {
                        progress.done();
                    }
                }
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "Files found: {0}", nFoundFiles);
                    DwarfSource.LOG.log(Level.FINE, "Files included in result: {0}", this.result.size());
                }
                in.close();
            }
            catch (IOException ex) {
                DwarfSource.LOG.log(Level.INFO, "Cannot read file " + this.logFileObject, ex);
            }
        }
    }

    public List<SourceFileProperties> getResults(Progress progress, Interrupter isStoped, CompileLineStorage storage) {
        if (this.result == null) {
            this.run(isStoped, progress, storage);
        }
        return this.result;
    }

    public List<String> getArtifacts(Progress progress, Interrupter isStoped, CompileLineStorage storage) {
        if (this.buildArtifacts == null) {
            this.run(isStoped, progress, storage);
        }
        return this.buildArtifacts;
    }

    private void run(Interrupter isStoped, Progress progress, CompileLineStorage storage) {
        this.isStoped = isStoped;
        this.setWorkingDir(this.root);
        this.runImpl(progress, storage);
        if (this.subFolders != null) {
            this.subFolders.clear();
            this.subFolders = null;
            this.findBase.clear();
            this.findBase = null;
        }
        this.isStoped = null;
    }

    private int getMakeLevel(String line) {
        int i2;
        int i1 = line.indexOf(91);
        if (i1 > 0 && (i2 = line.indexOf(93)) > i1) {
            String s = line.substring(i1 + 1, i2);
            try {
                int res = Integer.parseInt(s);
                return res;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return -1;
    }

    private void enterMakeStack(String dir, int level) {
        if (level < 0) {
            return;
        }
        for (int i = this.makeStack.size(); i <= level; ++i) {
            this.makeStack.add(new ArrayList());
        }
        List<String> list = this.makeStack.get(level);
        list.add(dir);
    }

    private boolean leaveMakeStack(String dir, int level) {
        if (level < 0) {
            return false;
        }
        if (this.makeStack.size() <= level) {
            return false;
        }
        List<String> list = this.makeStack.get(level);
        for (String s : list) {
            if (!s.equals(dir)) continue;
            list.remove(s);
            return true;
        }
        return false;
    }

    private List<String> getMakeTop(int level) {
        ArrayList<String> res = new ArrayList<String>();
        for (int i = Math.min(this.makeStack.size(), level - 1); i >= 0; --i) {
            List<String> list = this.makeStack.get(i);
            if (list.size() <= 0) continue;
            if (res.isEmpty()) {
                res.addAll(list);
                continue;
            }
            if (list.size() <= 1) continue;
            res.addAll(list);
        }
        return res;
    }

    private void popPath() {
        if (this.relativesTo.size() > 1) {
            this.relativesTo.pop();
        }
    }

    private String peekPath() {
        if (this.relativesTo.size() > 1) {
            return this.relativesTo.peek();
        }
        return this.root;
    }

    private void popLevel() {
        if (this.relativesLevel.size() > 1) {
            this.relativesLevel.pop();
        }
    }

    private Integer peekLevel() {
        if (this.relativesLevel.size() > 1) {
            return this.relativesLevel.peek();
        }
        return 0;
    }

    private String convertWindowsRelativePath(String path) {
        if (Utilities.isWindows() && (path.startsWith("/") || path.startsWith("\\"))) {
            if (path.length() > 3 && (path.charAt(2) == '/' || path.charAt(2) == '\\') && Character.isLetter(path.charAt(1))) {
                path = "" + path.charAt(1) + ":" + path.substring(2);
            } else if (path.startsWith("/cygdrive/")) {
                path = path.substring("/cygdrive/".length());
                path = "" + path.charAt(0) + ':' + path.substring(1);
            } else if (this.root.length() > 1 && this.root.charAt(1) == ':') {
                path = this.root.substring(0, 2) + path;
            }
        }
        return path;
    }

    private boolean checkDirectoryChange(String line) {
        String d;
        String dir;
        Matcher m;
        boolean found;
        String workDir = null;
        String message = null;
        if (line.startsWith(CURRENT_DIRECTORY)) {
            workDir = this.convertPath(line.substring(CURRENT_DIRECTORY.length() + 1).trim());
            workDir = this.convertWindowsRelativePath(workDir);
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                message = "**>> by [Current working directory] ";
            }
        } else if (line.contains(ENTERING_DIRECTORY)) {
            String dirMessage = line.substring(line.indexOf(ENTERING_DIRECTORY) + ENTERING_DIRECTORY.length() + 1).trim();
            workDir = this.convertPath(dirMessage.replaceAll("`|'|\"", ""));
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                message = "**>> by [Entering directory] ";
            }
            this.baseWorkingDir = workDir = this.convertWindowsRelativePath(workDir);
            this.enterMakeStack(workDir, this.getMakeLevel(line));
        } else if (line.contains(LEAVING_DIRECTORY)) {
            List<String> paths;
            int level;
            String dirMessage = line.substring(line.indexOf(LEAVING_DIRECTORY) + LEAVING_DIRECTORY.length() + 1).trim();
            workDir = this.convertPath(dirMessage.replaceAll("`|'|\"", ""));
            workDir = this.convertWindowsRelativePath(workDir);
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                message = "**>> by [Leaving directory] ";
            }
            if (this.leaveMakeStack(workDir, level = this.getMakeLevel(line)) && (paths = this.getMakeTop(level)).size() == 1) {
                this.baseWorkingDir = paths.get(0);
            }
        } else if (line.startsWith(LABEL_CD)) {
            int end = line.indexOf(MAKE_DELIMITER);
            workDir = this.convertPath((end == -1 ? line : line.substring(0, end)).substring(LABEL_CD.length()).trim());
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                message = "**>> by [ cd ] ";
            }
            if (workDir.startsWith("/")) {
                this.baseWorkingDir = workDir = this.convertWindowsRelativePath(workDir);
            }
        } else if (line.startsWith("/") && !line.contains(" ")) {
            workDir = this.convertPath(line.trim());
            workDir = this.convertWindowsRelativePath(workDir);
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                message = "**>> by [just path string] ";
            }
        } else if (line.contains("make") && line.length() < 2000 && (found = (m = MAKE_DIRECTORY.matcher(line)).find()) && m.start() == 0) {
            String levelString = m.group(1);
            int level = levelString == null ? 0 : Integer.parseInt(levelString);
            int baseLavel = this.peekLevel();
            workDir = m.group(2);
            workDir = this.convertPath(workDir);
            workDir = this.convertWindowsRelativePath(workDir);
            if (level > baseLavel) {
                this.isEntered = true;
                this.relativesLevel.push(level);
                this.isEntered = true;
            } else if (level == baseLavel) {
                this.isEntered = !this.isEntered;
            } else {
                this.isEntered = false;
                this.popLevel();
            }
            if (this.isEntered) {
                this.relativesTo.push(workDir);
            } else {
                this.popPath();
                workDir = this.peekPath();
            }
        }
        if (workDir == null || workDir.length() == 0) {
            return false;
        }
        if (Utilities.isWindows() && CndFileUtils.isLocalFileSystem((FileSystem)this.fileSystem) && workDir.startsWith("/cygdrive/") && workDir.length() > 11) {
            workDir = "" + workDir.charAt(10) + ":" + workDir.substring(11);
        }
        if (workDir.charAt(0) == '/' || workDir.charAt(0) == '\\' || workDir.length() > 1 && workDir.charAt(1) == ':') {
            if (this.fs.exists(workDir)) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, message);
                }
                this.setWorkingDir(workDir);
                return true;
            }
            String netFile = this.fixNetHost(workDir);
            if (netFile != null) {
                this.setWorkingDir(netFile);
            }
        }
        if (this.fs.exists(dir = this.workingDir + CndFileUtils.getFileSeparatorChar((FileSystem)this.fileSystem) + workDir)) {
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                DwarfSource.LOG.log(Level.FINE, message);
            }
            this.setWorkingDir(dir);
            return true;
        }
        if (Utilities.isWindows() && CndFileUtils.isLocalFileSystem((FileSystem)this.fileSystem) && workDir.length() > 3 && workDir.charAt(0) == '/' && workDir.charAt(2) == '/' && this.fs.exists(d = "" + workDir.charAt(1) + ":" + workDir.substring(2))) {
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                DwarfSource.LOG.log(Level.FINE, message);
            }
            this.setWorkingDir(d);
            return true;
        }
        if (this.baseWorkingDir != null && this.fs.exists(dir = this.baseWorkingDir + CndFileUtils.getFileSeparatorChar((FileSystem)this.fileSystem) + workDir)) {
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                DwarfSource.LOG.log(Level.FINE, message);
            }
            this.setWorkingDir(dir);
            return true;
        }
        return false;
    }

    private String fixNetHost(String dir) {
        int i;
        if (this.root.startsWith("/net/") && (i = this.root.indexOf(47, 5)) > 0) {
            String netFile;
            String localPath = this.root.substring(i);
            String prefix = this.root.substring(0, i);
            if (dir.startsWith(localPath) && this.fs.exists(netFile = prefix + dir)) {
                return netFile;
            }
        }
        return null;
    }

    private String[] findCompiler(String line, Set<String> patterns, boolean checkExe) {
        for (String pattern : patterns) {
            int[] find = this.find(line, pattern);
            if (find != null) {
                return new String[]{pattern, line.substring(find[2])};
            }
            if (!checkExe || (find = this.find(line, pattern + ".exe")) == null) continue;
            return new String[]{pattern, line.substring(find[2])};
        }
        return null;
    }

    private int[] find(String line, String pattern) {
        int start;
        int fromIndex = 0;
        while (true) {
            if ((start = line.indexOf(pattern, fromIndex)) < 0) {
                return null;
            }
            fromIndex = start + 1;
            int prev = 32;
            if (start > 0) {
                prev = line.charAt(start - 1);
            }
            if (prev != 32 && prev != 9 && prev != 47 && prev != 92 && prev != 34 || start + pattern.length() >= line.length()) continue;
            char next = line.charAt(start + pattern.length());
            if (next == ' ' || next == '\t') {
                int binaryStart = start;
                if (prev == 47 || prev == 92) {
                    char c;
                    int first = prev;
                    int i = start - 2;
                    while (i >= 0 && (c = line.charAt(i)) != ' ' && c != '\t') {
                        binaryStart = i--;
                        first = c;
                    }
                    if (first == 45) continue;
                }
                int end = start + pattern.length();
                return new int[]{start, end, binaryStart};
            }
            if (next == '\"' && prev == 34) break;
        }
        int end = start + pattern.length();
        return new int[]{start, end, end + 1};
    }

    LineInfo testCompilerInvocation(String line) {
        LineInfo li = new LineInfo(line);
        String[] compiler = this.findCompiler(line, this.C_NAMES, this.isWindows);
        if (compiler != null) {
            li.compilerType = CompilerType.C;
            li.compiler = compiler[0];
            li.compileLine = compiler[1];
        } else {
            compiler = this.findCompiler(line, this.CPP_NAMES, this.isWindows);
            if (compiler != null) {
                li.compilerType = CompilerType.CPP;
                li.compiler = compiler[0];
                li.compileLine = compiler[1];
            } else {
                compiler = this.findCompiler(line, this.FORTRAN_NAMES, this.isWindows);
                if (compiler != null) {
                    li.compilerType = CompilerType.FORTRAN;
                    li.compiler = compiler[0];
                    li.compileLine = compiler[1];
                }
            }
        }
        return li;
    }

    private void setWorkingDir(String workingDir) {
        if (DwarfSource.LOG.isLoggable(Level.FINE)) {
            DwarfSource.LOG.log(Level.FINE, "**>> new working dir: {0}", workingDir);
        }
        this.workingDir = CndFileUtils.normalizeAbsolutePath((FileSystem)this.fileSystem, (String)workingDir);
    }

    private void setGuessWorkingDir(String workingDir) {
        if (DwarfSource.LOG.isLoggable(Level.FINE)) {
            DwarfSource.LOG.log(Level.FINE, "**>> alternative guess working dir: {0}", workingDir);
        }
        this.guessWorkingDir = CndFileUtils.normalizeAbsolutePath((FileSystem)this.fileSystem, (String)workingDir);
    }

    private boolean parseLine(String line, CompileLineStorage storage) {
        if (this.checkDirectoryChange(line)) {
            return false;
        }
        if (this.workingDir == null) {
            return false;
        }
        LineInfo li = this.testCompilerInvocation(line);
        if (li.compilerType != CompilerType.UNKNOWN) {
            this.gatherLine(li, storage);
            return true;
        }
        return false;
    }

    static String trimBackApostropheCalls(String line, PkgConfigManager.PkgConfig pkgConfig) {
        int j;
        int i = line.indexOf(96);
        if (line.lastIndexOf(96) == i) {
            return line;
        }
        if (i < 0 || i == line.length() - 1) {
            return line;
        }
        StringBuilder out = new StringBuilder();
        if (i > 0) {
            out.append(line.substring(0, i));
        }
        if ((j = (line = line.substring(i + 1)).indexOf(96)) < 0) {
            return line;
        }
        String pkg = line.substring(0, j);
        if (pkg.startsWith(PKG_CONFIG_PATTERN)) {
            PkgConfigManager.PackageConfiguration pc;
            pkg = pkg.substring(PKG_CONFIG_PATTERN.length());
            StringTokenizer st = new StringTokenizer(pkg);
            boolean readFlags = false;
            String findPkg = null;
            while (st.hasMoreTokens()) {
                String aPkg = st.nextToken();
                if (aPkg.equals("--cflags")) {
                    readFlags = true;
                    continue;
                }
                if (aPkg.startsWith("-")) {
                    readFlags = false;
                    continue;
                }
                findPkg = aPkg;
            }
            if (readFlags && pkgConfig != null && findPkg != null && (pc = pkgConfig.getPkgConfig(findPkg)) != null) {
                for (String p : pc.getIncludePaths()) {
                    out.append(" -I").append(p);
                }
                for (String p : pc.getMacros()) {
                    out.append(" -D").append(p);
                }
                out.append(" ");
            }
        } else if (pkg.startsWith(CYGPATH_PATTERN)) {
            pkg = pkg.substring(CYGPATH_PATTERN.length());
            int start = 0;
            for (int i1 = 0; i1 < pkg.length(); ++i1) {
                char c = pkg.charAt(i1);
                if (c != ' ' && c != '\t') continue;
                start = i1;
                if (i1 + 1 < pkg.length() && pkg.charAt(i1 + 1) != '-') break;
            }
            if ((pkg = pkg.substring(start).trim()).startsWith("'") && pkg.endsWith("'")) {
                out.append(pkg.substring(1, pkg.length() - 1));
            } else {
                out.append(pkg);
            }
        } else if (pkg.startsWith(ECHO_PATTERN)) {
            if ((pkg = pkg.substring(ECHO_PATTERN.length())).startsWith("'") && pkg.endsWith("'")) {
                out.append(pkg.substring(1, pkg.length() - 1));
            } else {
                StringTokenizer st = new StringTokenizer(pkg);
                if (st.hasMoreTokens()) {
                    out.append(st.nextToken());
                }
            }
        } else if (pkg.contains(ECHO_PATTERN)) {
            if ((pkg = pkg.substring(pkg.indexOf(ECHO_PATTERN) + ECHO_PATTERN.length())).startsWith("'") && pkg.endsWith("'")) {
                out.append(pkg.substring(1, pkg.length() - 1));
            } else {
                StringTokenizer st = new StringTokenizer(pkg);
                if (st.hasMoreTokens()) {
                    out.append(st.nextToken());
                }
            }
        }
        out.append(line.substring(j + 1));
        return MakeLogReader.trimBackApostropheCalls(out.toString(), pkgConfig);
    }

    private void gatherLine(LineInfo li, CompileLineStorage storage) {
        String file;
        boolean isRelative;
        String line = li.compileLine;
        Artifacts artifacts = this.compilerSettings.getDriver().gatherCompilerLine(line, CompileLineOrigin.BuildLog, li.compilerType == CompilerType.CPP);
        for (String what : artifacts.getInput()) {
            String f;
            if (what == null || what.endsWith(".s") || what.endsWith(".S")) continue;
            isRelative = true;
            if (this.isPathAbsolute(what)) {
                what = this.convertWindowsRelativePath(what);
                isRelative = false;
                file = what;
            } else {
                file = this.workingDir + "/" + what;
            }
            ArrayList<String> userIncludesCached = new ArrayList<String>(artifacts.getUserIncludes().size());
            for (String s : artifacts.getUserIncludes()) {
                s = this.convertWindowsRelativePath(s);
                userIncludesCached.add(PathCache.getString(s));
            }
            ArrayList<String> userFilesCached = new ArrayList<String>(artifacts.getUserFiles().size());
            for (String s : artifacts.getUserFiles()) {
                userFilesCached.add(PathCache.getString(s));
            }
            HashMap<String, String> userMacrosCached = new HashMap<String, String>(artifacts.getUserMacros().size());
            for (Map.Entry e : artifacts.getUserMacros().entrySet()) {
                if (e.getValue() == null) {
                    userMacrosCached.put(PathCache.getString((String)e.getKey()), null);
                    continue;
                }
                userMacrosCached.put(PathCache.getString((String)e.getKey()), PathCache.getString((String)e.getValue()));
            }
            if (this.fs.exists(file)) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "**** Gotcha: {0}", file);
                }
                this.result.add(new CommandLineSource(li, artifacts, this.workingDir, this.convertSymbolicLink(what), userIncludesCached, userFilesCached, userMacrosCached, storage));
                continue;
            }
            if (!isRelative && !(file = this.convertPath(what)).equals(what)) {
                what = file;
                if (this.fs.exists(file)) {
                    if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                        DwarfSource.LOG.log(Level.FINE, "**** Gotcha: {0}", file);
                    }
                    this.result.add(new CommandLineSource(li, artifacts, this.workingDir, this.convertSymbolicLink(what), userIncludesCached, userFilesCached, userMacrosCached, storage));
                    continue;
                }
            }
            if (this.guessWorkingDir != null && !what.startsWith("/") && this.fs.exists(f = this.guessWorkingDir + "/" + what)) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "**** Gotcha guess: {0}", f);
                }
                this.result.add(new CommandLineSource(li, artifacts, this.guessWorkingDir, this.convertSymbolicLink(what), userIncludesCached, userFilesCached, userMacrosCached, storage));
                continue;
            }
            if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                DwarfSource.LOG.log(Level.FINE, "**** Not found {0}", file);
            }
            if (what.startsWith("/") || artifacts.getUserIncludes().size() + artifacts.getUserMacros().size() <= 0) continue;
            List<String> res = this.findFiles(what);
            if (res == null || res.isEmpty()) {
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "** And there is no such file under root");
                }
            } else {
                if (res.size() == 1) {
                    this.result.add(new CommandLineSource(li, artifacts, res.get(0), this.convertSymbolicLink(what), userIncludesCached, userFilesCached, userMacrosCached, storage));
                    if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                        DwarfSource.LOG.log(Level.FINE, "** Gotcha: {0}{1}{2}", new Object[]{res.get(0), "/", what});
                    }
                    this.setGuessWorkingDir(res.get(0));
                    continue;
                }
                if (DwarfSource.LOG.isLoggable(Level.FINE)) {
                    DwarfSource.LOG.log(Level.FINE, "**There are several candidates and I'm not clever enough yet to find correct one.");
                }
            }
            if (!DwarfSource.LOG.isLoggable(Level.FINE)) continue;
            DwarfSource.LOG.log(Level.FINE, "{0} [{1}]", new Object[]{line.length() > 120 ? line.substring(0, 117) + ">>>" : line, what});
        }
        if (artifacts.getOutput() != null) {
            String what = artifacts.getOutput();
            String baseName = CndPathUtilities.getBaseName((String)what);
            if (!baseName.endsWith(".exe") && baseName.contains(".")) {
                return;
            }
            isRelative = true;
            if (this.isPathAbsolute(what)) {
                what = this.convertWindowsRelativePath(what);
                isRelative = false;
                file = what;
            } else {
                file = this.workingDir + "/" + what;
            }
            if (this.fs.exists(file)) {
                if (!this.buildArtifacts.contains(file)) {
                    this.buildArtifacts.add(file);
                }
            } else if (!isRelative && !(file = this.convertPath(what)).equals(what) && this.fs.exists(file) && !this.buildArtifacts.contains(file)) {
                this.buildArtifacts.add(file);
            }
        }
    }

    private String convertSymbolicLink(String fullName) {
        String resolvedLink;
        if (this.project.resolveSymbolicLinks() && (resolvedLink = DiscoveryUtils.resolveSymbolicLink((FileSystem)this.fileSystem, (String)fullName)) != null) {
            fullName = resolvedLink;
        }
        return fullName;
    }

    private boolean isPathAbsolute(CharSequence path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if (path.charAt(0) == '/') {
            return true;
        }
        if (path.charAt(0) == '\\') {
            return true;
        }
        if (CharSequenceUtils.indexOf((CharSequence)path, (char)':') == 1) {
            if (path.length() == 2) {
                return false;
            }
            return path.charAt(2) == '\\' || path.charAt(2) == '/';
        }
        return false;
    }

    static ItemProperties.LanguageKind detectLanguage(LineInfo li, Artifacts artifacts, String sourcePath) {
        String mime;
        ItemProperties.LanguageKind language = li.getLanguage();
        if (artifacts.getLanguageArtifacts().contains("c")) {
            language = ItemProperties.LanguageKind.C;
        } else if (artifacts.getLanguageArtifacts().contains("c++")) {
            language = ItemProperties.LanguageKind.CPP;
        } else if (language == ItemProperties.LanguageKind.Unknown || "cl".equals(li.compiler)) {
            String mime2 = MIMESupport.getKnownSourceFileMIMETypeByExtension((String)sourcePath);
            if ("text/x-c++".equals(mime2)) {
                if (li.getLanguage() != ItemProperties.LanguageKind.CPP) {
                    language = ItemProperties.LanguageKind.CPP;
                }
            } else if ("text/x-c".equals(mime2) && li.getLanguage() != ItemProperties.LanguageKind.C) {
                language = ItemProperties.LanguageKind.C;
            }
        } else if (language == ItemProperties.LanguageKind.C && !li.compiler.equals("cc") && "text/x-c++".equals(mime = MIMESupport.getKnownSourceFileMIMETypeByExtension((String)sourcePath))) {
            language = ItemProperties.LanguageKind.CPP;
        }
        return language;
    }

    private List<String> getFiles(String name) {
        this.getSubfolders();
        return this.findBase.get(name);
    }

    private List<String> findFiles(String relativePath) {
        List<String> files;
        int j;
        String name;
        relativePath = relativePath.replace('\\', '/');
        int i = relativePath.lastIndexOf(47);
        String relativeFolder = null;
        if (i > 0) {
            name = relativePath.substring(i + 1);
            relativeFolder = relativePath.substring(0, i);
        } else {
            name = relativePath;
        }
        String subFolder = null;
        if (relativeFolder != null && (j = relativeFolder.lastIndexOf("../")) >= 0) {
            subFolder = relativePath.substring(j + 2);
        }
        if ((files = this.getFiles(name)) != null) {
            ArrayList<String> res = new ArrayList<String>(files.size());
            for (String s : files) {
                if (relativeFolder == null) {
                    res.add(s);
                    if (res.size() <= 1) continue;
                    return res;
                }
                if (subFolder == null) {
                    String path = s;
                    if (!path.endsWith(relativeFolder) || path.length() <= relativeFolder.length() + 1) continue;
                    path = path.substring(0, path.length() - relativeFolder.length() - 1);
                    res.add(path);
                    if (res.size() <= 1) continue;
                    return res;
                }
                for (String sub : this.getSubfolders()) {
                    String pathCandidate = this.normalizeFile(sub + "/" + relativePath);
                    int j2 = pathCandidate.lastIndexOf(47);
                    if (j2 <= 0 || !this.subFolders.contains(pathCandidate = pathCandidate.substring(0, j2))) continue;
                    res.add(sub);
                    if (res.size() <= 1) continue;
                    return res;
                }
            }
            return res;
        }
        return null;
    }

    private String normalizeFile(String path) {
        int i;
        path = path.replace("/./", "/");
        while ((i = path.indexOf("/../")) >= 0) {
            int prev = -1;
            for (int j = i - 1; j >= 0; --j) {
                if (path.charAt(j) != '/') continue;
                prev = j;
                break;
            }
            if (prev == -1) break;
            path = path.substring(0, prev) + path.substring(i + 3);
        }
        return path;
    }

    private Set<String> getSubfolders() {
        if (this.subFolders == null) {
            this.subFolders = new HashSet();
            this.findBase = new HashMap<String, List<String>>();
            FileObject rootFO = this.fileSystem.findResource(this.root);
            this.gatherSubFolders(rootFO, new LinkedList<String>());
        }
        return this.subFolders;
    }

    private void gatherSubFolders(FileObject d, LinkedList<String> antiLoop) {
        if (d != null && d.isValid() && d.isFolder() && d.canRead()) {
            String canPath;
            if (this.isStoped.cancelled()) {
                return;
            }
            if (CndPathUtilities.isIgnoredFolder((String)d.getNameExt())) {
                return;
            }
            try {
                canPath = CndFileUtils.getCanonicalPath((FileObject)d);
            }
            catch (IOException ex) {
                return;
            }
            if (!antiLoop.contains(canPath)) {
                antiLoop.addLast(canPath);
                this.subFolders.add(d.getPath().replace('\\', '/'));
                FileObject[] ff = d.getChildren();
                if (ff != null) {
                    for (int i = 0; i < ff.length && !this.isStoped.cancelled(); ++i) {
                        if (ff[i].isFolder()) {
                            this.gatherSubFolders(ff[i], antiLoop);
                            continue;
                        }
                        if (!ff[i].isData() || CndFileVisibilityQuery.getDefault().isIgnored(ff[i].getNameExt())) continue;
                        List<String> l = this.findBase.get(ff[i].getNameExt());
                        if (l == null) {
                            l = new ArrayList<String>();
                            this.findBase.put(ff[i].getNameExt(), l);
                        }
                        l.add(d.getPath().replace('\\', '/'));
                    }
                }
                antiLoop.removeLast();
            }
        }
    }

    class CommandLineSource
    extends RelocatableImpl
    implements SourceFileProperties {
        private String sourceName;
        private final String compiler;
        private final ItemProperties.LanguageKind language;
        private ItemProperties.LanguageStandard standard = ItemProperties.LanguageStandard.Unknown;
        private final List<String> systemIncludes = Collections.emptyList();
        private final Map<String, String> userMacros;
        private final List<String> undefinedMacros;
        private final Map<String, String> systemMacros = Collections.emptyMap();
        private final CompileLineStorage storage;
        private int handler = -1;
        private final String importantFlags;

        CommandLineSource(LineInfo li, Artifacts artifacts, String compilePath, String sourcePath, List<String> userIncludes, List<String> userFiles, Map<String, String> userMacros, CompileLineStorage storage) {
            this.language = MakeLogReader.detectLanguage(li, artifacts, sourcePath);
            this.standard = DriverFactory.getLanguageStandard((ItemProperties.LanguageStandard)this.standard, (Artifacts)artifacts);
            this.compiler = li.compiler;
            this.compilePath = compilePath;
            this.sourceName = sourcePath;
            if (CndPathUtilities.isPathAbsolute((CharSequence)this.sourceName)) {
                this.fullName = this.sourceName;
                this.sourceName = DiscoveryUtils.getRelativePath((String)compilePath, (String)this.sourceName);
            } else {
                this.fullName = compilePath + "/" + this.sourceName;
            }
            this.fullName = MakeLogReader.this.convertSymbolicLink(this.fullName);
            this.fullName = CndFileUtils.normalizeAbsolutePath((FileSystem)MakeLogReader.this.fileSystem, (String)this.fullName);
            this.fullName = PathCache.getString(this.fullName);
            this.userIncludes = userIncludes;
            this.userFiles = userFiles;
            this.userMacros = userMacros;
            this.undefinedMacros = artifacts.getUserUndefinedMacros();
            this.storage = storage;
            if (storage != null) {
                this.handler = storage.putCompileLine(li.compileLine);
            }
            this.importantFlags = DriverFactory.importantFlagsToString((Artifacts)artifacts);
        }

        public String getCompilePath() {
            return this.compilePath;
        }

        public String getItemPath() {
            return this.fullName;
        }

        public String getCompileLine() {
            if (this.storage != null && this.handler != -1) {
                return this.storage.getCompileLine(this.handler);
            }
            return null;
        }

        public String getItemName() {
            return this.sourceName;
        }

        public List<String> getUserInludePaths() {
            return this.userIncludes;
        }

        public List<String> getUserInludeFiles() {
            return this.userFiles;
        }

        public List<String> getSystemInludePaths() {
            return this.systemIncludes;
        }

        public Set<String> getIncludedFiles() {
            return this.includedFiles;
        }

        public Map<String, String> getUserMacros() {
            return this.userMacros;
        }

        public List<String> getUndefinedMacros() {
            return this.undefinedMacros;
        }

        public Map<String, String> getSystemMacros() {
            return this.systemMacros;
        }

        public ItemProperties.LanguageKind getLanguageKind() {
            return this.language;
        }

        public String getCompilerName() {
            return this.compiler;
        }

        public ItemProperties.LanguageStandard getLanguageStandard() {
            return this.standard;
        }

        public String getImportantFlags() {
            return this.importantFlags;
        }
    }

    static class LineInfo {
        public String compileLine;
        public String compiler;
        public CompilerType compilerType = CompilerType.UNKNOWN;

        LineInfo(String line) {
            this.compileLine = line;
        }

        ItemProperties.LanguageKind getLanguage() {
            switch (this.compilerType) {
                case C: {
                    return ItemProperties.LanguageKind.C;
                }
                case CPP: {
                    return ItemProperties.LanguageKind.CPP;
                }
                case FORTRAN: {
                    return ItemProperties.LanguageKind.Fortran;
                }
            }
            return ItemProperties.LanguageKind.Unknown;
        }
    }

    static enum CompilerType {
        CPP,
        C,
        FORTRAN,
        UNKNOWN;

    }
}

