/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.debugger.ui;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.prefs.Preferences;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.Properties;
import org.netbeans.modules.debugger.ui.eval.CodeEvaluatorUI;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbPreferences;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class CodeEvaluator {
    private static final CodeEvaluator INSTANCE = new CodeEvaluator();

    private CodeEvaluator() {
    }

    public static CodeEvaluator getDefault() {
        return INSTANCE;
    }

    public void open() {
        CodeEvaluatorUI.openEvaluator();
    }

    public void setExpression(String expression) {
        CodeEvaluatorUI.getInstance().pasteExpression(expression);
    }

    public void requestFocus() {
        CodeEvaluatorUI.getInstance().requestFocusInWindow();
    }

    public static final class Result<R, H> {
        private static final Map<Integer, List<WeakReference<Result>>> ENGINE_HASH_MAP = new HashMap<Integer, List<WeakReference<Result>>>();
        private final Preferences preferences = NbPreferences.forModule(ContextProvider.class).node("variables_view");
        private final DebuggerEngine engine;
        private TopComponent resultView;
        private volatile String expression;
        private volatile R result;
        private final List<H> historyItems = new ArrayList<H>();
        private final List<H> historyItemsRO = Collections.unmodifiableList(this.historyItems);
        private H lastHistoryItem;
        private int maxHistoryItems = 100;
        private final Set<Listener<R>> listeners = new CopyOnWriteArraySet<Listener<R>>();

        private Result(DebuggerEngine engine) {
            this.engine = engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <R, H> Result<R, H> get(DebuggerEngine engine) {
            int hc = engine.hashCode();
            Map<Integer, List<WeakReference<Result>>> map = ENGINE_HASH_MAP;
            synchronized (map) {
                List<WeakReference<Result>> elist = ENGINE_HASH_MAP.get(hc);
                if (elist == null) {
                    elist = new LinkedList<WeakReference<Result>>();
                    ENGINE_HASH_MAP.put(hc, elist);
                }
                for (int i = 0; i < elist.size(); ++i) {
                    WeakReference<Result> wr = elist.get(i);
                    Result r = (Result)wr.get();
                    if (r == null) {
                        elist.remove(wr);
                        --i;
                        continue;
                    }
                    if (engine != r.engine) continue;
                    return r;
                }
                Result<R, H> r = new Result<R, H>(engine);
                elist.add(new WeakReference<Result<R, H>>(r));
                return r;
            }
        }

        public void setMaxHistoryItems(int maxHistoryItems) {
            if (maxHistoryItems < 0) {
                throw new IllegalArgumentException(Integer.toString(maxHistoryItems));
            }
            this.maxHistoryItems = maxHistoryItems;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAndOpen(String expression, final R result, H historyItem) {
            this.expression = expression;
            this.result = result;
            if (this.lastHistoryItem != null) {
                List<H> list = this.historyItems;
                synchronized (list) {
                    this.historyItems.add(0, this.lastHistoryItem);
                    while (this.historyItems.size() > this.maxHistoryItems) {
                        this.historyItems.remove(this.historyItems.size() - 1);
                    }
                }
            }
            this.lastHistoryItem = historyItem;
            if (result == null) {
                this.fireResultChange(result);
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean isMinimized = false;
                    if (Result.this.preferences.getBoolean("show_evaluator_result", true)) {
                        TopComponent view = WindowManager.getDefault().findTopComponent("localsView");
                        view.open();
                        isMinimized = WindowManager.getDefault().isTopComponentMinimized(view);
                        view.requestActive();
                    } else {
                        if (Result.this.resultView == null) {
                            Result.this.resultView = Result.this.getResultViewInstance();
                        }
                        if (result != null && Result.this.resultView != null) {
                            Result.this.resultView.open();
                            isMinimized = WindowManager.getDefault().isTopComponentMinimized(Result.this.resultView);
                            Result.this.resultView.requestActive();
                        }
                    }
                    if (!isMinimized) {
                        CodeEvaluatorUI.getInstance().requestActive();
                    }
                    Result.this.fireResultChange(result);
                }
            });
        }

        public String getExpression() {
            return this.expression;
        }

        public R getResult() {
            return this.result;
        }

        public List<H> getHistoryItems() {
            return this.historyItemsRO;
        }

        private synchronized TopComponent getResultViewInstance() {
            TopComponent instance = WindowManager.getDefault().findTopComponent("resultsView");
            return instance;
        }

        private void fireResultChange(R result) {
            for (Listener<R> l : this.listeners) {
                l.resultChanged(result);
            }
        }

        public void addListener(Listener<R> l) {
            this.listeners.add(l);
        }

        public void removeListener(Listener<R> l) {
            this.listeners.remove(l);
        }

        public static final class DefaultHistoryItem {
            private final String expression;
            private final String type;
            private final String value;
            private final String toStringValue;
            private final String tooltip;

            public DefaultHistoryItem(String expression, String type, String value, String toStringValue) {
                this.expression = expression;
                this.type = type;
                this.value = value;
                this.toStringValue = toStringValue;
                StringBuffer buf = new StringBuffer();
                buf.append("<html>");
                String text = expression.replaceAll("&", "&amp;");
                text = text.replaceAll("<", "&lt;");
                text = text.replaceAll(">", "&gt;");
                text = text.replaceAll("\n", "<br/>");
                text = text.replaceAll("\r", "");
                buf.append(text);
                buf.append("</html>");
                this.tooltip = buf.toString();
            }

            public String getExpression() {
                return this.expression;
            }

            public String getType() {
                return this.type;
            }

            public String getValue() {
                return this.value;
            }

            public String getToStringValue() {
                return this.toStringValue;
            }

            public String getTooltip() {
                return this.tooltip;
            }
        }

        public static interface Listener<R> {
            public void resultChanged(R var1);
        }
    }

    public static final class DefaultExpressionsHistoryPersistence {
        private static final int NUM_HISTORY_ITEMS = 20;
        private final String engineName;
        private ArrayList<String> editItemsList;
        private Set<String> editItemsSet;

        private DefaultExpressionsHistoryPersistence(String engineName) {
            this.engineName = engineName;
            this.getExpressions();
        }

        public static DefaultExpressionsHistoryPersistence create(String engineName) {
            return new DefaultExpressionsHistoryPersistence(engineName);
        }

        public synchronized List<String> getExpressions() {
            if (this.editItemsList == null) {
                this.editItemsList = (ArrayList)Properties.getDefault().getProperties(this.engineName).getCollection("EvaluatorItems", new ArrayList());
                this.editItemsSet = new HashSet<String>(this.editItemsList);
            }
            return this.editItemsList;
        }

        public synchronized void addExpression(String expression) {
            if (this.editItemsSet.contains(expression = expression.trim())) {
                this.editItemsList.remove(expression);
                this.editItemsList.add(0, expression);
            } else {
                this.editItemsList.add(0, expression);
                this.editItemsSet.add(expression);
                if (this.editItemsList.size() > 20) {
                    String removed = this.editItemsList.remove(this.editItemsList.size() - 1);
                    this.editItemsSet.remove(removed);
                }
            }
            this.storeEditItems(this.editItemsList);
        }

        private void storeEditItems(ArrayList<String> items) {
            Properties.getDefault().getProperties(this.engineName).setCollection("EvaluatorItems", items);
        }
    }

    public static abstract class EvaluatorService {
        public static final String PROP_CAN_EVALUATE = "canEvaluate";
        public static final String PROP_EXPRESSIONS_HISTORY = "expressionsHistory";
        private final PropertyChangeSupport pchs = new PropertyChangeSupport(this);

        public abstract void setupContext(JEditorPane var1, Runnable var2);

        public abstract boolean canEvaluate();

        public abstract void evaluate(String var1);

        public abstract List<String> getExpressionsHistory();

        protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            this.pchs.firePropertyChange(propertyName, oldValue, newValue);
        }

        public final void addPropertyChangeListener(PropertyChangeListener l) {
            this.pchs.addPropertyChangeListener(l);
        }

        public final void removePropertyChangeListener(PropertyChangeListener l) {
            this.pchs.removePropertyChangeListener(l);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE})
        public static @interface Registration {
            public String path();

            public int position() default 0x7FFFFFFF;
        }
    }
}

