/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript2.extjs;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CodeCompletionContext;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.javascript2.editor.api.lexer.JsTokenId;
import org.netbeans.modules.javascript2.editor.api.lexer.LexUtilities;
import org.netbeans.modules.javascript2.editor.spi.CompletionContext;
import org.netbeans.modules.javascript2.editor.spi.CompletionProvider;
import org.netbeans.modules.javascript2.extjs.DataLoader;
import org.netbeans.modules.javascript2.extjs.ExtJsCompletionItem;
import org.netbeans.modules.javascript2.extjs.ExtJsDataItem;
import org.netbeans.modules.javascript2.extjs.ExtJsElement;
import org.openide.modules.InstalledFileLocator;

public class ExtJsCodeCompletion
implements CompletionProvider {
    private static final String FILE_LOCATION = "docs/extjs-properties.xml";
    private static File extPropertyFile;
    private static HashMap<String, Collection<ExtJsDataItem>> ccData;

    private static synchronized File getDataFile() {
        if (extPropertyFile == null) {
            extPropertyFile = InstalledFileLocator.getDefault().locate(FILE_LOCATION, "org.netbeans.modules.javascript2.extjs", false);
        }
        return extPropertyFile;
    }

    private static synchronized Map<String, Collection<ExtJsDataItem>> getData() {
        return DataLoader.getData(ExtJsCodeCompletion.getDataFile());
    }

    public List<CompletionProposal> complete(CodeCompletionContext ccContext, CompletionContext jsCompletionContext, String prefix) {
        JsTokenId tokenId;
        if (jsCompletionContext != CompletionContext.OBJECT_PROPERTY_NAME) {
            return Collections.EMPTY_LIST;
        }
        TokenHierarchy th = ccContext.getParserResult().getSnapshot().getTokenHierarchy();
        if (th == null) {
            return Collections.EMPTY_LIST;
        }
        int carretOffset = ccContext.getCaretOffset();
        int eOffset = ccContext.getParserResult().getSnapshot().getEmbeddedOffset(carretOffset);
        TokenSequence ts = LexUtilities.getJsTokenSequence((TokenHierarchy)th, (int)eOffset);
        if (ts == null) {
            return Collections.EMPTY_LIST;
        }
        ts.move(eOffset);
        if (!ts.moveNext() && !ts.movePrevious()) {
            return Collections.EMPTY_LIST;
        }
        Token token = null;
        int balance = 1;
        while (ts.movePrevious() && balance > 0) {
            token = ts.token();
            tokenId = (JsTokenId)token.id();
            if (tokenId == JsTokenId.BRACKET_RIGHT_CURLY) {
                ++balance;
                continue;
            }
            if (tokenId != JsTokenId.BRACKET_LEFT_CURLY) continue;
            --balance;
        }
        if (token == null || balance != 0) {
            return Collections.EMPTY_LIST;
        }
        token = LexUtilities.findPreviousToken((TokenSequence)ts, Arrays.asList(JsTokenId.IDENTIFIER));
        tokenId = (JsTokenId)token.id();
        StringBuilder sb = new StringBuilder(token.text());
        while ((tokenId == JsTokenId.IDENTIFIER || tokenId == JsTokenId.OPERATOR_DOT) && ts.movePrevious()) {
            token = ts.token();
            tokenId = (JsTokenId)token.id();
            if (tokenId == JsTokenId.OPERATOR_DOT) {
                sb.insert(0, '.');
                continue;
            }
            if (tokenId != JsTokenId.IDENTIFIER) continue;
            sb.insert(0, token.text());
        }
        String fqn = sb.toString();
        Map<String, Collection<ExtJsDataItem>> data = ExtJsCodeCompletion.getData();
        Collection<ExtJsDataItem> items = data.get(fqn);
        int anchorOffset = eOffset - ccContext.getPrefix().length();
        if (items != null) {
            ArrayList<CompletionProposal> result = new ArrayList<CompletionProposal>();
            for (ExtJsDataItem item : items) {
                if (!item.getName().startsWith(prefix)) continue;
                result.add(ExtJsCompletionItem.createExtJsItem(item, anchorOffset));
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    public String getHelpDocumentation(ParserResult info, ElementHandle element) {
        if (element != null && element instanceof ExtJsElement) {
            return ((ExtJsElement)element).getDocumentation();
        }
        return null;
    }

    static {
        ccData = null;
    }
}

