/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.cplusplus;

import javax.swing.Action;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.ext.ExtKit;
import org.netbeans.modules.cnd.editor.api.CodeStyle;
import org.netbeans.modules.cnd.editor.cplusplus.CamelCaseOperations;
import org.netbeans.modules.cnd.editor.cplusplus.DeleteToNextCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.DeleteToPreviousCamelCasePosition;
import org.netbeans.modules.cnd.editor.cplusplus.InsertSemicolonAction;
import org.netbeans.modules.cnd.editor.cplusplus.SelectCodeElementAction;
import org.netbeans.modules.editor.NbEditorKit;
import org.openide.util.NbPreferences;

public class CCKit
extends NbEditorKit {
    static final String previousCamelCasePosition = "previous-camel-case-position";
    static final String nextCamelCasePosition = "next-camel-case-position";
    static final String selectPreviousCamelCasePosition = "select-previous-camel-case-position";
    static final String selectNextCamelCasePosition = "select-next-camel-case-position";
    static final String deletePreviousCamelCasePosition = "delete-previous-camel-case-position";
    static final String deleteNextCamelCasePosition = "delete-next-camel-case-position";
    static final String selectNextElementAction = "select-element-next";
    static final String selectPreviousElementAction = "select-element-previous";

    public String getContentType() {
        return "text/x-c++";
    }

    public Document createDefaultDocument() {
        Document doc = super.createDefaultDocument();
        return doc;
    }

    protected void initDocument(BaseDocument doc) {
        super.initDocument(doc);
        Language<CppTokenId> language = this.getLanguage();
        doc.putProperty(Language.class, language);
        doc.putProperty(InputAttributes.class, (Object)this.getLexerAttributes(language, doc));
        CodeStyle.getDefault((Document)doc);
    }

    protected Language<CppTokenId> getLanguage() {
        return CppTokenId.languageCpp();
    }

    protected final InputAttributes getLexerAttributes(Language<?> language, BaseDocument doc) {
        InputAttributes lexerAttrs = new InputAttributes();
        lexerAttrs.setValue(language, (Object)"lexer-filter", this.getFilter(language, doc), true);
        return lexerAttrs;
    }

    protected Filter<?> getFilter(Language<?> language, BaseDocument doc) {
        return CndLexerUtilities.getDefatultFilter((boolean)true);
    }

    protected Action getCommentAction() {
        return new ExtKit.CommentAction("//");
    }

    protected Action getUncommentAction() {
        return new ExtKit.UncommentAction("//");
    }

    protected Action getToggleCommentAction() {
        return new ExtKit.ToggleCommentAction("//");
    }

    protected Action[] createActions() {
        Action[] superActions = super.createActions();
        Action[] ccActions = new Action[]{this.getToggleCommentAction(), this.getCommentAction(), this.getUncommentAction(), new CCNextWordAction("caret-next-word"), new CCPreviousWordAction("caret-previous-word"), new CCNextWordAction("selection-next-word"), new CCPreviousWordAction("selection-previous-word"), new DeleteToNextCamelCasePosition(CCKit.findAction(superActions, "remove-word-next")), new DeleteToPreviousCamelCasePosition(CCKit.findAction(superActions, "remove-word-previous")), new SelectCodeElementAction(selectNextElementAction, true), new SelectCodeElementAction(selectPreviousElementAction, false), new InsertSemicolonAction(true), new InsertSemicolonAction(false)};
        ccActions = TextAction.augmentList(superActions, ccActions);
        return ccActions;
    }

    private static Action findAction(Action[] actions, String name) {
        for (Action a : actions) {
            Object nameObj = a.getValue("Name");
            if (!(nameObj instanceof String) || !name.equals(nameObj)) continue;
            return a;
        }
        return null;
    }

    private static boolean isUsingCamelCase() {
        return NbPreferences.root().getBoolean("useCamelCaseStyleNavigation", true);
    }

    public static class CCPreviousWordAction
    extends BaseKit.PreviousWordAction {
        CCPreviousWordAction(String name) {
            super(name);
        }

        protected int getPreviousWordOffset(JTextComponent target) throws BadLocationException {
            return CCKit.isUsingCamelCase() ? CamelCaseOperations.previousCamelCasePosition(target) : super.getPreviousWordOffset(target);
        }
    }

    public static class CCNextWordAction
    extends BaseKit.NextWordAction {
        CCNextWordAction(String name) {
            super(name);
        }

        protected int getNextWordOffset(JTextComponent target) throws BadLocationException {
            return CCKit.isUsingCamelCase() ? CamelCaseOperations.nextCamelCasePosition(target, true) : super.getNextWordOffset(target);
        }
    }
}

