/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.reformat;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranBracesStack;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranDiffLinkedList;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranExtendedTokenSequence;

public class FortranContextDetector
extends FortranExtendedTokenSequence {
    FortranContextDetector(TokenSequence<FortranTokenId> ts, FortranDiffLinkedList diffs, FortranBracesStack braces, int tabSize, boolean expandTabToSpaces) {
        super(ts, diffs, tabSize, expandTabToSpaces);
    }

    OperatorKind getOperatorKind(Token<FortranTokenId> current) {
        Token<FortranTokenId> previous = this.lookPreviousImportant();
        Token<FortranTokenId> next = this.lookNextImportant();
        if (previous != null && next != null) {
            String prevCategory = ((FortranTokenId)previous.id()).primaryCategory();
            if ("keyword".equals(prevCategory) || "special".equals(prevCategory) && previous.id() != FortranTokenId.RPAREN) {
                switch ((FortranTokenId)current.id()) {
                    case OP_MUL: 
                    case OP_PLUS: 
                    case OP_MINUS: {
                        return OperatorKind.UNARY;
                    }
                }
                return OperatorKind.SEPARATOR;
            }
            if ("operator".equals(prevCategory)) {
                switch ((FortranTokenId)previous.id()) {
                    case EQ: {
                        switch ((FortranTokenId)current.id()) {
                            case OP_MUL: 
                            case OP_PLUS: 
                            case OP_MINUS: {
                                return OperatorKind.UNARY;
                            }
                        }
                        return OperatorKind.SEPARATOR;
                    }
                    case OP_LT: 
                    case OP_LOG_EQ: 
                    case OP_LT_EQ: 
                    case OP_GT_EQ: 
                    case OP_NOT_EQ: 
                    case PERCENT: {
                        switch ((FortranTokenId)current.id()) {
                            case OP_MUL: 
                            case OP_PLUS: 
                            case OP_MINUS: {
                                return OperatorKind.UNARY;
                            }
                        }
                        return OperatorKind.SEPARATOR;
                    }
                }
            }
            if ("number".equals(prevCategory) || "literal".equals(prevCategory) || "string".equals(prevCategory)) {
                return OperatorKind.BINARY;
            }
            String nextCategory = ((FortranTokenId)next.id()).primaryCategory();
            if ("keyword".equals(nextCategory)) {
                switch ((FortranTokenId)current.id()) {
                    case OP_PLUS: 
                    case OP_MINUS: {
                        return OperatorKind.BINARY;
                    }
                }
                return OperatorKind.SEPARATOR;
            }
            if ("number".equals(nextCategory) || "literal".equals(nextCategory) || "string".equals(nextCategory)) {
                if ("special".equals(prevCategory) || "operator".equals(prevCategory)) {
                    switch ((FortranTokenId)current.id()) {
                        default: 
                    }
                    switch ((FortranTokenId)previous.id()) {
                        case RPAREN: {
                            return OperatorKind.BINARY;
                        }
                    }
                    return OperatorKind.UNARY;
                }
                return OperatorKind.BINARY;
            }
            if (previous.id() == FortranTokenId.RPAREN && next.id() == FortranTokenId.IDENTIFIER) {
                if (this.isPreviousStatementParen()) {
                    switch ((FortranTokenId)current.id()) {
                        case OP_MUL: 
                        case OP_PLUS: 
                        case OP_MINUS: {
                            return OperatorKind.UNARY;
                        }
                    }
                    return OperatorKind.SEPARATOR;
                }
                return OperatorKind.BINARY;
            }
            if (previous.id() == FortranTokenId.IDENTIFIER) {
                if (next.id() == FortranTokenId.LPAREN) {
                    return OperatorKind.BINARY;
                }
                if ("operator".equals(nextCategory) || "special".equals(nextCategory)) {
                    switch ((FortranTokenId)current.id()) {
                        case OP_MUL: 
                        case OP_PLUS: 
                        case OP_MINUS: {
                            return OperatorKind.BINARY;
                        }
                    }
                    return OperatorKind.SEPARATOR;
                }
                if (next.id() == FortranTokenId.IDENTIFIER) {
                    switch ((FortranTokenId)current.id()) {
                        case OP_MUL: 
                        case OP_PLUS: 
                        case OP_MINUS: {
                            return OperatorKind.BINARY;
                        }
                    }
                    return OperatorKind.SEPARATOR;
                }
            }
        }
        return OperatorKind.SEPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPreviousStatementParen() {
        int index = this.index();
        try {
            block7: while (this.movePrevious()) {
                switch ((FortranTokenId)this.token().id()) {
                    case WHITESPACE: 
                    case NEW_LINE: 
                    case LINE_COMMENT_FIXED: 
                    case LINE_COMMENT_FREE: 
                    case PREPROCESSOR_DIRECTIVE: {
                        continue block7;
                    }
                }
                boolean bl = this.isStatementParen();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.moveIndex(index);
            this.moveNext();
        }
    }

    private boolean isStatementParen() {
        if (this.token().id() == FortranTokenId.RPAREN) {
            int level = 1;
            while (this.movePrevious()) {
                switch ((FortranTokenId)this.token().id()) {
                    case RPAREN: {
                        ++level;
                        break;
                    }
                    case LPAREN: {
                        if (--level != 0) break;
                        Token<FortranTokenId> previous = this.lookPreviousImportant();
                        if (previous != null) {
                            switch ((FortranTokenId)previous.id()) {
                                case KW_FORALL: 
                                case KW_IF: 
                                case KW_WHILE: 
                                case KW_SELECT: 
                                case KW_SELECTCASE: 
                                case KW_SELECTTYPE: {
                                    return true;
                                }
                            }
                            block11: while (this.movePrevious()) {
                                switch ((FortranTokenId)this.token().id()) {
                                    case WHITESPACE: 
                                    case NEW_LINE: 
                                    case LINE_COMMENT_FIXED: 
                                    case LINE_COMMENT_FREE: 
                                    case PREPROCESSOR_DIRECTIVE: {
                                        continue block11;
                                    }
                                }
                                return false;
                            }
                        }
                        return false;
                    }
                }
            }
        }
        return false;
    }

    static enum OperatorKind {
        BINARY,
        UNARY,
        SEPARATOR;

    }
}

