/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.indent;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;

public final class TokenItem {
    private final int index;
    private final TokenId tokenId;
    protected final TokenSequence<TokenId> tokenSeq;
    private final boolean skipPP;

    public TokenItem(TokenSequence<TokenId> ts, boolean skipPP) {
        this.index = ts.index();
        this.tokenId = ts.token().id();
        this.tokenSeq = ts;
        this.skipPP = skipPP;
    }

    public TokenSequence<TokenId> getTokenSequence() {
        return this.tokenSeq;
    }

    public boolean isSkipPP() {
        return this.skipPP;
    }

    private void go() {
        this.tokenSeq.moveIndex(this.index);
        this.tokenSeq.moveNext();
    }

    public TokenId getTokenID() {
        return this.tokenId;
    }

    public CppTokenId getTokenPPID() {
        TokenSequence prep = this.tokenSeq.embedded(CppTokenId.languagePreproc());
        if (prep == null) {
            return CppTokenId.PREPROCESSOR_START;
        }
        prep.moveStart();
        while (prep.moveNext() && (prep.token().id() == CppTokenId.WHITESPACE || prep.token().id() == CppTokenId.PREPROCESSOR_START || prep.token().id() == CppTokenId.PREPROCESSOR_START_ALT)) {
        }
        Token directive = null;
        if (prep.token() != null) {
            directive = prep.token();
        }
        if (directive != null) {
            switch ((CppTokenId)directive.id()) {
                case PREPROCESSOR_DIRECTIVE: 
                case PREPROCESSOR_IF: 
                case PREPROCESSOR_IFDEF: 
                case PREPROCESSOR_IFNDEF: 
                case PREPROCESSOR_ELSE: 
                case PREPROCESSOR_ELIF: 
                case PREPROCESSOR_ENDIF: 
                case PREPROCESSOR_DEFINE: 
                case PREPROCESSOR_UNDEF: 
                case PREPROCESSOR_INCLUDE: 
                case PREPROCESSOR_INCLUDE_NEXT: 
                case PREPROCESSOR_LINE: 
                case PREPROCESSOR_IDENT: 
                case PREPROCESSOR_PRAGMA: 
                case PREPROCESSOR_WARNING: 
                case PREPROCESSOR_ERROR: 
                case PREPROCESSOR_DEFINED: {
                    return (CppTokenId)directive.id();
                }
            }
        }
        return CppTokenId.PREPROCESSOR_START;
    }

    public int index() {
        return this.index;
    }

    public TokenItem getNext() {
        this.go();
        while (this.tokenSeq.moveNext()) {
            if (this.skipPP && this.tokenSeq.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) continue;
            return new TokenItem(this.tokenSeq, this.skipPP);
        }
        return null;
    }

    public TokenItem getPrevious() {
        this.go();
        while (this.tokenSeq.movePrevious()) {
            if (this.skipPP && this.tokenSeq.token().id() == CppTokenId.PREPROCESSOR_DIRECTIVE) continue;
            return new TokenItem(this.tokenSeq, this.skipPP);
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj instanceof TokenItem) {
            return ((TokenItem)obj).index == this.index;
        }
        return false;
    }

    public int hashCode() {
        int hash = 5;
        hash = 43 * hash + this.index;
        hash = 43 * hash + (this.tokenId != null ? this.tokenId.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return this.tokenId + "(" + this.index + ")";
    }
}

