/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.modules.cnd.editor.reformat.BracesStack;
import org.netbeans.modules.cnd.editor.reformat.DiffLinkedList;
import org.netbeans.modules.cnd.editor.reformat.ExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.reformat.StackEntry;

public class ContextDetector
extends ExtendedTokenSequence {
    private final BracesStack braces;

    ContextDetector(TokenSequence<CppTokenId> ts, DiffLinkedList diffs, BracesStack braces, int tabSize, boolean expandTabToSpaces) {
        super(ts, diffs, tabSize, expandTabToSpaces);
        this.braces = braces;
    }

    boolean isStatementContinuation() {
        Token<CppTokenId> prev = this.lookPreviousImportant();
        Token<CppTokenId> next = this.lookNextImportant();
        if (this.token().id() == CppTokenId.WHITESPACE && next != null && next.id() == CppTokenId.IDENTIFIER) {
            next = this.lookNextImportant(2);
        }
        if (prev == null || next == null) {
            return false;
        }
        if (next.id() == CppTokenId.IDENTIFIER) {
            if (prev.id() == CppTokenId.IDENTIFIER) {
                return false;
            }
            if (prev.id() == CppTokenId.RPAREN && ((prev = this.lookPreviousStatement()) == null || prev.id() == CppTokenId.IDENTIFIER)) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isQuestionColumn() {
        int index = this.index();
        try {
            int depth = 0;
            while (this.movePrevious()) {
                if (this.braces.lastStatementStart >= this.index()) {
                    boolean bl = false;
                    return bl;
                }
                switch ((CppTokenId)this.token().id()) {
                    case RPAREN: {
                        ++depth;
                        break;
                    }
                    case LPAREN: {
                        if (--depth >= 0) break;
                        boolean bl = false;
                        return bl;
                    }
                    case QUESTION: {
                        if (depth != 0) break;
                        boolean bl = true;
                        return bl;
                    }
                    case LBRACE: 
                    case RBRACE: 
                    case SEMICOLON: {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.moveIndex(index);
            this.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLikeTemplate(Token<CppTokenId> current) {
        int index = this.index();
        try {
            Token<CppTokenId> head;
            boolean back;
            boolean bl = back = current.id() == CppTokenId.GT;
            if (!(back || (head = this.lookPreviousImportant()) != null && head.id() == CppTokenId.IDENTIFIER)) {
                boolean bl2 = false;
                return bl2;
            }
            int depth = 0;
            block18: while (true) {
                if (back) {
                    if (!this.movePrevious()) {
                        boolean bl3 = false;
                        return bl3;
                    }
                } else if (!this.moveNext()) {
                    boolean bl4 = false;
                    return bl4;
                }
                switch ((CppTokenId)this.token().id()) {
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case NEW_LINE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: 
                    case PREPROCESSOR_DIRECTIVE: {
                        continue block18;
                    }
                    case GTGT: {
                        if (back) {
                            depth += 2;
                            continue block18;
                        }
                        if (depth == 1) {
                            boolean bl5 = true;
                            return bl5;
                        }
                        depth -= 2;
                        continue block18;
                    }
                    case GT: {
                        if (back) {
                            ++depth;
                            continue block18;
                        }
                        if (depth == 0) {
                            boolean bl6 = true;
                            return bl6;
                        }
                        --depth;
                        continue block18;
                    }
                    case LT: {
                        if (back) {
                            if (depth == 0) {
                                head = this.lookPreviousImportant();
                                if (head == null || head.id() != CppTokenId.IDENTIFIER) {
                                    boolean bl7 = false;
                                    return bl7;
                                }
                                boolean bl8 = true;
                                return bl8;
                            }
                            --depth;
                            continue block18;
                        }
                        ++depth;
                        continue block18;
                    }
                    case FALSE: 
                    case TRUE: 
                    case INT_LITERAL: 
                    case LONG_LITERAL: 
                    case LONG_LONG_LITERAL: 
                    case FLOAT_LITERAL: 
                    case DOUBLE_LITERAL: 
                    case UNSIGNED_LITERAL: 
                    case UNSIGNED_LONG_LITERAL: 
                    case UNSIGNED_LONG_LONG_LITERAL: 
                    case CHAR_LITERAL: 
                    case RAW_STRING_LITERAL: 
                    case STRING_LITERAL: {
                        continue block18;
                    }
                    case SCOPE: 
                    case STRUCT: 
                    case CLASS: 
                    case CONST: 
                    case VOID: 
                    case UNSIGNED: 
                    case CHAR: 
                    case SHORT: 
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case AMP: 
                    case STAR: 
                    case COMMA: 
                    case IDENTIFIER: {
                        continue block18;
                    }
                }
                break;
            }
            boolean bl9 = false;
            return bl9;
        }
        finally {
            this.moveIndex(index);
            this.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isTypeCast() {
        int index = this.index();
        try {
            boolean findId = false;
            boolean findModifier = false;
            if (this.token().id() == CppTokenId.RPAREN) {
                block27: while (this.movePrevious()) {
                    switch ((CppTokenId)this.token().id()) {
                        case LPAREN: {
                            if (findId) {
                                this.moveIndex(index);
                                this.moveNext();
                                boolean bl = this.checknextAfterCast();
                                return bl;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        case STRUCT: 
                        case CONST: 
                        case VOID: 
                        case UNSIGNED: 
                        case CHAR: 
                        case SHORT: 
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: {
                            boolean bl = true;
                            return bl;
                        }
                        case IDENTIFIER: {
                            findId = true;
                            continue block27;
                        }
                        case AMP: 
                        case STAR: 
                        case LBRACKET: 
                        case RBRACKET: {
                            if (findId) {
                                boolean bl = false;
                                return bl;
                            }
                            findModifier = true;
                            continue block27;
                        }
                        case WHITESPACE: 
                        case ESCAPED_WHITESPACE: 
                        case NEW_LINE: 
                        case LINE_COMMENT: 
                        case DOXYGEN_LINE_COMMENT: 
                        case BLOCK_COMMENT: 
                        case DOXYGEN_COMMENT: 
                        case PREPROCESSOR_DIRECTIVE: {
                            continue block27;
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
            } else if (this.token().id() == CppTokenId.LPAREN) {
                block28: while (this.moveNext()) {
                    switch ((CppTokenId)this.token().id()) {
                        case RPAREN: {
                            if (findId) {
                                boolean bl = this.checknextAfterCast();
                                return bl;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        case STRUCT: 
                        case CONST: 
                        case VOID: 
                        case UNSIGNED: 
                        case CHAR: 
                        case SHORT: 
                        case INT: 
                        case LONG: 
                        case FLOAT: 
                        case DOUBLE: {
                            boolean bl = true;
                            return bl;
                        }
                        case IDENTIFIER: {
                            if (findModifier) {
                                boolean bl = false;
                                return bl;
                            }
                            findId = true;
                            continue block28;
                        }
                        case AMP: 
                        case STAR: 
                        case LBRACKET: 
                        case RBRACKET: {
                            findModifier = true;
                            continue block28;
                        }
                        case WHITESPACE: 
                        case ESCAPED_WHITESPACE: 
                        case NEW_LINE: 
                        case LINE_COMMENT: 
                        case DOXYGEN_LINE_COMMENT: 
                        case BLOCK_COMMENT: 
                        case DOXYGEN_COMMENT: 
                        case PREPROCESSOR_DIRECTIVE: {
                            continue block28;
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.moveIndex(index);
            this.moveNext();
        }
    }

    private boolean checknextAfterCast() {
        Token<CppTokenId> next = this.lookNextImportant();
        if (next != null) {
            String prevCategory = ((CppTokenId)next.id()).primaryCategory();
            if ("number".equals(prevCategory) || "literal".equals(prevCategory) || "character".equals(prevCategory) || "string".equals(prevCategory)) {
                return true;
            }
            switch ((CppTokenId)next.id()) {
                case LPAREN: 
                case IDENTIFIER: 
                case TILDE: {
                    return true;
                }
            }
        }
        return false;
    }

    boolean isPrefixOperator(Token<CppTokenId> current) {
        Token<CppTokenId> previous = this.lookPreviousImportant();
        if (previous != null) {
            String prevCategory = ((CppTokenId)previous.id()).primaryCategory();
            if ("operator".equals(prevCategory)) {
                return true;
            }
            switch ((CppTokenId)previous.id()) {
                case LPAREN: 
                case LBRACE: 
                case RBRACE: 
                case SEMICOLON: 
                case COMMA: 
                case LBRACKET: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    boolean isPostfixOperator(Token<CppTokenId> current) {
        Token<CppTokenId> next = this.lookNextImportant();
        if (next != null) {
            String nextCategory = ((CppTokenId)next.id()).primaryCategory();
            if ("operator".equals(nextCategory)) {
                return true;
            }
            switch ((CppTokenId)next.id()) {
                case RPAREN: 
                case RBRACE: 
                case SEMICOLON: 
                case COMMA: 
                case RBRACKET: {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    OperatorKind getOperatorKind(Token<CppTokenId> current) {
        Token<CppTokenId> previous = this.lookPreviousImportant();
        Token<CppTokenId> next = this.lookNextImportant();
        if (previous != null && next != null) {
            String prevCategory = ((CppTokenId)previous.id()).primaryCategory();
            if ("keyword".equals(prevCategory) || "keyword-directive".equals(prevCategory) || next.id() == CppTokenId.OPERATOR || "separator".equals(prevCategory) && previous.id() != CppTokenId.RPAREN && previous.id() != CppTokenId.RBRACKET) {
                switch ((CppTokenId)current.id()) {
                    case AMP: 
                    case STAR: 
                    case AMPAMP: {
                        return OperatorKind.TYPE_MODIFIER;
                    }
                    case PLUS: 
                    case MINUS: {
                        return OperatorKind.UNARY;
                    }
                }
                return OperatorKind.SEPARATOR;
            }
            if ("operator".equals(prevCategory)) {
                switch ((CppTokenId)previous.id()) {
                    case EQ: 
                    case PLUSEQ: 
                    case MINUSEQ: 
                    case STAREQ: 
                    case SLASHEQ: 
                    case AMPEQ: 
                    case BAREQ: 
                    case CARETEQ: 
                    case PERCENTEQ: 
                    case LTLTEQ: 
                    case GTGTEQ: {
                        switch ((CppTokenId)current.id()) {
                            case AMP: 
                            case STAR: 
                            case PLUS: 
                            case MINUS: {
                                return OperatorKind.UNARY;
                            }
                        }
                        return OperatorKind.SEPARATOR;
                    }
                    case GTGT: 
                    case LT: 
                    case AMPAMP: 
                    case EQEQ: 
                    case LTEQ: 
                    case GTEQ: 
                    case NOTEQ: 
                    case BARBAR: 
                    case SLASH: 
                    case BAR: 
                    case PERCENT: 
                    case LTLT: {
                        switch ((CppTokenId)current.id()) {
                            case AMP: 
                            case STAR: 
                            case PLUS: 
                            case MINUS: {
                                return OperatorKind.UNARY;
                            }
                        }
                        return OperatorKind.SEPARATOR;
                    }
                    case GT: {
                        switch ((CppTokenId)current.id()) {
                            case PLUS: 
                            case MINUS: {
                                return OperatorKind.UNARY;
                            }
                            case GT: 
                            case LT: {
                                return OperatorKind.SEPARATOR;
                            }
                        }
                    }
                }
            }
            if ("number".equals(prevCategory) || "literal".equals(prevCategory) || "character".equals(prevCategory) || "string".equals(prevCategory)) {
                if (current.id() == CppTokenId.GT && this.isLikeTemplate(current)) {
                    return OperatorKind.SEPARATOR;
                }
                return OperatorKind.BINARY;
            }
            String nextCategory = ((CppTokenId)next.id()).primaryCategory();
            if ("keyword".equals(nextCategory)) {
                switch ((CppTokenId)current.id()) {
                    case AMP: 
                    case STAR: 
                    case AMPAMP: {
                        return OperatorKind.BINARY;
                    }
                    case PLUS: 
                    case MINUS: {
                        return OperatorKind.BINARY;
                    }
                }
                return OperatorKind.SEPARATOR;
            }
            if ("number".equals(nextCategory) || "literal".equals(nextCategory) || "character".equals(nextCategory) || "string".equals(nextCategory)) {
                if ("separator".equals(prevCategory) || "operator".equals(prevCategory)) {
                    switch ((CppTokenId)current.id()) {
                        case AMP: 
                        case STAR: 
                        case AMPAMP: {
                            return OperatorKind.TYPE_MODIFIER;
                        }
                        case GT: 
                        case LT: {
                            return OperatorKind.BINARY;
                        }
                    }
                    switch ((CppTokenId)previous.id()) {
                        case RPAREN: 
                        case RBRACKET: {
                            return OperatorKind.BINARY;
                        }
                    }
                    return OperatorKind.UNARY;
                }
                if (previous.id() == CppTokenId.IDENTIFIER && current.id() == CppTokenId.LT && this.isLikeTemplate(current)) {
                    return OperatorKind.SEPARATOR;
                }
                return OperatorKind.BINARY;
            }
            if ((previous.id() == CppTokenId.RPAREN || previous.id() == CppTokenId.RBRACKET) && next.id() == CppTokenId.IDENTIFIER) {
                if (this.isPreviousStatementParen() || this.isPreviousTypeCastParen()) {
                    switch ((CppTokenId)current.id()) {
                        case AMP: 
                        case STAR: 
                        case AMPAMP: {
                            return OperatorKind.TYPE_MODIFIER;
                        }
                        case PLUS: 
                        case MINUS: {
                            return OperatorKind.UNARY;
                        }
                    }
                    return OperatorKind.SEPARATOR;
                }
                return OperatorKind.BINARY;
            }
            if (previous.id() == CppTokenId.IDENTIFIER) {
                if (next.id() == CppTokenId.LPAREN) {
                    if (this.braces.isDeclarationLevel()) {
                        switch ((CppTokenId)current.id()) {
                            case AMP: 
                            case STAR: 
                            case AMPAMP: {
                                return OperatorKind.TYPE_MODIFIER;
                            }
                            case PLUS: 
                            case MINUS: {
                                return OperatorKind.BINARY;
                            }
                        }
                        return OperatorKind.SEPARATOR;
                    }
                    switch ((CppTokenId)current.id()) {
                        case GT: 
                        case LT: {
                            if (this.braces.isDeclarationLevel()) {
                                return OperatorKind.SEPARATOR;
                            }
                            if (!this.isLikeTemplate(current)) break;
                            return OperatorKind.SEPARATOR;
                        }
                    }
                    return OperatorKind.BINARY;
                }
                if ("operator".equals(nextCategory) || "separator".equals(nextCategory)) {
                    switch ((CppTokenId)current.id()) {
                        case AMP: 
                        case STAR: 
                        case AMPAMP: {
                            return OperatorKind.TYPE_MODIFIER;
                        }
                        case PLUS: 
                        case MINUS: {
                            return OperatorKind.BINARY;
                        }
                    }
                    return OperatorKind.SEPARATOR;
                }
                if (next.id() == CppTokenId.IDENTIFIER) {
                    switch ((CppTokenId)current.id()) {
                        case AMP: 
                        case STAR: 
                        case AMPAMP: {
                            if (this.braces.isDeclarationLevel()) {
                                return OperatorKind.TYPE_MODIFIER;
                            }
                            if (this.isLikeForDeclaration()) {
                                return OperatorKind.TYPE_MODIFIER;
                            }
                            if (this.isLikeExpession()) {
                                return OperatorKind.BINARY;
                            }
                            return OperatorKind.SEPARATOR;
                        }
                        case PLUS: 
                        case MINUS: {
                            return OperatorKind.BINARY;
                        }
                    }
                    if (this.braces.isDeclarationLevel()) {
                        return OperatorKind.SEPARATOR;
                    }
                    if (this.isLikeTemplate(current)) {
                        return OperatorKind.SEPARATOR;
                    }
                    if (this.isLikeExpession()) {
                        return OperatorKind.BINARY;
                    }
                    return OperatorKind.SEPARATOR;
                }
            }
        }
        return OperatorKind.SEPARATOR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPreviousStatementParen() {
        int index = this.index();
        try {
            block7: while (this.movePrevious()) {
                switch ((CppTokenId)this.token().id()) {
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case NEW_LINE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: 
                    case PREPROCESSOR_DIRECTIVE: {
                        continue block7;
                    }
                }
                boolean bl = this.isStatementParen();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.moveIndex(index);
            this.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isPreviousTypeCastParen() {
        int index = this.index();
        try {
            block7: while (this.movePrevious()) {
                switch ((CppTokenId)this.token().id()) {
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case NEW_LINE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: 
                    case PREPROCESSOR_DIRECTIVE: {
                        continue block7;
                    }
                }
                boolean bl = this.isTypeCast();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.moveIndex(index);
            this.moveNext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLikeForDeclaration() {
        StackEntry entry = this.braces.peek();
        if (entry == null || entry.getKind() != CppTokenId.FOR) {
            return false;
        }
        int index = this.index();
        int level = 1;
        try {
            block12: while (this.movePrevious()) {
                switch ((CppTokenId)this.token().id()) {
                    case RPAREN: {
                        ++level;
                        continue block12;
                    }
                    case LPAREN: {
                        --level;
                        continue block12;
                    }
                    case FOR: {
                        if (level == 0) {
                            boolean bl = true;
                            return bl;
                        }
                        boolean bl = false;
                        return bl;
                    }
                    case SEMICOLON: 
                    case EQ: {
                        boolean bl = false;
                        return bl;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.moveIndex(index);
            this.moveNext();
        }
    }

    private boolean isStatementParen() {
        if (this.token().id() == CppTokenId.RPAREN) {
            int level = 1;
            while (this.movePrevious()) {
                switch ((CppTokenId)this.token().id()) {
                    case RPAREN: {
                        ++level;
                        break;
                    }
                    case LPAREN: {
                        if (--level != 0) break;
                        Token<CppTokenId> previous = this.lookPreviousImportant();
                        if (previous != null) {
                            switch ((CppTokenId)previous.id()) {
                                case FOR: 
                                case IF: 
                                case WHILE: 
                                case CATCH: 
                                case SWITCH: {
                                    return true;
                                }
                            }
                            block11: while (this.movePrevious()) {
                                switch ((CppTokenId)this.token().id()) {
                                    case WHITESPACE: 
                                    case ESCAPED_WHITESPACE: 
                                    case NEW_LINE: 
                                    case LINE_COMMENT: 
                                    case DOXYGEN_LINE_COMMENT: 
                                    case BLOCK_COMMENT: 
                                    case DOXYGEN_COMMENT: 
                                    case PREPROCESSOR_DIRECTIVE: {
                                        continue block11;
                                    }
                                }
                                return this.index() == this.braces.lastStatementStart;
                            }
                        }
                        return false;
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isLikeExpession() {
        StackEntry entry = this.braces.peek();
        if (entry != null) {
            if (entry.getKind() == CppTokenId.FOR || entry.getKind() == CppTokenId.WHILE || entry.getKind() == CppTokenId.IF) {
                return true;
            }
            if (entry.getImportantKind() != null) {
                switch (entry.getImportantKind()) {
                    case STRUCT: 
                    case CLASS: 
                    case NAMESPACE: 
                    case UNION: 
                    case ENUM: {
                        if (this.braces.parenDepth != 1) break;
                        return false;
                    }
                }
            }
        }
        int index = this.index();
        try {
            block12: while (this.moveNext()) {
                switch ((CppTokenId)this.token().id()) {
                    case WHITESPACE: 
                    case ESCAPED_WHITESPACE: 
                    case NEW_LINE: 
                    case LINE_COMMENT: 
                    case DOXYGEN_LINE_COMMENT: 
                    case BLOCK_COMMENT: 
                    case DOXYGEN_COMMENT: 
                    case PREPROCESSOR_DIRECTIVE: 
                    case IDENTIFIER: {
                        continue block12;
                    }
                    case SEMICOLON: 
                    case COMMA: 
                    case EQ: {
                        boolean bl = false;
                        return bl;
                    }
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.moveIndex(index);
            this.moveNext();
        }
    }

    static enum OperatorKind {
        BINARY,
        UNARY,
        SEPARATOR,
        TYPE_MODIFIER;

    }
}

