/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.common;

import com.sun.javacard.AID;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.javacard.common.AtomicElementRepairer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;

public final class Utils {
    public static final String STRING_ANNOTATION_PREPROCESSOR_JAR_PATH = "lib/api_classic_annotations.jar";
    private static final String RID_PREFERENCES_KEY = "RID";
    private static final SpecificationVersion VERSION_PREPROCESSOR_SUPPORTS_FROM = new SpecificationVersion("3.0.4");
    private static final int FIXED_RID_LENGTH = 10;
    private static final int MAX_PIX_LENGTH = 22;
    public static final String AID_AUTHORITY = "//aid/";
    static byte[] defaultRID;
    private static final Pattern EXE_ARGS_SPLIT;
    private static final Pattern EXE_NOARGS_SPLIT;
    private static final Pattern EXE_PREFIX_SPLIT;
    static final Pattern ARG_VALUE_SPLIT;

    private Utils() {
    }

    public static boolean canUseCompilationPreprocessor(SpecificationVersion javacardVersion) {
        return javacardVersion.compareTo((Object)VERSION_PREPROCESSOR_SUPPORTS_FROM) >= 0;
    }

    @Deprecated
    public static DataObject findDeviceForPlatform(String platform, String card) {
        FileObject deviceFolder = Utils.sfsFolderForDeviceConfigsForPlatformNamed(platform, false);
        if (deviceFolder != null) {
            for (FileObject child : deviceFolder.getChildren()) {
                if (!card.equals(child.getName())) continue;
                try {
                    return DataObject.find((FileObject)child);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return null;
    }

    public static FileObject sfsFolderForDeviceConfigsForPlatformNamed(String name, boolean create) {
        FileObject result;
        String rootPath = "org-netbeans-modules-javacard/servers/";
        FileObject fld = FileUtil.getConfigFile((String)rootPath);
        if (fld == null) {
            try {
                fld = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)rootPath);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        if ((result = fld.getFileObject(name)) == null && create) {
            try {
                result = FileUtil.createFolder((FileObject)fld, (String)name);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return result;
    }

    public static FileObject sfsFolderForDeviceEepromsForPlatformNamed(String name, boolean create) {
        Parameters.notNull((CharSequence)"name", (Object)name);
        String rootPath = "org-netbeans-modules-javacard/eeproms/";
        FileObject fld = FileUtil.getConfigFile((String)rootPath);
        if (fld == null && create) {
            try {
                fld = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)rootPath);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        } else if (fld == null) {
            return null;
        }
        FileObject result = fld.getFileObject(name);
        if (result == null && create) {
            try {
                result = FileUtil.createFolder((FileObject)fld, (String)name);
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return result;
    }

    public static File eepromFileForDevice(String platformName, String deviceName, boolean create) {
        FileObject fld = Utils.sfsFolderForDeviceEepromsForPlatformNamed(platformName, create);
        if (fld != null) {
            String filename = deviceName + '.' + "eprom";
            FileObject fo = fld.getFileObject(filename);
            if (fo == null && create) {
                try {
                    fo = FileUtil.createData((FileObject)fld, (String)filename);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (fo != null) {
                return FileUtil.toFile((FileObject)fo);
            }
        }
        return null;
    }

    public static FileObject sfsFolderForRegisteredJavaPlatforms() {
        FileObject fld = FileUtil.getConfigFile((String)"Services/Platforms/org-netbeans-api-java-Platform");
        return fld;
    }

    public static FileObject sfsFolderForRegisteredJavaPlatforms(String expectedName) {
        FileObject fld = Utils.sfsFolderForRegisteredJavaPlatforms();
        if (expectedName != null) {
            FileObject fo;
            boolean found = false;
            FileObject[] arr$ = fld.getChildren();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && !(found = expectedName.equals((fo = arr$[i$]).getName())); ++i$) {
            }
            if (!found) {
                FileSystem memfs = FileUtil.createMemoryFileSystem();
                try {
                    FileObject dummyFolder = FileUtil.createFolder((FileObject)memfs.getRoot(), (String)"Services/Platforms/org-netbeans-api-java-Platform");
                    FileObject dummyPlatform = dummyFolder.createData(expectedName, "jcplatform");
                    MultiFileSystem mfs = new MultiFileSystem(new FileSystem[]{memfs, FileUtil.getConfigRoot().getFileSystem()});
                    fld = mfs.getRoot().getFileObject("Services/Platforms/org-netbeans-api-java-Platform");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return fld;
    }

    public static Iterable<DataObject> findAllRegisteredJavacardPlatformDataObjects() {
        FileObject fld = Utils.sfsFolderForRegisteredJavaPlatforms();
        LinkedList<DataObject> result = new LinkedList<DataObject>();
        for (FileObject fo : fld.getChildren()) {
            if (!"jcplatform".equals(fo.getExt())) continue;
            try {
                DataObject dob = DataObject.find((FileObject)fo);
                result.add(dob);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return result;
    }

    public static Iterable<FileObject> findAllRegisteredJavacardPlatformFiles() {
        FileObject fld = Utils.sfsFolderForRegisteredJavaPlatforms();
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        for (FileObject fo : fld.getChildren()) {
            if (!"jcplatform".equals(fo.getExt())) continue;
            result.add(fo);
        }
        return result;
    }

    public static void createAPDUScript(File file, String acName, String aid) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(("//Test script for Applet '" + acName + "'\n").getBytes());
            fos.write("\n".getBytes());
            fos.write("powerup;\n".getBytes());
            fos.write(("// Select " + acName + " " + aid + "\n").getBytes());
            fos.write(("0x00 0xA4 0x04 0x00 " + Utils.getAIDStringWithLengthForScript(aid) + " 0x7F;\n").getBytes());
            fos.write("\n".getBytes());
            fos.write("//Send the APDU here\n".getBytes());
            fos.write("//0x80 0xCA 0x00 0x00 <length> <data> 0x7F;\n".getBytes());
            fos.write("\n".getBytes());
            fos.write("powerdown;\n".getBytes());
            fos.close();
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    public static String getAIDStringWithLengthForScript(String aid) {
        StringBuffer sb = new StringBuffer();
        byte[] bytes = Utils.getAIDAsByteArray(aid);
        sb.append(Utils.twoDigitHexWith0x(bytes.length));
        for (byte b : bytes) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(Utils.twoDigitHexWith0x(b));
        }
        return sb.toString();
    }

    public static String getAIDStringForScript(String aid) {
        StringBuffer sb = new StringBuffer();
        for (byte b : Utils.getAIDAsByteArray(aid)) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(Utils.twoDigitHexWith0x(b));
        }
        return sb.toString();
    }

    private static String twoDigitHexWith0x(int value) {
        int l;
        String str = Integer.toHexString(value);
        if (str.length() < 2) {
            str = "0" + str;
        }
        if ((l = str.length()) > 2) {
            str = str.substring(l - 2);
        }
        return "0x" + str;
    }

    public static void checkAID(String aid) throws Exception {
        if (!aid.startsWith(AID_AUTHORITY)) {
            throw new Exception("Invalid AID '" + aid + "'. does not start with //aid/");
        }
        String aidSubStr = aid.substring(AID_AUTHORITY.length());
        int lastIndexofSlash = aidSubStr.lastIndexOf(47);
        if (lastIndexofSlash == -1) {
            throw new Exception("Missing PIX in " + aid);
        }
        if (lastIndexofSlash != aidSubStr.indexOf(47)) {
            throw new Exception("Invalid AID " + aid);
        }
        String RID = aidSubStr.substring(0, lastIndexofSlash);
        String PIX = aidSubStr.substring(lastIndexofSlash + 1);
        if (RID.length() != 10) {
            throw new Exception("Invalid RID " + RID + " in " + aid);
        }
        if (!Utils.isValidHexadecimalNumber(RID)) {
            throw new Exception("RID is not a valid hexadecimal number in " + aid);
        }
        if (PIX.equals("-")) {
            // empty if block
        }
        if (PIX.length() == 0) {
            throw new Exception("Empty PIX in " + aid);
        }
        if (PIX.startsWith("-")) {
            throw new Exception("PIX starts with a \"-\" in  " + aid);
        }
        if (PIX.length() % 2 != 0 || PIX.length() > 22) {
            throw new Exception("Invalid PIX length in  " + aid);
        }
        if (!Utils.isValidHexadecimalNumber(PIX)) {
            throw new Exception("PIX is not a valid hexadecimal number in " + aid);
        }
    }

    public static boolean isValidHexadecimalNumber(String number) {
        for (int startIndex = 0; startIndex < number.length(); startIndex += 2) {
            String smallNumber = number.substring(startIndex, startIndex + 2);
            try {
                Integer.parseInt(smallNumber, 16);
                continue;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public static byte[] getAIDAsByteArray(String aid) {
        String aidSubStr = aid.substring(AID_AUTHORITY.length());
        int lastIndexofSlash = aidSubStr.lastIndexOf(47);
        String RID = lastIndexofSlash != -1 ? aidSubStr.substring(0, lastIndexofSlash) : aidSubStr;
        String PIX = lastIndexofSlash != -1 ? aidSubStr.substring(lastIndexofSlash + 1) : "";
        byte[] aidArray = new byte[RID.length() / 2 + PIX.length() / 2];
        int offset = Utils.getByteArrayForString(RID, aidArray, 0);
        Utils.getByteArrayForString(PIX, aidArray, offset);
        return aidArray;
    }

    public static int getByteArrayForString(String number, byte[] outputArray, int offset) {
        int length = number.length();
        if (length % 2 != 0) {
            throw new NumberFormatException();
        }
        for (int startIndex = 0; startIndex < number.length(); startIndex += 2) {
            String smallNumber = number.substring(startIndex, startIndex + 2);
            outputArray[offset++] = (byte)Integer.parseInt(smallNumber, 16);
        }
        return offset;
    }

    public static String getStringForByteArray(byte[] input) {
        StringBuffer sb = new StringBuffer();
        for (byte num : input) {
            String hex = Integer.toHexString(num & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex);
        }
        return sb.toString().toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getDefaultRID() {
        Class<Utils> clazz = Utils.class;
        synchronized (Utils.class) {
            if (defaultRID != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return defaultRID;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            String rid = NbPreferences.forModule(Utils.class).get(RID_PREFERENCES_KEY, null);
            if (rid == null) {
                Random r = new Random(System.currentTimeMillis());
                byte[] result = new byte[5];
                r.nextBytes(result);
                String hex = Utils.getStringForByteArray(result);
                NbPreferences.forModule(Utils.class).put(RID_PREFERENCES_KEY, hex);
                Class<Utils> clazz2 = Utils.class;
                synchronized (Utils.class) {
                    defaultRID = result;
                    // ** MonitorExit[var4_7] (shouldn't be in output)
                    return result;
                }
            }
            byte[] b = new byte[rid.length() / 2];
            Utils.getByteArrayForString(rid, b, 0);
            Class<Utils> clazz3 = Utils.class;
            synchronized (Utils.class) {
                defaultRID = b;
                // ** MonitorExit[var2_5] (shouldn't be in output)
                return b;
            }
        }
    }

    public static String getDefaultRIDasString() {
        byte[] b = Utils.getDefaultRID();
        return Utils.getStringForByteArray(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultRID(String rid) {
        if (rid.trim().length() != 10) {
            throw new IllegalArgumentException(NbBundle.getMessage(Utils.class, (String)"Must_be_exactly_5_bytes", (Object)rid));
        }
        byte[] b = new byte[rid.length() / 2];
        try {
            Utils.getByteArrayForString(rid, b, 0);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(NbBundle.getMessage(Utils.class, (String)"Invalid_hexadecimal_number"));
        }
        NbPreferences.forModule(Utils.class).put(RID_PREFERENCES_KEY, rid);
        Class<Utils> clazz = Utils.class;
        synchronized (Utils.class) {
            defaultRID = b;
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return;
        }
    }

    public static AID generateAppletAID(byte[] RID, String fqn) {
        return AID.generateApplicationAid((byte[])Utils.getDefaultRID(), (String)fqn);
    }

    public static AID generatePackageAid(String packageName) {
        byte[] RID = Utils.getDefaultRID();
        return AID.generatePackageAid((byte[])RID, (String)packageName);
    }

    public static AID generateAppletAID(String packageName, String clazz) {
        byte[] RID = Utils.getDefaultRID();
        return AID.generateApplicationAid((byte[])RID, (String)packageName, (String)clazz);
    }

    public static AID generateInstanceAid(String packageName, String clazz) {
        byte[] RID = Utils.getDefaultRID();
        return AID.generateInstanceAid((byte[])RID, (String)packageName, (String)clazz);
    }

    public static AID generateRandomAppletAid(String clazz) {
        byte[] RID = Utils.getDefaultRID();
        return AID.generateApplicationAid((byte[])RID, (String)Utils.generateRandomPackageName(), (String)clazz);
    }

    public static String generateRandomPackageName() {
        StringBuilder sb = new StringBuilder();
        Random r = new Random(System.currentTimeMillis());
        for (int i = 0; i < 4; ++i) {
            int ct = r.nextInt(3) + 3;
            for (int j = 0; j < ct; ++j) {
                if (j == 0) {
                    sb.append('.');
                }
                int charVal = r.nextInt(25) + 97;
                sb.append((char)charVal);
            }
        }
        return sb.toString();
    }

    public static AID generateRandomPackageAid() {
        return AID.generatePackageAid((byte[])Utils.getDefaultRID(), (String)Utils.generateRandomPackageName());
    }

    public static DataObject findPlatformDataObjectNamed(String name) {
        if (name == null || "".equals(name)) {
            return null;
        }
        for (FileObject fo : Utils.sfsFolderForRegisteredJavaPlatforms().getChildren()) {
            if (!name.equals(fo.getName())) continue;
            try {
                DataObject result = DataObject.find((FileObject)fo);
                return result;
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return null;
    }

    public static final String[] shellSplit(String s) {
        String argsPart;
        String exePart;
        List<String> result = new ArrayList<String>();
        Matcher m = EXE_ARGS_SPLIT.matcher(s);
        if (m.find()) {
            exePart = m.group(1).trim();
            if (exePart.trim().length() == 0) {
                exePart = null;
            }
            argsPart = "-" + m.group(2).trim();
        } else {
            m = EXE_NOARGS_SPLIT.matcher(s);
            if (m.find()) {
                exePart = m.group(1);
                if (exePart.trim().length() == 0) {
                    exePart = null;
                }
                argsPart = m.group(2);
            } else {
                exePart = null;
                argsPart = s;
            }
        }
        if (exePart != null) {
            m = EXE_PREFIX_SPLIT.matcher(exePart);
            String exePrefix = null;
            if (m.find()) {
                exePrefix = exePart.substring(0, m.start(1));
                result.addAll(Arrays.asList(exePrefix.split("\\s+")));
                result.add(m.group(1));
            } else {
                result.add(exePart.trim());
            }
        }
        if (!Utils.splitArgs(argsPart, result)) {
            result.add(argsPart);
        }
        result = Utils.restoreAtomicArguments(s, result);
        ArrayList<String> fixedUp = new ArrayList<String>();
        for (String str : result) {
            if ("".equals(str) || str == null) continue;
            fixedUp.add(str.trim());
        }
        return fixedUp.toArray(new String[fixedUp.size()]);
    }

    private static List<String> restoreAtomicArguments(String s, List<String> l) {
        if (l.size() == 0) {
            return l;
        }
        int startIx = s.indexOf("{{{");
        if (startIx <= 0 || s.indexOf("}}}") <= startIx) {
            return l;
        }
        return new AtomicElementRepairer(l).restoreAtomicItems();
    }

    static boolean splitArgs(String argsPart, List<String> result) {
        String remainder;
        Matcher m = ARG_VALUE_SPLIT.matcher(argsPart);
        int end = -1;
        boolean res = false;
        while (m.find()) {
            res = true;
            for (int i = 1; i <= m.groupCount(); ++i) {
                String arg = m.group(i);
                if (arg != null) {
                    result.add(arg);
                }
                end = m.end();
            }
        }
        if (res && end != -1 && end < argsPart.length() - 1 && !Utils.splitArgs(remainder = argsPart.substring(end - 1), result)) {
            result.add(remainder);
        }
        return res;
    }

    static {
        EXE_ARGS_SPLIT = Pattern.compile("^(.*?)\\s+\\-(\\-*\\w.*)");
        EXE_NOARGS_SPLIT = Pattern.compile("^(.*?)\\s(.*)$");
        EXE_PREFIX_SPLIT = Pattern.compile("(\\S*" + Pattern.quote(File.separator) + ".*)$");
        ARG_VALUE_SPLIT = Pattern.compile("^\\s*(\\-\\S*)\\s*?((?!\\-)\\S.*?)?(?:\\s\\-|$)");
    }
}

