/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.awt.Color;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.UIManager;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.project.WebProject;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public class Utils {
    private static final Logger UI_LOGGER = Logger.getLogger("org.netbeans.ui.web.project");
    public static final String USG_LOGGER_NAME = "org.netbeans.ui.metrics.web.project";
    private static final Logger USG_LOGGER = Logger.getLogger("org.netbeans.ui.metrics.web.project");
    private static final String[] JAVA_KEYWORDS = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throws", "transient", "try", "void", "volatile", "while"};
    private static final String JSP_PACKAGE_NAME = "org.apache.jsp";
    private static final String PLATFORM_ANT_NAME = "platform.ant.name";
    public static final String SPECIFICATION_J2SE = "j2se";

    public static String createDefaultContext(String projectName) {
        return "/" + PropertyUtils.getUsablePropertyName((String)projectName);
    }

    public static void updateProperties(AntProjectHelper h, String path, EditableProperties ep) {
        EditableProperties properties = h.getProperties(path);
        properties.putAll((Map)ep);
        h.putProperties(path, properties);
    }

    public static boolean isParentOrEqual(File folder, File file) {
        if (folder != null || file != null) {
            folder = FileUtil.normalizeFile((File)folder);
            for (file = FileUtil.normalizeFile((File)file); file != null; file = file.getParentFile()) {
                if (!file.equals(folder)) continue;
                return true;
            }
        }
        return false;
    }

    public static JavaPlatform findJ2seJavaPlatform(String platformName) {
        return Utils.findJavaPlatform(platformName, SPECIFICATION_J2SE);
    }

    public static JavaPlatform findJavaPlatform(String platformName) {
        return Utils.findJavaPlatform(platformName, null);
    }

    public static String getDefaultDebugClassPath() {
        return "${build.classes.dir}:${javac.classpath}";
    }

    public static String correctDebugClassPath(String debugClassPath) {
        if (debugClassPath == null || debugClassPath.length() == 0) {
            return Utils.getDefaultDebugClassPath();
        }
        String buildEarWebDir = "${build.ear.web.dir}";
        String buildEarClassesDir = "${build.ear.classes.dir}";
        String buildEarPrefix = "${build.ear.";
        if (!debugClassPath.contains("${build.ear.")) {
            return debugClassPath;
        }
        StringBuilder buffer = new StringBuilder(debugClassPath.length());
        for (String token : PropertyUtils.tokenizePath((String)debugClassPath)) {
            if ("${build.ear.web.dir}".equals(token) || "${build.ear.classes.dir}".equals(token)) continue;
            if (buffer.length() > 0) {
                buffer.append(":");
            }
            buffer.append(token);
        }
        return buffer.toString();
    }

    private static JavaPlatform findJavaPlatform(String platformName, String specFilter) {
        if (platformName != null) {
            JavaPlatform[] platforms = JavaPlatformManager.getDefault().getInstalledPlatforms();
            for (int i = 0; i < platforms.length; ++i) {
                JavaPlatform platform = platforms[i];
                String antName = (String)platform.getProperties().get(PLATFORM_ANT_NAME);
                if (antName == null || !antName.equals(platformName) || specFilter != null && !specFilter.equalsIgnoreCase(platform.getSpecification().getName())) continue;
                return platform;
            }
        }
        return null;
    }

    static String getGeneratedJavaResource(String jspUri) {
        int iSep = jspUri.lastIndexOf(47);
        String packageName = iSep > 0 ? Utils.makeJavaPackage(jspUri.substring(0, iSep)) : "";
        packageName = packageName.length() == 0 ? JSP_PACKAGE_NAME : "org.apache.jsp." + packageName;
        String className = Utils.makeJavaIdentifier(jspUri.substring(iSep + 1));
        return packageName.replace('.', '/') + "/" + className + ".java";
    }

    private static String makeJavaPackage(String path) {
        String[] classNameComponents = Utils.split(path, "/");
        StringBuilder legalClassNames = new StringBuilder();
        for (int i = 0; i < classNameComponents.length; ++i) {
            legalClassNames.append(Utils.makeJavaIdentifier(classNameComponents[i]));
            if (i >= classNameComponents.length - 1) continue;
            legalClassNames.append('.');
        }
        return legalClassNames.toString();
    }

    private static String[] split(String path, String pat) {
        Vector<String> comps = new Vector<String>();
        int pos = path.indexOf(pat);
        int start = 0;
        while (pos >= 0) {
            if (pos > start) {
                String comp = path.substring(start, pos);
                comps.add(comp);
            }
            start = pos + pat.length();
            pos = path.indexOf(pat, start);
        }
        if (start < path.length()) {
            comps.add(path.substring(start));
        }
        String[] result = new String[comps.size()];
        for (int i = 0; i < comps.size(); ++i) {
            result[i] = (String)comps.elementAt(i);
        }
        return result;
    }

    private static String makeJavaIdentifier(String identifier) {
        StringBuilder modifiedIdentifier = new StringBuilder(identifier.length());
        if (!Character.isJavaIdentifierStart(identifier.charAt(0))) {
            modifiedIdentifier.append('_');
        }
        for (int i = 0; i < identifier.length(); ++i) {
            char ch = identifier.charAt(i);
            if (Character.isJavaIdentifierPart(ch) && ch != '_') {
                modifiedIdentifier.append(ch);
                continue;
            }
            if (ch == '.') {
                modifiedIdentifier.append('_');
                continue;
            }
            modifiedIdentifier.append(Utils.mangleChar(ch));
        }
        if (Utils.isJavaKeyword(modifiedIdentifier.toString())) {
            modifiedIdentifier.append('_');
        }
        return modifiedIdentifier.toString();
    }

    private static String mangleChar(char ch) {
        char[] result = new char[]{'_', Character.forDigit(ch >> 12 & 0xF, 16), Character.forDigit(ch >> 8 & 0xF, 16), Character.forDigit(ch >> 4 & 0xF, 16), Character.forDigit(ch & 0xF, 16)};
        return new String(result);
    }

    private static boolean isJavaKeyword(String key) {
        return Arrays.binarySearch(JAVA_KEYWORDS, key) >= 0;
    }

    public static Color getErrorColor() {
        Color c = UIManager.getColor("nb.errorForeground");
        return c == null ? new Color(89, 79, 191) : c;
    }

    public static void logUI(ResourceBundle bundle, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        Parameters.notNull((CharSequence)"bundle", (Object)bundle);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(UI_LOGGER.getName());
        logRecord.setResourceBundle(bundle);
        if (params != null) {
            logRecord.setParameters(params);
        }
        UI_LOGGER.log(logRecord);
    }

    public static void logUsage(Class srcClass, String message, Object[] params) {
        Parameters.notNull((CharSequence)"message", (Object)message);
        LogRecord logRecord = new LogRecord(Level.INFO, message);
        logRecord.setLoggerName(USG_LOGGER.getName());
        logRecord.setResourceBundle(NbBundle.getBundle((Class)srcClass));
        logRecord.setResourceBundleName(srcClass.getPackage().getName() + ".Bundle");
        if (params != null) {
            logRecord.setParameters(params);
        }
        USG_LOGGER.log(logRecord);
    }

    @NonNull
    public static String getServletName(FileObject docBase, FileObject jsp) {
        String jspRelativePath = FileUtil.getRelativePath((FileObject)docBase, (FileObject)jsp);
        return Utils.getServletResourcePath(null, jspRelativePath);
    }

    @NonNull
    public static String getServletResourcePath(String moduleContextPath, String jspResourcePath) {
        return Utils.getServletPackageName(jspResourcePath).replace('.', '/') + '/' + Utils.getServletClassName(jspResourcePath) + ".java";
    }

    @NonNull
    private static String getServletPackageName(String jspUri) {
        String dPackageName = Utils.getDerivedPackageName(jspUri);
        if (dPackageName.length() == 0) {
            return JSP_PACKAGE_NAME;
        }
        return "org.apache.jsp." + Utils.getDerivedPackageName(jspUri);
    }

    private static String getDerivedPackageName(String jspUri) {
        int iSep = jspUri.lastIndexOf(47);
        return iSep > 0 ? Utils.makeJavaPackage(jspUri.substring(0, iSep)) : "";
    }

    private static String getServletClassName(String jspUri) {
        int iSep = jspUri.lastIndexOf(47) + 1;
        return Utils.makeJavaIdentifier(jspUri.substring(iSep));
    }

    public static URL getRootURL(File root, String offset) throws MalformedURLException {
        URL url = FileUtil.urlForArchiveOrDir((File)root);
        if (offset != null) {
            assert (offset.endsWith("/"));
            url = new URL(url.toExternalForm() + offset);
        }
        return url;
    }

    public static LibraryChooser.Filter getFilter(WebProject p) {
        LibraryChooser.Filter filter = null;
        WebModule wm = WebModule.getWebModule((FileObject)p.getProjectDirectory());
        if (wm != null && Profile.J2EE_13.equals(wm.getJ2eeProfile())) {
            filter = new LibraryChooser.Filter(){

                public boolean accept(Library library) {
                    if ("javascript".equals(library.getType())) {
                        return false;
                    }
                    try {
                        library.getContent("classpath");
                    }
                    catch (IllegalArgumentException ex) {
                        return false;
                    }
                    return !library.getName().matches("jstl11|jaxrpc16|Spring|jaxws20|jaxb20|struts|jsf");
                }
            };
        }
        return filter;
    }

    public static boolean isLibraryDirectoryBased(ClassPathSupport.Item item) {
        assert (item.getType() == 1) : item;
        Library l = item.getLibrary();
        if (l == null) {
            return false;
        }
        List cp = l.getContent("classpath");
        return cp.size() > 0 && ((URL)cp.get(0)).toString().startsWith("file:");
    }
}

