/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.project;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import org.netbeans.modules.j2ee.common.DatasourceUIHelper;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.common.api.Datasource;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSource;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourcePopulator;
import org.netbeans.modules.j2ee.persistence.spi.datasource.JPADataSourceProvider;
import org.netbeans.modules.web.project.WebProject;

public class WebJPADataSourceSupport
implements JPADataSourcePopulator,
JPADataSourceProvider {
    private final WebProject project;

    public WebJPADataSourceSupport(WebProject project) {
        this.project = project;
    }

    public void connect(JComboBox comboBox) {
        DatasourceUIHelper.connect((J2eeModuleProvider)this.project.getWebModule(), (JComboBox)comboBox);
    }

    public List<JPADataSource> getDataSources() {
        ArrayList datasources = new ArrayList();
        try {
            datasources.addAll(this.project.getWebModule().getModuleDatasources());
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        try {
            datasources.addAll(this.project.getWebModule().getServerDatasources());
        }
        catch (ConfigurationException e) {
            // empty catch block
        }
        ArrayList<JPADataSource> result = new ArrayList<JPADataSource>(datasources.size());
        for (Datasource each : datasources) {
            result.add(new DatasourceWrapper(each));
        }
        return result;
    }

    public JPADataSource toJPADataSource(Object dataSource) {
        if (dataSource instanceof JPADataSource) {
            return (JPADataSource)dataSource;
        }
        if (dataSource instanceof Datasource) {
            return new DatasourceWrapper((Datasource)dataSource);
        }
        return null;
    }

    private static class DatasourceWrapper
    implements Datasource,
    JPADataSource {
        private Datasource delegate;

        DatasourceWrapper(Datasource datasource) {
            this.delegate = datasource;
        }

        public String getJndiName() {
            return this.delegate.getJndiName();
        }

        public String getUrl() {
            return this.delegate.getUrl();
        }

        public String getUsername() {
            return this.delegate.getUsername();
        }

        public String getPassword() {
            return this.delegate.getPassword();
        }

        public String getDriverClassName() {
            return this.delegate.getDriverClassName();
        }

        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }

        public String toString() {
            return this.delegate.toString();
        }
    }
}

