/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import java.util.HashSet;
import java.util.Set;
import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.AbstractDatatype;
import org.whattf.datatype.Html5DatatypeLibrary;
import org.whattf.datatype.Iri;

abstract class AbstractRel
extends AbstractDatatype {
    AbstractRel() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        HashSet<String> tokensSeen = new HashSet<String>();
        StringBuilder builder = new StringBuilder();
        int len = literal.length();
        for (int i = 0; i < len; ++i) {
            char c = literal.charAt(i);
            if (this.isWhitespace(c) && builder.length() > 0) {
                this.checkToken(builder, i, tokensSeen);
                builder.setLength(0);
                continue;
            }
            builder.append(AbstractRel.toAsciiLowerCase(c));
        }
        if (builder.length() > 0) {
            this.checkToken(builder, len, tokensSeen);
        }
    }

    private void checkToken(StringBuilder builder, int i, Set<String> tokensSeen) throws DatatypeException {
        String token = builder.toString();
        if (tokensSeen.contains(token)) {
            throw this.newDatatypeException(i - 1, "Duplicate keyword ", token, ".");
        }
        tokensSeen.add(token);
        if (!this.isRegistered(token)) {
            try {
                Html5DatatypeLibrary dl = new Html5DatatypeLibrary();
                Iri iri = (Iri)dl.createDatatype("iri");
                iri.checkValid(token);
            }
            catch (DatatypeException e) {
                throw this.newDatatypeException(i - 1, "The string ", token, " is not a registered keyword or absolute URL.");
            }
        }
    }

    protected abstract boolean isRegistered(String var1);
}

