/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.AbstractDatatype;

public class MimeType
extends AbstractDatatype {
    public static final MimeType THE_INSTANCE = new MimeType();

    private MimeType() {
    }

    @Override
    public void checkValid(CharSequence literal) throws DatatypeException {
        State state = State.AT_START;
        block23: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            switch (state) {
                case AT_START: {
                    if (this.isTokenChar(c)) {
                        state = State.IN_SUPERTYPE;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a token character but saw ", c, " instead.");
                }
                case IN_SUPERTYPE: {
                    if (this.isTokenChar(c)) continue block23;
                    if (c == '/') {
                        state = State.AT_SUBTYPE_START;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a token character or \u201c/\u201d but saw ", c, " instead.");
                }
                case AT_SUBTYPE_START: {
                    if (this.isTokenChar(c)) {
                        state = State.IN_SUBTYPE;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a token character but saw ", c, " instead.");
                }
                case IN_SUBTYPE: {
                    if (this.isTokenChar(c)) continue block23;
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        continue block23;
                    }
                    if (this.isWhitespace(c)) {
                        state = State.WS_BEFORE_SEMICOLON;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a token character, whitespace or a semicolon but saw ", c, " instead.");
                }
                case WS_BEFORE_SEMICOLON: {
                    if (this.isWhitespace(c)) continue block23;
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected whitespace or a semicolon but saw ", c, " instead.");
                }
                case SEMICOLON_SEEN: {
                    if (this.isWhitespace(c)) continue block23;
                    if (this.isTokenChar(c)) {
                        state = State.IN_PARAM_NAME;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected whitespace or a token character but saw ", c, " instead.");
                }
                case IN_PARAM_NAME: {
                    if (this.isTokenChar(c)) continue block23;
                    if (c == '=') {
                        state = State.EQUALS_SEEN;
                        continue block23;
                    }
                }
                case EQUALS_SEEN: {
                    if (c == '\"') {
                        state = State.IN_QUOTED_STRING;
                        continue block23;
                    }
                    if (this.isTokenChar(c)) {
                        state = State.IN_UNQUOTED_STRING;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a double quote or a token character but saw ", c, " instead.");
                }
                case IN_QUOTED_STRING: {
                    if (c == '\\') {
                        state = State.IN_QUOTED_PAIR;
                        continue block23;
                    }
                    if (c == '\"') {
                        state = State.CLOSE_QUOTE_SEEN;
                        continue block23;
                    }
                    if (this.isQDTextChar(c)) continue block23;
                    throw this.newDatatypeException(i, "Expected a non-control ASCII character but saw ", c, " instead.");
                }
                case IN_QUOTED_PAIR: {
                    if (c <= '\u007f') {
                        state = State.IN_QUOTED_STRING;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected an ASCII character but saw ", c, " instead.");
                }
                case CLOSE_QUOTE_SEEN: {
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        continue block23;
                    }
                    if (this.isWhitespace(c)) {
                        state = State.WS_BEFORE_SEMICOLON;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected an ASCII character but saw ", c, " instead.");
                }
                case IN_UNQUOTED_STRING: {
                    if (this.isTokenChar(c)) continue block23;
                    if (c == ';') {
                        state = State.SEMICOLON_SEEN;
                        continue block23;
                    }
                    if (this.isWhitespace(c)) {
                        state = State.WS_BEFORE_SEMICOLON;
                        continue block23;
                    }
                    throw this.newDatatypeException(i, "Expected a token character, whitespace or a semicolon but saw ", c, " instead.");
                }
            }
        }
        switch (state) {
            case IN_SUBTYPE: 
            case CLOSE_QUOTE_SEEN: 
            case IN_UNQUOTED_STRING: {
                return;
            }
            case AT_START: {
                throw this.newDatatypeException("Expected a MIME type but saw the empty string.");
            }
            case IN_SUPERTYPE: 
            case AT_SUBTYPE_START: {
                throw this.newDatatypeException(literal.length() - 1, "Subtype missing.");
            }
            case IN_PARAM_NAME: 
            case EQUALS_SEEN: {
                throw this.newDatatypeException(literal.length() - 1, "Parameter value missing.");
            }
            case IN_QUOTED_STRING: 
            case IN_QUOTED_PAIR: {
                throw this.newDatatypeException(literal.length() - 1, "Unfinished quoted string.");
            }
            case SEMICOLON_SEEN: {
                throw this.newDatatypeException(literal.length() - 1, "Semicolon seen but there was no parameter following it.");
            }
            case WS_BEFORE_SEMICOLON: {
                throw this.newDatatypeException(literal.length() - 1, "Extraneous trailing whitespace.");
            }
        }
    }

    private boolean isQDTextChar(char c) {
        return c >= ' ' && c <= '~' || c == '\n' || c == '\r' || c == '\t';
    }

    private boolean isTokenChar(char c) {
        return c >= '!' && c <= '~' && c != '(' && c != ')' && c != '<' && c != '>' && c != '@' && c != ',' && c != ';' && c != ':' && c != '\\' && c != '\"' && c != '/' && c != '[' && c != ']' && c != '?' && c != '=' && c != '{' && c != '}';
    }

    @Override
    public String getName() {
        return "MIME type";
    }

    private static enum State {
        AT_START,
        IN_SUPERTYPE,
        AT_SUBTYPE_START,
        IN_SUBTYPE,
        SEMICOLON_SEEN,
        WS_BEFORE_SEMICOLON,
        IN_PARAM_NAME,
        EQUALS_SEEN,
        IN_QUOTED_STRING,
        IN_UNQUOTED_STRING,
        IN_QUOTED_PAIR,
        CLOSE_QUOTE_SEEN;

    }
}

