/*
 * Decompiled with CFR 0.152.
 */
package org.whattf.datatype;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.relaxng.datatype.DatatypeException;
import org.whattf.datatype.AbstractDatatype;

public final class Month
extends AbstractDatatype {
    public static final Month THE_INSTANCE = new Month();
    private static final Pattern THE_PATTERN = Pattern.compile("^([0-9]{4,})-([0-9]{2})$");

    private Month() {
    }

    private void checkMonth(String year, String month) throws DatatypeException {
        this.checkMonth(Integer.parseInt(year), Integer.parseInt(month));
    }

    private void checkMonth(int year, int month) throws DatatypeException {
        if (year < 1) {
            throw this.newDatatypeException("Year cannot be less than 1.");
        }
        if (month < 1) {
            throw this.newDatatypeException("Month cannot be less than 1.");
        }
        if (month > 12) {
            throw this.newDatatypeException("Month cannot be greater than 12.");
        }
    }

    @Override
    public final void checkValid(CharSequence literal) throws DatatypeException {
        Matcher m = THE_PATTERN.matcher(literal);
        if (!m.matches()) {
            throw this.newDatatypeException("The literal did not satisfy the format for month.");
        }
        this.checkMonth(m.group(1), m.group(2));
    }

    @Override
    public String getName() {
        return "month";
    }
}

