/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.standalone;

import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.standalone.StaticResourcesAdapter;
import com.sun.enterprise.web.connector.grizzly.standalone.StaticStreamAlgorithm;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.coyote.Adapter;

public class Main {
    private static final String SELECTOR_THREAD = "com.sun.enterprise.web.connector.grizzly.selectorThread";
    private static final String ADAPTER = "com.sun.grizzly.adapterClass";
    static int port = 8080;
    static String folder = ".";

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        Main.start(args);
    }

    private static void start(String[] args) throws Exception {
        try {
            if (args != null && args.length > 0) {
                port = Integer.parseInt(args[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (args != null && args.length > 1) {
                folder = args[1];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        File libDir = new File("lib");
        if (libDir.exists()) {
            if (libDir.isDirectory()) {
                String[] jars = libDir.list(new FilenameFilter(){

                    public boolean accept(File dir, String name) {
                        return name.endsWith(".jar") || name.endsWith(".zip");
                    }
                });
                URL[] urls = new URL[jars.length];
                for (int i = 0; i < jars.length; ++i) {
                    String path = new File("lib" + File.separator + jars[i]).getCanonicalFile().toURL().toString();
                    urls[i] = new URL(path);
                }
                URLClassLoader urlClassloader = new URLClassLoader(urls, Main.class.getClassLoader());
                Thread.currentThread().setContextClassLoader(urlClassloader);
            }
        } else {
            System.out.println("lib folder is missing");
        }
        SelectorThread selectorThread = null;
        String selectorThreadClassname = System.getProperty(SELECTOR_THREAD);
        if (selectorThreadClassname != null) {
            selectorThread = (SelectorThread)Main.loadInstance(selectorThreadClassname);
        } else {
            selectorThread = new SelectorThread();
            selectorThread.setAlgorithmClassName(StaticStreamAlgorithm.class.getName());
        }
        selectorThread.setPort(port);
        SelectorThread.setWebAppRootPath(folder);
        String adapterClass = System.getProperty(ADAPTER);
        StaticResourcesAdapter adapter = adapterClass == null ? new StaticResourcesAdapter() : (Adapter)Main.loadInstance(adapterClass);
        selectorThread.setAdapter(adapter);
        selectorThread.setDisplayConfiguration(true);
        selectorThread.initEndpoint();
        selectorThread.startEndpoint();
    }

    private static Object loadInstance(String property) {
        Class<?> className = null;
        try {
            className = Class.forName(property, true, Thread.currentThread().getContextClassLoader());
            return className.newInstance();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }
}

