/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.javaee;

import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.modules.glassfish.javaee.Hk2JavaEEPlatformImpl;
import org.netbeans.modules.javaee.specs.support.api.JaxWs;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.api.WSStackVersion;
import org.netbeans.modules.websvc.wsstack.api.WSTool;
import org.netbeans.modules.websvc.wsstack.spi.WSStackFactory;
import org.netbeans.modules.websvc.wsstack.spi.WSStackImplementation;
import org.netbeans.modules.websvc.wsstack.spi.WSToolImplementation;

public class Hk2JaxWsStack
implements WSStackImplementation<JaxWs> {
    private static final String[] METRO_LIBRARIES = new String[]{"webservices(|-osgi).jar", "webservices-api(|-osgi).jar", "jaxb(|-osgi).jar", "jaxb-api(|-osgi).jar", "javax.ejb.jar", "javax.activation.jar"};
    private static final String GFV3_MODULES_DIR_NAME = "modules";
    private String gfRootStr;
    private JaxWs jaxWs;
    private Hk2JavaEEPlatformImpl platform;

    public Hk2JaxWsStack(String gfRootStr, Hk2JavaEEPlatformImpl platform) {
        this.gfRootStr = gfRootStr;
        this.jaxWs = new JaxWs(this.getUriDescriptor());
        this.platform = platform;
    }

    public JaxWs get() {
        return this.jaxWs;
    }

    public WSStackVersion getVersion() {
        Set<Profile> supportedProfiles = this.platform.getSupportedProfiles();
        if (supportedProfiles.contains(Profile.JAVA_EE_6_FULL) || supportedProfiles.contains(Profile.JAVA_EE_6_WEB)) {
            if (this.isMetroInstalled()) {
                return WSStackVersion.valueOf((int)2, (int)2, (int)0, (int)0);
            }
            return WSStackVersion.valueOf((int)2, (int)1, (int)4, (int)1);
        }
        if (this.isMetroInstalled()) {
            return WSStackVersion.valueOf((int)2, (int)1, (int)4, (int)1);
        }
        return WSStackVersion.valueOf((int)2, (int)1, (int)3, (int)0);
    }

    public WSTool getWSTool(WSStack.Tool toolId) {
        if (toolId == JaxWs.Tool.WSIMPORT) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSIMPORT));
        }
        if (toolId == JaxWs.Tool.WSGEN) {
            return WSStackFactory.createWSTool((WSToolImplementation)new JaxWsTool(JaxWs.Tool.WSGEN));
        }
        return null;
    }

    public boolean isFeatureSupported(WSStack.Feature feature) {
        if (feature == JaxWs.Feature.WSIT && this.isMetroInstalled()) {
            return true;
        }
        if (feature == JaxWs.Feature.JSR109 && this.isMetroInstalled()) {
            return true;
        }
        return feature == JaxWs.Feature.TESTER_PAGE;
    }

    private JaxWs.UriDescriptor getUriDescriptor() {
        return new JaxWs.UriDescriptor(){

            public String getServiceUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                if (isEjb) {
                    return serviceName + "/" + portName;
                }
                if (applicationRoot == null || applicationRoot.length() == 0) {
                    return serviceName;
                }
                StringBuilder builder = new StringBuilder(applicationRoot);
                builder.append('/');
                builder.append(serviceName);
                return builder.toString();
            }

            public String getDescriptorUri(String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return this.getServiceUri(applicationRoot, serviceName, portName, isEjb) + "?wsdl";
            }

            public String getTesterPageUri(String host, String port, String applicationRoot, String serviceName, String portName, boolean isEjb) {
                return "http://" + host + ":" + port + "/" + this.getServiceUri(applicationRoot, serviceName, portName, isEjb) + "?Tester";
            }
        };
    }

    protected boolean isMetroInstalled() {
        File f = Hk2JaxWsStack.getWsJarName(this.gfRootStr, METRO_LIBRARIES[0]);
        return f != null && f.exists();
    }

    public static File getWsJarName(String glassfishInstallRoot, String jarNamePattern) {
        File[] candidates1;
        File[] candidates;
        File modulesDir = new File(glassfishInstallRoot + File.separatorChar + GFV3_MODULES_DIR_NAME);
        int subindex = jarNamePattern.lastIndexOf("/");
        if (subindex != -1) {
            String subdir = jarNamePattern.substring(0, subindex);
            jarNamePattern = jarNamePattern.substring(subindex + 1);
            modulesDir = new File(modulesDir, subdir);
        }
        if ((candidates = modulesDir.listFiles(new VersionFilter(jarNamePattern))) != null && candidates.length > 0) {
            return candidates[0];
        }
        File endorsed = new File(modulesDir, "endorsed");
        if (endorsed != null && endorsed.isDirectory() && (candidates1 = endorsed.listFiles(new VersionFilter(jarNamePattern))) != null && candidates1.length > 0) {
            return candidates1[0];
        }
        return null;
    }

    private static class VersionFilter
    implements FileFilter {
        private final Pattern pattern;

        public VersionFilter(String namePattern) {
            this.pattern = Pattern.compile(namePattern);
        }

        @Override
        public boolean accept(File file) {
            return this.pattern.matcher(file.getName()).matches();
        }
    }

    protected class JaxWsTool
    implements WSToolImplementation {
        JaxWs.Tool tool;

        JaxWsTool(JaxWs.Tool tool) {
            this.tool = tool;
        }

        public String getName() {
            return this.tool.getName();
        }

        public URL[] getLibraries() {
            ArrayList<URL> cPath = new ArrayList<URL>();
            if (Hk2JaxWsStack.this.isMetroInstalled()) {
                for (String entry : METRO_LIBRARIES) {
                    File f = Hk2JaxWsStack.getWsJarName(Hk2JaxWsStack.this.gfRootStr, entry);
                    if (f == null || !f.exists()) continue;
                    try {
                        cPath.add(f.toURI().toURL());
                    }
                    catch (MalformedURLException ex) {
                        // empty catch block
                    }
                }
            }
            return cPath.toArray(new URL[cPath.size()]);
        }
    }
}

